<div class="card mb-4">
    <div class="card-header">
        <h5 class="mb-0">Foto de perfil</h5>
    </div>
    <div class="card-body">
        <form wire:submit.prevent="save">
            <div class="d-flex flex-column align-items-center">
                <!-- Vista previa del avatar -->
                <div class="mb-3 position-relative">
                    @if($tempAvatar)
                        <img src="{{ $tempAvatar }}" class="rounded-circle border" width="150" height="150" alt="Vista previa" style="object-fit: cover;">
                    @elseif($user->avatar)
                        <img src="{{ Storage::url($user->avatar) }}" class="rounded-circle border" width="150" height="150" alt="Avatar actual" style="object-fit: cover;">
                        <button type="button" wire:click="removeAvatar" class="btn btn-sm btn-danger position-absolute" style="top: 5px; right: 5px; border-radius: 50%; width: 30px; height: 30px; padding: 0;" title="Eliminar foto">
                            <i class="ri-close-line"></i>
                        </button>
                    @else
                        <div class="rounded-circle bg-primary d-flex justify-content-center align-items-center text-white" style="width: 150px; height: 150px;">
                            <i class="ri-user-line" style="font-size: 3rem;"></i>
                        </div>
                    @endif
                </div>

                <!-- Input para subir archivo (oculto) -->
                <input type="file" wire:model="avatar" class="d-none" accept="image/*" id="avatarInput">
                @error('avatar') <div class="text-danger mb-2">{{ $message }}</div> @enderror

                <!-- Botones -->
                <div class="d-flex gap-2 flex-wrap justify-content-center">
                    @if($avatar)
                        <button type="submit" class="btn btn-primary">
                            <i class="ri-save-line me-1"></i> Guardar
                        </button>
                        <button type="button" wire:click="$set('avatar', null)" class="btn btn-secondary">
                            <i class="ri-close-line me-1"></i> Cancelar
                        </button>
                    @else
                        <button type="button" class="btn btn-primary" onclick="document.getElementById('avatarInput').click()">
                            <i class="ri-camera-line me-1"></i> {{ $user->avatar ? 'Cambiar foto' : 'Subir foto' }}
                        </button>
                    @endif
                </div>
                
                <small class="text-muted mt-2 text-center">
                    Formatos permitidos: JPG, PNG, GIF<br>
                    Tamaño máximo: 2MB
                </small>
            </div>
        </form>
    </div>
</div>
