<div>
    <div>
        <div class="row">
            <div class="col-12">
                <div class="card shadow-sm border-0">
                    <div class="card-header bg-gradient-primary text-white">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-file-import me-2"></iconify-icon>
                            <h3 class="card-title mb-0">Importar Estudiantes</h3>
                        </div>
                    </div>
                    <div class="card-body">
                        @if (session()->has('message'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <i class="fas fa-check-circle me-2"></iconify-icon>
                                {{ session('message') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        @endif
                        
                        @if (session()->has('error'))
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <i class="fas fa-exclamation-circle me-2"></iconify-icon>
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        @endif

                        <!-- Paso 1: Cargar archivo -->
                        @if($importMode === 'preview')
                        <div class="mb-4">
                            <div class="d-flex align-items-center mb-3 mt-4">
                                <div class="step-indicator bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 30px; height: 30px;">1</div>
                                <h4 class="mb-0">Cargar Archivo</h4>
                            </div>
                            
                            <div class="file-upload-area border-2 border-dashed rounded p-4 text-center mb-3" style="border-style: dashed; cursor: pointer; transition: all 0.3s ease;" 
                                 onmouseover="this.style.backgroundColor='#f8f9fa'" onmouseout="this.style.backgroundColor=''">
                                <input type="file" class="d-none" wire:model="file" id="file" accept=".xlsx,.xls,.csv">
                                <label for="file" class="cursor-pointer">
                                    <i class="fas fa-cloud-upload-alt fa-3x text-muted mb-3"></iconify-icon>
                                    <h5 class="text-muted">Arrastra tu archivo aquí o haz clic para seleccionar</h5>
                                    <p class="text-muted small mb-0">Formatos aceptados: Excel (.xlsx, .xls) o CSV (.csv)</p>
                                </label>
                            </div>
                            
                            @if($file)
                                <div class="alert alert-info">
                                    <i class="fas fa-file-alt me-2"></iconify-icon>
                                    <strong>Archivo seleccionado:</strong> {{ $file->getClientOriginalName() }}
                                </div>
                            @endif
                            
                            @error('file') 
                                <div class="alert alert-danger">
                                    <i class="fas fa-exclamation-circle me-2"></iconify-icon>
                                    {{ $message }}
                                </div>
                            @enderror
                            
                            <div wire:loading wire:target="file" class="text-center">
                                <div class="spinner-border text-primary me-2" role="status">
                                    <span class="visually-hidden">Cargando...</span>
                                </div>
                                <span>Analizando archivo...</span>
                            </div>
                        </div>
                        @endif

                        <!-- Configuración de importación -->
                        @if($preview && $importMode === 'preview')
                        <div class="mb-4">
                            <div class="d-flex align-items-center mb-3">
                                <div class="step-indicator bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 30px; height: 30px;">2</div>
                                <h4 class="mb-0">Configuración de Importación</h4>
                            </div>
                            
                            <div class="row g-3">
                                <div class="col-md-4">
                                    <div class="card h-100 border-0 shadow-sm">
                                        <div class="card-body text-center">
                                            <div class="form-check form-switch d-flex justify-content-center mb-2">
                                                <input type="checkbox" class="form-check-input me-2" wire:model="updateExisting" id="updateExisting">
                                                <label class="form-check-label fw-bold" for="updateExisting">
                                                    Actualizar estudiantes existentes
                                                </label>
                                            </div>
                                            <small class="text-muted">Si un estudiante ya existe, actualizará sus datos</small>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="card h-100 border-0 shadow-sm">
                                        <div class="card-body text-center">
                                            <div class="form-check form-switch d-flex justify-content-center mb-2">
                                                <input type="checkbox" class="form-check-input me-2" wire:model="fillMissingWithNA" id="fillMissingWithNA">
                                                <label class="form-check-label fw-bold" for="fillMissingWithNA">
                                                    Llenar datos faltantes
                                                </label>
                                            </div>
                                            <small class="text-muted">Completará campos vacíos con 'n/a'</small>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="card h-100 bg-info bg-opacity-10 border-0">
                                        <div class="card-body text-center">
                                            <div class="d-flex align-items-center justify-content-center mb-2">
                                                <i class="fas fa-table text-info me-2"></iconify-icon>
                                                <h5 class="mb-0 text-info">Total de filas</h5>
                                            </div>
                                            <h3 class="text-info mb-0">{{ number_format($totalRows) }}</h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif

                        <!-- Vista previa de datos con selección -->
                        @if($processedData && $importMode === 'preview')
                            <div class="mb-4">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="step-indicator bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 30px; height: 30px;">3</div>
                                    <h4 class="mb-0">Vista Previa y Selección de Filas</h4>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <div class="input-group">
                                            <span class="input-group-text">
                                                <input type="checkbox" class="form-check-input" wire:model="selectAll" wire:change="toggleSelectAll" id="selectAll">
                                            </span>
                                            <label class="form-control" for="selectAll">
                                                Seleccionar todas las filas
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-6 text-end">
                                        <span class="badge bg-primary fs-6">
                                            <i class="fas fa-check me-1"></iconify-icon>
                                            {{ count($selectedRows) }} de {{ $totalRows }} filas seleccionadas
                                        </span>
                                    </div>
                                </div>
                                
                                <div class="table-responsive border rounded">
                                    <table class="table table-hover table-sm mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th style="width: 50px;" class="text-center">
                                                    <input type="checkbox" wire:model="selectAll" wire:change="toggleSelectAll" class="form-check-input">
                                                </th>
                                                <th style="width: 60px;" class="text-center">#</th>
                                                <th style="width: 100px;" class="text-center">Estado</th>
                                                @foreach($preview['headers'] as $header)
                                                    <th class="fw-semibold">{{ $header }}</th>
                                                @endforeach
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($processedData as $index => $rowData)
                                                <tr class="@if(count($validationErrors[$index]) > 0) table-danger border-danger @elseif(isset($rowData['existing_student']) && $rowData['existing_student']) table-warning border-warning @endif">
                                                    <td class="text-center">
                                                        <input type="checkbox" wire:model="selectedRows" value="{{ $index }}" wire:change="toggleRowSelection({{ $index }})" class="form-check-input">
                                                    </td>
                                                    <td class="text-center fw-bold">{{ $index + 1 }}</td>
                                                    <td class="text-center">
                                                        @if(count($validationErrors[$index]) > 0)
                                                            <span class="badge bg-danger" data-bs-toggle="tooltip" title="{{ implode(', ', $validationErrors[$index]) }}">
                                                                <i class="fas fa-exclamation-triangle me-1"></iconify-icon>Error
                                                            </span>
                                                        @elseif(isset($rowData['existing_student']) && $rowData['existing_student'])
                                                            <span class="badge bg-warning text-dark">
                                                                <i class="fas fa-user-check me-1"></iconify-icon>Existe
                                                            </span>
                                                        @else
                                                            <span class="badge bg-success">
                                                                <i class="fas fa-user-plus me-1"></iconify-icon>Nuevo
                                                            </span>
                                                        @endif
                                                    </td>
                                                    @foreach($preview['rows'][$index] ?? [] as $cell)
                                                        <td class="small">{{ Str::limit($cell, 30) }}</td>
                                                    @endforeach
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                
                                @if(count($selectedRows) > 0)
                                    <div class="row mt-3">
                                        <div class="col-md-4">
                                            <div class="card border-success bg-success bg-opacity-10">
                                                <div class="card-body text-center">
                                                    <h5 class="text-success mb-1">
                                                        <i class="fas fa-user-plus"></iconify-icon>
                                                        {{ collect($selectedRows)->filter(function($index) use ($processedData) { return !($processedData[$index]['existing_student'] ?? false); })->count() }}
                                                    </h5>
                                                    <small class="text-muted">Estudiantes nuevos</small>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="card border-warning bg-warning bg-opacity-10">
                                                <div class="card-body text-center">
                                                    <h5 class="text-warning mb-1">
                                                        <i class="fas fa-user-check"></iconify-icon>
                                                        {{ collect($selectedRows)->filter(function($index) use ($processedData) { return $processedData[$index]['existing_student'] ?? false; })->count() }}
                                                    </h5>
                                                    <small class="text-muted">Estudiantes existentes</small>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="card border-danger bg-danger bg-opacity-10">
                                                <div class="card-body text-center">
                                                    <h5 class="text-danger mb-1">
                                                        <i class="fas fa-exclamation-triangle"></iconify-icon>
                                                        {{ collect($selectedRows)->filter(function($index) use ($validationErrors) { return count($validationErrors[$index]) > 0; })->count() }}
                                                    </h5>
                                                    <small class="text-muted">Filas con errores</small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        @endif

                        <!-- Paso de mapeo de columnas -->
                        @if($importMode === 'mapping' || ($preview && $importMode === 'preview'))
                            <div class="mb-4">
                                <div class="d-flex align-items-center mb-4">
                                    <div class="step-indicator bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 30px; height: 30px;">4</div>
                                    <div>
                                        <h4 class="mb-0">Mapeo de Columnas</h4>
                                        <p class="text-muted mb-0">Asigna las columnas de tu archivo a los campos del sistema</p>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="card border-primary border-opacity-25 h-100">
                                            <div class="card-header bg-primary bg-opacity-10">
                                                <h6 class="mb-0 text-primary">
                                                    <i class="fas fa-user-graduate me-2"></iconify-icon>Datos del Estudiante
                                                </h6>
                                            </div>
                                            <div class="card-body">
                                                <div class="mb-3">
                                                    <label class="form-label fw-semibold">Nombres *</label>
                                                    <select class="form-select form-select-sm" wire:model="columnMapping.nombres">
                                                        <option value="">Seleccionar columna...</option>
                                                        @foreach($preview['headers'] as $index => $header)
                                                            <option value="{{ $index }}">{{ $header }}</option>
                                                        @endforeach
                                                    </select>
                                                    @error('columnMapping.nombres') <span class="text-danger small">{{ $message }}</span> @enderror
                                                </div>

                                                <div class="mb-3">
                                                    <label class="form-label fw-semibold">Apellidos *</label>
                                                    <select class="form-select form-select-sm" wire:model="columnMapping.apellidos">
                                                        <option value="">Seleccionar columna...</option>
                                                        @foreach($preview['headers'] as $index => $header)
                                                            <option value="{{ $index }}">{{ $header }}</option>
                                                        @endforeach
                                                    </select>
                                                    @error('columnMapping.apellidos') <span class="text-danger small">{{ $message }}</span> @enderror
                                                </div>

                                                <div class="mb-3">
                                                    <label class="form-label fw-semibold">Documento de Identidad *</label>
                                                    <select class="form-select form-select-sm" wire:model="columnMapping.documento_identidad">
                                                        <option value="">Seleccionar columna...</option>
                                                        @foreach($preview['headers'] as $index => $header)
                                                            <option value="{{ $index }}">{{ $header }}</option>
                                                        @endforeach
                                                    </select>
                                                    @error('columnMapping.documento_identidad') <span class="text-danger small">{{ $message }}</span> @enderror
                                                </div>

                                                <div class="mb-3">
                                                    <label class="form-label fw-semibold">Fecha de Nacimiento</label>
                                                    <select class="form-select form-select-sm" wire:model="columnMapping.fecha_nacimiento">
                                                        <option value="">Seleccionar columna...</option>
                                                        @foreach($preview['headers'] as $index => $header)
                                                            <option value="{{ $index }}">{{ $header }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div class="mb-3">
                                                    <label class="form-label fw-semibold">Grado *</label>
                                                    <select class="form-select form-select-sm" wire:model="columnMapping.grado">
                                                        <option value="">Seleccionar columna...</option>
                                                        @foreach($preview['headers'] as $index => $header)
                                                            <option value="{{ $index }}">{{ $header }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div class="mb-3">
                                                    <label class="form-label fw-semibold">Sección *</label>
                                                    <select class="form-select form-select-sm" wire:model="columnMapping.seccion">
                                                        <option value="">Seleccionar columna...</option>
                                                        @foreach($preview['headers'] as $index => $header)
                                                            <option value="{{ $index }}">{{ $header }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="card border-success border-opacity-25 h-100">
                                            <div class="card-header bg-success bg-opacity-10">
                                                <h6 class="mb-0 text-success">
                                                    <i class="fas fa-user-friends me-2"></iconify-icon>Datos del Representante
                                                </h6>
                                            </div>
                                            <div class="card-body">
                                                <div class="mb-3">
                                                    <label class="form-label fw-semibold">Nivel Educativo</label>
                                                    <select class="form-select form-select-sm" wire:model="columnMapping.nivel_educativo">
                                                        <option value="">Seleccionar columna...</option>
                                                        @foreach($preview['headers'] as $index => $header)
                                                            <option value="{{ $index }}">{{ $header }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div class="mb-3">
                                                    <label class="form-label fw-semibold">Turno</label>
                                                    <select class="form-select form-select-sm" wire:model="columnMapping.turno">
                                                        <option value="">Seleccionar columna...</option>
                                                        @foreach($preview['headers'] as $index => $header)
                                                            <option value="{{ $index }}">{{ $header }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div class="mb-3">
                                                    <label class="form-label fw-semibold">Período Escolar</label>
                                                    <select class="form-select form-select-sm" wire:model="columnMapping.school_period">
                                                        <option value="">Seleccionar columna...</option>
                                                        @foreach($preview['headers'] as $index => $header)
                                                            <option value="{{ $index }}">{{ $header }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div class="mb-3">
                                                    <label class="form-label fw-semibold">Correo Electrónico</label>
                                                    <select class="form-select form-select-sm" wire:model="columnMapping.correo_electronico">
                                                        <option value="">Seleccionar columna...</option>
                                                        @foreach($preview['headers'] as $index => $header)
                                                            <option value="{{ $index }}">{{ $header }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div class="mb-3">
                                                    <label class="form-label fw-semibold">Representante - Nombres</label>
                                                    <select class="form-select form-select-sm" wire:model="columnMapping.representante_nombres">
                                                        <option value="">Seleccionar columna...</option>
                                                        @foreach($preview['headers'] as $index => $header)
                                                            <option value="{{ $index }}">{{ $header }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div class="mb-3">
                                                    <label class="form-label fw-semibold">Representante - Apellidos</label>
                                                    <select class="form-select form-select-sm" wire:model="columnMapping.representante_apellidos">
                                                        <option value="">Seleccionar columna...</option>
                                                        @foreach($preview['headers'] as $index => $header)
                                                            <option value="{{ $index }}">{{ $header }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div class="mb-3">
                                                    <label class="form-label fw-semibold">Representante - Documento</label>
                                                    <select class="form-select form-select-sm" wire:model="columnMapping.representante_documento_identidad">
                                                        <option value="">Seleccionar columna...</option>
                                                        @foreach($preview['headers'] as $index => $header)
                                                            <option value="{{ $index }}">{{ $header }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div class="mb-3">
                                                    <label class="form-label fw-semibold">Representante - Teléfonos</label>
                                                    <select class="form-select form-select-sm" wire:model="columnMapping.representante_telefonos">
                                                        <option value="">Seleccionar columna...</option>
                                                        @foreach($preview['headers'] as $index => $header)
                                                            <option value="{{ $index }}">{{ $header }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div class="mb-3">
                                                    <label class="form-label fw-semibold">Representante - Correo</label>
                                                    <select class="form-select form-select-sm" wire:model="columnMapping.representante_correo">
                                                        <option value="">Seleccionar columna...</option>
                                                        @foreach($preview['headers'] as $index => $header)
                                                            <option value="{{ $index }}">{{ $header }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="alert alert-info border-start-4 border-start-info mt-4">
                                    <div class="d-flex align-items-center">
                                        <i class="fas fa-info-circle fs-4 me-3 text-info"></iconify-icon>
                                        <div>
                                            <h6 class="mb-1">Instrucciones de Mapeo</h6>
                                            <ul class="mb-0 small">
                                                <li>Los campos marcados con * son obligatorios</li>
                                                <li>Selecciona la columna correspondiente para cada campo</li>
                                                <li>Los campos no mapeados se llenarán con 'n/a' si está habilitado</li>
                                                <li>Los estudiantes existentes se actualizarán si está habilitado</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                
                                
                            </div>
                        @endif

                        <!-- Botones de acción -->
                        <div class="d-flex justify-content-between">
                            <button type="button" class="btn btn-secondary" wire:click="resetImport">
                                <i class="fas fa-redo"></iconify-icon> Reiniciar
                            </button>
                            
                            @if($importMode === 'preview' && $preview && count($selectedRows) > 0)
                                <button type="button" class="btn btn-info" wire:click="proceedToMapping">
                                    <i class="fas fa-cogs"></iconify-icon> Configurar Mapeo
                                </button>
                            @elseif($importMode === 'mapping')
                                <button type="button" class="btn btn-primary" wire:click="proceedToImport" @if($importing) disabled @endif>
                                    <i class="fas fa-upload"></iconify-icon> Importar Estudiantes
                                    <div wire:loading wire:target="import" class="spinner-border spinner-border-sm ms-2" role="status">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                </button>
                            @endif
                        </div>

                        <!-- Progreso de importación -->
                        @if($importMode === 'importing')
                            <div class="mb-4">
                                <div class="d-flex align-items-center mb-4">
                                    <div class="step-indicator bg-success text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 30px; height: 30px;">5</div>
                                    <div>
                                        <h4 class="mb-0">Progreso de Importación</h4>
                                        <p class="text-muted mb-0">Procesando {{ count($selectedRows) }} filas seleccionadas</p>
                                    </div>
                                </div>
                                
                                <div class="progress mb-4" style="height: 30px;">
                                    <div class="progress-bar progress-bar-striped progress-bar-animated bg-success" 
                                         role="progressbar" 
                                         style="width: {{ $importProgress }}%" 
                                         aria-valuenow="{{ $importProgress }}" 
                                         aria-valuemin="0" 
                                         aria-valuemax="100">
                                        <span class="fs-6 fw-bold">{{ $importProgress }}% Completado</span>
                                    </div>
                                </div>
                                
                                <div class="row g-3 mb-4">
                                    <div class="col-md-3">
                                        <div class="card border-success bg-success bg-opacity-10 text-center h-100">
                                            <div class="card-body py-3">
                                                <div class="mb-2">
                                                    <i class="fas fa-check-circle fs-2 text-success"></iconify-icon>
                                                </div>
                                                <h4 class="text-success mb-1 fw-bold">{{ $importedRows }}</h4>
                                                <p class="text-muted mb-0 small">Estudiantes importados</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card border-danger bg-danger bg-opacity-10 text-center h-100">
                                            <div class="card-body py-3">
                                                <div class="mb-2">
                                                    <i class="fas fa-times-circle fs-2 text-danger"></iconify-icon>
                                                </div>
                                                <h4 class="text-danger mb-1 fw-bold">{{ $failedRows }}</h4>
                                                <p class="text-muted mb-0 small">Importaciones fallidas</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card border-info bg-info bg-opacity-10 text-center h-100">
                                            <div class="card-body py-3">
                                                <div class="mb-2">
                                                    <i class="fas fa-list fs-2 text-info"></iconify-icon>
                                                </div>
                                                <h4 class="text-info mb-1 fw-bold">{{ count($selectedRows) }}</h4>
                                                <p class="text-muted mb-0 small">Filas seleccionadas</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card border-primary bg-primary bg-opacity-10 text-center h-100">
                                            <div class="card-body py-3">
                                                <div class="mb-2">
                                                    <i class="fas fa-cogs fs-2 text-primary"></iconify-icon>
                                                </div>
                                                <h4 class="text-primary mb-1 fw-bold">{{ $importedRows + $failedRows }}</h4>
                                                <p class="text-muted mb-0 small">Total procesado</p>
                                                <small class="text-muted">{{ count($selectedRows) > 0 ? round((($importedRows + $failedRows) / count($selectedRows)) * 100) : 0 }}%</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                @if(count($errorsList) > 0)
                                    <div class="card border-danger">
                                        <div class="card-header bg-danger bg-opacity-10">
                                            <h6 class="mb-0 text-danger">
                                                <i class="fas fa-exclamation-triangle me-2"></iconify-icon>
                                                Errores de Importación ({{ count($errorsList) }})
                                            </h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="max-height-300 overflow-auto">
                                                @foreach($errorsList as $error)
                                                    <div class="alert alert-danger alert-sm border-0 mb-2">
                                                        <div class="d-flex align-items-start">
                                                            <i class="fas fa-times-circle mt-1 me-2"></iconify-icon>
                                                            <div class="flex-grow-1">
                                                                <strong>Fila {{ $error['row'] }}:</strong> {{ $error['error'] }}
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                
                                @if($importProgress >= 100)
                                    <div class="text-center mt-4">
                                        <div class="alert alert-success border-start-4 border-start-success mb-3">
                                            <div class="d-flex align-items-center">
                                                <i class="fas fa-check-circle fs-4 me-3 text-success"></iconify-icon>
                                                <div>
                                                    <h6 class="mb-1">¡Importación Completada!</h6>
                                                    <p class="mb-0">Se han procesado todas las filas seleccionadas exitosamente.</p>
                                                </div>
                                            </div>
                                        </div>
                                        <button type="button" class="btn btn-success btn-lg px-4" wire:click="resetImport">
                                            <i class="fas fa-check me-2"></iconify-icon> Finalizar Importación
                                        </button>
                                    </div>
                                @endif
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>