<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h4 class="fw-bold text-primary mb-1">
                        <i class="ri-bar-chart-line me-2"></i>Reportes POS
                    </h4>
                    <p class="text-muted mb-0">Análisis de ventas del punto de venta</p>
                </div>
                <div>
                    <button class="btn btn-success" wire:click="exportar">
                        <i class="ri-download-line me-1"></i>Exportar CSV
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtros -->
    <div class="card mb-4">
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Fecha Inicio</label>
                    <input type="date" class="form-control" wire:model="fechaInicio">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Fecha Fin</label>
                    <input type="date" class="form-control" wire:model="fechaFin">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Caja</label>
                    <select class="form-select" wire:model="cajaId">
                        <option value="">Todas</option>
                        @foreach($cajas as $caja)
                            <option value="{{ $caja->id }}">{{ $caja->nombre }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Método Pago</label>
                    <select class="form-select" wire:model="metodoPago">
                        <option value="">Todos</option>
                        <option value="efectivo">Efectivo</option>
                        <option value="tarjeta">Tarjeta</option>
                        <option value="transferencia">Transferencia</option>
                        <option value="pago_movil">Pago Móvil</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Documento</label>
                    <select class="form-select" wire:model="tipoDocumento">
                        <option value="">Todos</option>
                        <option value="boleta">Boleta</option>
                        <option value="factura">Factura</option>
                    </select>
                </div>
            </div>
        </div>
    </div>

    <!-- Resumen -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="text-primary mb-2">
                        <i class="ri-shopping-cart-line" style="font-size: 2rem;"></i>
                    </div>
                    <h4 class="fw-bold">{{ $resumen['total_ventas'] }}</h4>
                    <p class="text-muted mb-0">Total Ventas</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="text-success mb-2">
                        <i class="ri-money-dollar-circle-line" style="font-size: 2rem;"></i>
                    </div>
                    <h4 class="fw-bold">{{ format_money($resumen['monto_total']) }}</h4>
                    <p class="text-muted mb-0">Monto Total</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="text-info mb-2">
                        <i class="ri-calculator-line" style="font-size: 2rem;"></i>
                    </div>
                    <h4 class="fw-bold">{{ format_money($resumen['promedio_venta']) }}</h4>
                    <p class="text-muted mb-0">Promedio por Venta</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="text-warning mb-2">
                        <i class="ri-time-line" style="font-size: 2rem;"></i>
                    </div>
                    <h4 class="fw-bold">{{ Carbon\Carbon::parse($fechaInicio)->diffInDays(Carbon\Carbon::parse($fechaFin)) + 1 }}</h4>
                    <p class="text-muted mb-0">Días Analizados</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Gráficos -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="fw-bold mb-0">Ventas por Método de Pago</h6>
                </div>
                <div class="card-body">
                    @foreach($resumen['por_metodo_pago'] as $metodo)
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <span class="text-capitalize">{{ str_replace('_', ' ', $metodo->metodo_pago) }}</span>
                            <div class="d-flex align-items-center gap-2">
                                <span class="badge bg-primary">{{ $metodo->cantidad }}</span>
                                <span class="fw-bold">{{ format_money($metodo->total) }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="fw-bold mb-0">Ventas por Tipo de Documento</h6>
                </div>
                <div class="card-body">
                    @foreach($resumen['por_tipo_documento'] as $tipo)
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <span class="text-capitalize">{{ $tipo->tipo_documento }}</span>
                            <div class="d-flex align-items-center gap-2">
                                <span class="badge bg-success">{{ $tipo->cantidad }}</span>
                                <span class="fw-bold">{{ format_money($tipo->total) }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <!-- Tabla de ventas -->
    <div class="card">
        <div class="card-header">
            <h6 class="fw-bold mb-0">Detalle de Ventas</h6>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>Fecha</th>
                            <th>Documento</th>
                            <th>Cliente</th>
                            <th>Total</th>
                            <th>Método Pago</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($ventas as $venta)
                            <tr>
                                <td>{{ $venta->created_at->format('d/m/Y H:i') }}</td>
                                <td>
                                    <span class="badge bg-info">
                                        {{ $venta->serie->serie }}-{{ str_pad($venta->numero_documento, 8, '0', STR_PAD_LEFT) }}
                                    </span>
                                </td>
                                <td>{{ $venta->user->name ?? 'Cliente General' }}</td>
                                <td class="fw-bold text-success">{{ format_money($venta->total) }}</td>
                                <td>
                                    <span class="badge bg-secondary text-capitalize">
                                        {{ str_replace('_', ' ', $venta->pagos->first()->metodo_pago ?? '') }}
                                    </span>
                                </td>
                                <td>
                                    <span class="badge bg-success">{{ ucfirst($venta->estado) }}</span>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <button class="btn btn-outline-primary" wire:click="verDetalle({{ $venta->id }})" title="Ver detalle">
                                            <i class="ri-eye-line"></i>
                                        </button>
                                        <button class="btn btn-outline-success" wire:click="imprimirRecibo({{ $venta->id }})" title="Imprimir">
                                            <i class="ri-printer-line"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="ri-inbox-line" style="font-size: 3rem;"></i>
                                        <p class="mt-2">No hay ventas en el período seleccionado</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($ventas->hasPages())
            <div class="card-footer">
                {{ $ventas->links() }}
            </div>
        @endif
    </div>
</div>