<!-- Modal Abrir Caja -->
@if($showModalAbrirCaja)
    <div class="modal fade show d-block modal-enhanced" tabindex="-1" style="background-color: rgba(0,0,0,0.5);">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 shadow-lg modal-content-enhanced">
                <div class="modal-header bg-white border-0">
                    <h5 class="modal-title fw-bold text-dark">
                        <i class="ri-safe-line me-2 text-primary"></i>Abrir Caja
                    </h5>
                    <button type="button" class="btn-close" wire:click="cerrarModalCaja"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Monto Inicial</label>
                        <div class="input-group input-group-lg">
                            <span class="input-group-text">{{ get_current_currency_symbol() }}</span>
                            <input type="number" class="form-control" wire:model.live="montoInicial" step="0.01" min="0" autofocus>
                        </div>
                        @error('montoInicial') <div class="text-danger small">{{ $message }}</div> @enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Observaciones</label>
                        <textarea class="form-control" wire:model.live="observaciones" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="cerrarModalCaja">Cancelar</button>
                    <button type="button" class="btn btn-primary" wire:click="abrirCaja">Abrir Caja</button>
                </div>
            </div>
        </div>
    </div>
@endif

<!-- Modal Variantes -->
@if($showVariantsModal && $selectedProductForVariants)
    @include('livewire.admin.pos.partials.modal-variants')
@endif

<!-- Modal de Pago -->
@if($showPaymentModal)
    @include('livewire.admin.pos.partials.modal-payment')
@endif

<!-- Modal Detalle Caja -->
@if($showModalDetalleCaja && $cajaAbierta)
    @include('livewire.admin.pos.partials.modal-detalle-caja')
@endif

<!-- Modal Salida Dinero -->
@if($showModalSalidaDinero)
    @include('livewire.admin.pos.partials.modal-salida-dinero')
@endif
