<div class="row">
    <!-- Panel Izquierdo: Productos Mejorado -->
    <div class="col-lg-6">
        <div class="card border-0 shadow-lg h-100 catalog-enhanced">
            <div class="card-header bg-gradient-primary text-white border-0">
                <h6 class="mb-0 fw-bold text-white">
                    <i class="ri-store-3-line me-2"></i>Catálogo de Productos
                    @if(count($searchResults) > 0)
                        <span class="badge bg-white text-primary ms-2">{{ count($searchResults) }}</span>
                    @endif
                </h6>
            </div>
            
            <div class="card-body p-0">
                <!-- Sección de Búsqueda Mejorada -->
                <div class="search-section p-3 bg-light border-bottom">
                    <!-- Búsqueda por código de barras -->
                    <div class="mb-3">
                        <div class="input-group input-group-lg">
                            <span class="input-group-text bg-primary text-white border-0">
                                <i class="ri-barcode-box-line"></i>
                            </span>
                            <input type="text" class="form-control border-0 shadow-sm" 
                                   placeholder="Escanear código de barras..."
                                   wire:model.live="barcode" data-barcode-input autocomplete="off">
                            @if($barcode)
                                <button class="btn btn-outline-secondary border-0" wire:click="$set('barcode', '')">
                                    <i class="ri-close-line"></i>
                                </button>
                            @endif
                        </div>
                    </div>

                    <!-- Búsqueda por texto -->
                    <div class="mb-3">
                        <div class="input-group">
                            <span class="input-group-text bg-white border-end-0">
                                <i class="ri-search-2-line text-primary"></i>
                            </span>
                            <input type="text" class="form-control border-start-0 shadow-sm" 
                                   placeholder="Buscar productos por nombre, descripción..."
                                   wire:model.live.debounce.300ms="search">
                            @if($search)
                                <button class="btn btn-outline-secondary border-0" wire:click="$set('search', '')">
                                    <i class="ri-close-line"></i>
                                </button>
                            @endif
                        </div>
                    </div>

                    <!-- Filtros Mejorados -->
                    <div class="row g-2">
                        <div class="col-6">
                            <select class="form-select shadow-sm border-0" wire:model.live="categoriaFilter">
                                <option value="">Todas las categorías</option>
                                @foreach($categorias as $categoria)
                                    <option value="{{ $categoria->id }}">{{ $categoria->nombre }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-6">
                            <select class="form-select shadow-sm border-0" wire:model.live="marcaFilter">
                                <option value="">Todas las marcas</option>
                                @foreach($marcas as $marca)
                                    <option value="{{ $marca->id }}">{{ $marca->nombre }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                <!-- Grid de Productos Mejorado -->
                <div class="products-container" style="height: 600px; overflow-y: auto;">
                    @if(count($searchResults) > 0)
                        <div class="products-grid p-3">
                            @foreach($searchResults as $result)
                                <div class="product-card-enhanced mb-3" wire:click="addToCart({{ $result['id'] }})">
                                    <div class="card border-0 shadow-sm h-100 product-item">
                                        <div class="row g-0 align-items-center">
                                            <!-- Imagen del Producto -->
                                            <div class="col-4">
                                                <div class="product-image-wrapper position-relative">
                                                    @if($result['image_path'])
                                                        <img src="{{ asset('app/'.$result['image_path']) }}" 
                                                             class="img-fluid product-image" 
                                                             style="height: 80px; width: 100%; object-fit: cover; border-radius: 12px 0 0 12px;">
                                                    @else
                                                        <div class="bg-gradient-light d-flex align-items-center justify-content-center" 
                                                             style="height: 80px; width: 100%; border-radius: 12px 0 0 12px;">
                                                            <i class="ri-image-2-line text-muted" style="font-size: 2rem;"></i>
                                                        </div>
                                                    @endif
                                                    
                                                    <!-- Badges sobre la imagen -->
                                                    <div class="position-absolute top-0 start-0 p-2">
                                                        @if($result['has_variants'])
                                                            <span class="badge bg-info-subtle text-info border border-info">
                                                                <i class="ri-list-check-3"></i>
                                                            </span>
                                                        @endif
                                                    </div>
                                                    
                                                    <!-- Stock badge -->
                                                    <div class="position-absolute bottom-0 end-0 p-2">
                                                        <span class="badge {{ $result['quantity'] > 10 ? 'bg-success' : ($result['quantity'] > 0 ? 'bg-warning text-dark' : 'bg-danger') }}">
                                                            {{ $result['quantity'] }}
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <!-- Información del Producto -->
                                            <div class="col-8">
                                                <div class="card-body p-3">
                                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                                        <div class="flex-grow-1">
                                                            <h6 class="card-title mb-1 fw-bold text-dark" style="font-size: 0.95rem; line-height: 1.3;">
                                                                {{ $result['name'] }}
                                                            </h6>
                                                            <p class="card-text small text-muted mb-2">{{ $result['code'] }}</p>
                                                        </div>
                                                        
                                                        <!-- Botón de acción -->
                                                        <button class="btn btn-primary btn-sm rounded-circle add-btn" 
                                                                style="width: 36px; height: 36px;">
                                                            <i class="ri-add-line fw-bold"></i>
                                                        </button>
                                                    </div>
                                                    
                                                    <!-- Precio destacado -->
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div class="price-section">
                                                            <span class="h6 mb-0 fw-bold text-success">{{ format_money($result['price']) }}</span>
                                                        </div>
                                                        
                                                        <!-- Indicadores adicionales -->
                                                        <div class="d-flex gap-1">
                                                            @if($result['quantity'] <= 5 && $result['quantity'] > 0)
                                                                <i class="ri-alert-line text-warning" title="Stock bajo"></i>
                                                            @elseif($result['quantity'] == 0)
                                                                <i class="ri-close-circle-line text-danger" title="Sin stock"></i>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="empty-catalog d-flex flex-column align-items-center justify-content-center" style="height: 100%;">
                            <div class="empty-icon mb-3">
                                <i class="ri-search-2-line text-muted" style="font-size: 4rem; opacity: 0.5;"></i>
                            </div>
                            <h6 class="text-muted mb-2">No se encontraron productos</h6>
                            <p class="text-muted text-center small mb-0">
                                Intenta buscar con otros términos o<br>
                                escanea el código de barras del producto
                            </p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Panel Central: Carrito -->
    @include('livewire.admin.pos.partials.enhanced-cart')

    <!-- Panel Derecho: Ventas Recientes -->
    @include('livewire.admin.pos.partials.recent-sales')
</div>
