<!-- Panel Central: Carrito Mejorado -->
<div class="col-lg-6 my-5">
    <div class="card border-0 shadow-sm h-100">
        <div class="card-header bg-white border-bottom">
            <div class="d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-bold">
                    <i class="ri-shopping-cart-line me-2"></i>Carrito
                    <span class="badge bg-primary">{{ count($cart) }}</span>
                </h6>
                @if(count($cart) > 0)
                    <div class="dropdown">
                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            <i class="ri-more-line"></i>
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#" wire:click="clearCart">
                                <i class="ri-delete-bin-line me-2"></i>Limpiar Todo
                            </a></li>
                        </ul>
                    </div>
                @endif
            </div>
        </div>



        <div class="card-body p-0">
            <div class="cart-items" style="max-height: 450px; overflow-y: auto;" id="cart-container">
                @if(count($cart) > 0)
                    @foreach($cart as $index => $item)
                        <div class="cart-item border-bottom p-3" data-index="{{ $index }}" style="transition: all 0.3s ease;">
                            <div class="row align-items-start">
                                <!-- Imagen del producto -->
                                <div class="col-3">
                                    @if($item['image_path'] ?? null)
                                        <img src="{{ asset('app/'.$item['image_path']) }}" class="img-fluid rounded shadow-sm" style="height: 60px; width: 60px; object-fit: cover;">
                                    @else
                                        <div class="bg-light rounded d-flex align-items-center justify-content-center shadow-sm" style="height: 60px; width: 60px;">
                                            <i class="ri-image-line text-muted"></i>
                                        </div>
                                    @endif
                                    @if($item['es_variante'] ?? false)
                                        <span class="badge bg-info position-absolute" style="font-size: 0.6rem; top: -5px; right: -5px;">
                                            <i class="ri-list-check-2"></i>
                                        </span>
                                    @endif
                                </div>

                                <!-- Información del producto -->
                                <div class="col-9">
                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                        <div class="flex-grow-1">
                                            <h6 class="mb-0 small fw-bold text-truncate">{{ $item['nombre'] }}</h6>
                                            <small class="text-muted">{{ $item['codigo'] }}</small>
                                            @if(($item['stock_disponible'] ?? 0) <= 5)
                                                <span class="badge bg-warning text-dark small">
                                                    <i class="ri-alert-line"></i> Stock: {{ $item['stock_disponible'] ?? 0 }}
                                                </span>
                                            @endif
                                        </div>
                                        <div class="dropdown">
                                            <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                                <i class="ri-more-line"></i>
                                            </button>
                                            <ul class="dropdown-menu">
                                                <li><a class="dropdown-item" href="#" wire:click="addMoreSameProduct({{ $index }})">
                                                    <i class="ri-add-line me-2"></i>Agregar Más
                                                </a></li>
                                                <li><a class="dropdown-item" href="#" wire:click="duplicateCartItem({{ $index }})">
                                                    <i class="ri-file-copy-line me-2"></i>Duplicar
                                                </a></li>
                                                <li><hr class="dropdown-divider"></li>
                                                <li><a class="dropdown-item text-danger" href="#" wire:click="removeFromCart({{ $index }})">
                                                    <i class="ri-delete-bin-line me-2"></i>Eliminar
                                                </a></li>
                                            </ul>
                                        </div>
                                    </div>

                                    <!-- Cantidad y Precio -->
                                    <div class="row align-items-center mb-2">
                                        <div class="col-6">
                                            @if($editingQuantity[$index] ?? false)
                                                <div class="input-group input-group-sm">
                                                    <input type="number" class="form-control" value="{{ $item['cantidad'] }}"
                                                           wire:change="updateCartItemQuantity({{ $index }}, $event.target.value)"
                                                           wire:blur="toggleQuantityEdit({{ $index }})" min="1">
                                                    <button class="btn btn-outline-success" wire:click="toggleQuantityEdit({{ $index }})">
                                                        <i class="ri-check-line"></i>
                                                    </button>
                                                </div>
                                            @else
                                                <div class="btn-group btn-group-sm">
                                                    <button class="btn btn-outline-secondary" wire:click="decrementCartItem({{ $index }})">
                                                        <i class="ri-subtract-line"></i>
                                                    </button>
                                                    <button class="btn btn-outline-primary" wire:click="toggleQuantityEdit({{ $index }})">
                                                        {{ $item['cantidad'] }}
                                                    </button>
                                                    <button class="btn btn-outline-secondary" wire:click="incrementCartItem({{ $index }})">
                                                        <i class="ri-add-line"></i>
                                                    </button>
                                                </div>
                                            @endif
                                        </div>
                                        <div class="col-6 text-end">
                                            <div class="small text-muted">{{ format_money($item['precio_unitario']) }}</div>
                                            <div class="fw-bold text-success">{{ format_money($item['subtotal']) }}</div>
                                        </div>
                                    </div>

                                    <!-- Notas -->
                                    <div class="mb-0">
                                        <input type="text" class="form-control form-control-sm" placeholder="Notas del producto..."
                                               value="{{ $item['notas'] ?? '' }}"
                                               wire:change="updateCartItemNotes({{ $index }}, $event.target.value)">
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="text-center py-5">
                        <i class="ri-shopping-cart-line text-muted" style="font-size: 4rem;"></i>
                        <p class="text-muted mt-3">Carrito vacío</p>
                        <small class="text-muted">Los productos aparecerán aquí</small>
                    </div>
                @endif
            </div>
        </div>

        <!-- Footer del carrito -->
        <div class="card-footer bg-white">
            @if(count($cart) > 0)
                <!-- Descuento Global -->
                <div class="mb-3">
                    <label class="form-label small fw-bold text-muted">
                        <i class="ri-percent-line me-1"></i>Descuento Global
                    </label>
                    <div class="input-group">
                        <input type="number" class="form-control" placeholder="0" min="0" max="100"
                               value="{{ $globalDiscount }}"
                               wire:change="updateGlobalDiscount($event.target.value)">
                        <span class="input-group-text">%</span>
                    </div>
                </div>

                <!-- Resumen de totales -->
                <div class="mb-3">
                    <div class="d-flex justify-content-between small text-muted">
                        <span>Subtotal:</span>
                        <span>{{ format_money($this->getSubtotal()) }}</span>
                    </div>

                    @if($globalDiscount > 0)
                        <div class="d-flex justify-content-between small text-success">
                            <span>Descuento ({{ $globalDiscount }}%):</span>
                            <span>-{{ format_money($this->getDiscountAmount()) }}</span>
                        </div>
                        <hr class="my-2">
                    @endif

                    <div class="d-flex justify-content-between">
                        <span class="fw-bold">Total:</span>
                        <span class="h4 mb-0 fw-bold text-success">{{ format_money($this->getTotal()) }}</span>
                    </div>
                </div>
            @endif

            <div class="d-grid gap-2">
                <button class="btn btn-success btn-lg" wire:click="openPaymentModal" {{ count($cart) === 0 ? 'disabled' : '' }}>
                    <i class="ri-shopping-cart-2-line me-2"></i>Procesar Venta
                </button>
                @if(count($cart) > 0)
                    <button class="btn btn-outline-danger" wire:click="clearCart">
                        <i class="ri-close-line me-2"></i>Limpiar Carrito
                    </button>
                @endif
            </div>

            <!-- Configuración de hardware -->
            <div class="mt-3 p-2 bg-light rounded">
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="checkbox" wire:model.live="printerEnabled" id="printer">
                    <label class="form-check-label small" for="printer">
                        <i class="ri-printer-line me-1"></i>Impresora
                    </label>
                </div>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="checkbox" wire:model.live="cashDrawerEnabled" id="drawer">
                    <label class="form-check-label small" for="drawer">
                        <i class="ri-money-dollar-circle-line me-1"></i>Cajón
                    </label>
                </div>
            </div>
        </div>
    </div>
</div>
