<div>
    @if (session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if (session()->has('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @include('livewire.admin.pos.partials.header')

    @if (!$cajaAbierta)
        @include('livewire.admin.pos.partials.caja-cerrada')
    @else
        @include('livewire.admin.pos.partials.main-interface')
    @endif

    @include('livewire.admin.pos.partials.modals')
    @include('livewire.admin.pos.partials.modal-customer')
</div>

@push('scripts')
<script>
document.addEventListener('livewire:init', () => {
    // Removed barcode input focus functionality

    document.addEventListener('keydown', (e) => {
        if (e.key === 'F2') {
            e.preventDefault();
            @this.openPaymentModal();
        }
        if (e.key === 'F3') {
            e.preventDefault();
            @this.abrirModalCaja();
        }
        if (e.key === 'F4') {
            e.preventDefault();
            @this.abrirModalDetalleCaja();
        }
        if (e.key === 'F5') {
            e.preventDefault();
            @this.abrirModalSalidaDinero();
        }
        if (e.key === 'F9') {
            e.preventDefault();
            @this.openCustomerModal();
        }
        if (e.key === 'Escape') {
            @this.closeVariantsModal();
            @this.closePaymentModal();
            @this.closeCustomerModal();
            @this.cerrarModalCaja();
            @this.cerrarModalDetalleCaja();
            @this.cerrarModalSalidaDinero();
        }
    });

    // Cart animations
    Livewire.on('cart-item-added', () => {
        const cartItems = document.querySelectorAll('.cart-item');
        const lastItem = cartItems[cartItems.length - 1];
        if (lastItem) {
            lastItem.classList.add('adding');
            setTimeout(() => lastItem.classList.remove('adding'), 300);
        }
    });

    Livewire.on('cart-item-removing', (index) => {
        const item = document.querySelector(`[data-index="${index}"]`);
        if (item) {
            item.classList.add('removing');
            setTimeout(() => {
                @this.removeFromCart(index);
            }, 300);
        }
    });

    // Drag and Drop functionality
    function initDragAndDrop() {
        const cartContainer = document.getElementById('cart-container');
        if (!cartContainer) return;

        let draggedElement = null;

        cartContainer.addEventListener('dragstart', (e) => {
            if (e.target.classList.contains('cart-item')) {
                draggedElement = e.target;
                e.target.classList.add('dragging');
                e.dataTransfer.effectAllowed = 'move';
            }
        });

        cartContainer.addEventListener('dragend', (e) => {
            if (e.target.classList.contains('cart-item')) {
                e.target.classList.remove('dragging');
                document.querySelectorAll('.cart-item').forEach(item => {
                    item.classList.remove('drag-over');
                });
            }
        });

        cartContainer.addEventListener('dragover', (e) => {
            e.preventDefault();
            const afterElement = getDragAfterElement(cartContainer, e.clientY);
            const dragging = document.querySelector('.dragging');
            
            if (afterElement == null) {
                cartContainer.appendChild(dragging);
            } else {
                cartContainer.insertBefore(dragging, afterElement);
            }
        });

        cartContainer.addEventListener('dragenter', (e) => {
            if (e.target.classList.contains('cart-item') && e.target !== draggedElement) {
                e.target.classList.add('drag-over');
            }
        });

        cartContainer.addEventListener('dragleave', (e) => {
            if (e.target.classList.contains('cart-item')) {
                e.target.classList.remove('drag-over');
            }
        });

        // Make cart items draggable
        document.querySelectorAll('.cart-item').forEach(item => {
            item.draggable = true;
        });
    }

    function getDragAfterElement(container, y) {
        const draggableElements = [...container.querySelectorAll('.cart-item:not(.dragging)')];
        
        return draggableElements.reduce((closest, child) => {
            const box = child.getBoundingClientRect();
            const offset = y - box.top - box.height / 2;
            
            if (offset < 0 && offset > closest.offset) {
                return { offset: offset, element: child };
            } else {
                return closest;
            }
        }, { offset: Number.NEGATIVE_INFINITY }).element;
    }

    // Initialize drag and drop when cart updates
    Livewire.hook('morph.updated', () => {
        initDragAndDrop();
    });

    // Initialize on load
    initDragAndDrop();
});
</script>
@endpush

@push('styles')
<style>
/* Enhanced Catalog Styles */
.catalog-enhanced {
    border-radius: 16px !important;
    overflow: hidden;
}

.bg-gradient-light {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%) !important;
}

.search-section {
    background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%) !important;
}

.products-container {
    background: #ffffff;
}

.products-container::-webkit-scrollbar {
    width: 8px;
}

.products-container::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 4px;
}

.products-container::-webkit-scrollbar-thumb {
    background: #c1c1c1;
    border-radius: 4px;
}

.products-container::-webkit-scrollbar-thumb:hover {
    background: #a8a8a8;
}

.product-card-enhanced {
    cursor: pointer;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

.product-card-enhanced:hover {
    transform: translateY(-2px);
}

.product-item {
    border-radius: 12px !important;
    transition: all 0.3s ease;
    border: 1px solid rgba(0,0,0,0.08) !important;
}

.product-item:hover {
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
    border-color: #0d6efd !important;
}

.product-image {
    transition: transform 0.3s ease;
}

.product-item:hover .product-image {
    transform: scale(1.05);
}

.add-btn {
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(13, 110, 253, 0.3);
}

.add-btn:hover {
    transform: scale(1.1);
    box-shadow: 0 4px 15px rgba(13, 110, 253, 0.4);
}

.price-section {
    font-family: 'Segoe UI', system-ui, sans-serif;
}

.empty-catalog .empty-icon {
    animation: float 3s ease-in-out infinite;
}

@keyframes float {
    0%, 100% {
        transform: translateY(0px);
    }
    50% {
        transform: translateY(-10px);
    }
}

/* Search section improvements */
.search-section .form-control:focus,
.search-section .form-select:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.15);
}

.search-section .input-group-text {
    border: none;
}

/* Badge improvements */
.badge {
    font-size: 0.7rem;
    font-weight: 500;
    border-radius: 6px;
}

.bg-info-subtle {
    background-color: rgba(13, 202, 240, 0.1) !important;
}

.text-info {
    color: #0dcaf0 !important;
}

/* Enhanced Cart Styles */

/* Cart Animations */
.cart-item {
    transition: all 0.3s ease;
}
.cart-item:hover {
    background-color: #f8f9fa;
    transform: translateX(5px);
}

.cart-item.removing {
    opacity: 0;
    transform: translateX(-100%);
}

.cart-item.adding {
    animation: slideInRight 0.3s ease;
}

@keyframes slideInRight {
    from {
        opacity: 0;
        transform: translateX(100%);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

/* Favorite Products */
.favorite-product {
    transition: all 0.2s ease;
    border: 1px solid #e9ecef;
}
.favorite-product:hover {
    border-color: #0d6efd;
    transform: scale(1.02);
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

/* Drag and Drop */
.cart-item.dragging {
    opacity: 0.5;
    transform: rotate(5deg);
}

.cart-item.drag-over {
    border-top: 3px solid #0d6efd;
}

/* Enhanced Modals */
.modal-enhanced {
    animation: modalFadeIn 0.3s ease;
}

.modal-content-enhanced {
    animation: modalSlideIn 0.3s ease;
    border-radius: 15px;
}

@keyframes modalFadeIn {
    from {
        opacity: 0;
    }
    to {
        opacity: 1;
    }
}

@keyframes modalSlideIn {
    from {
        opacity: 0;
        transform: translateY(-50px) scale(0.9);
    }
    to {
        opacity: 1;
        transform: translateY(0) scale(1);
    }
}

/* Variant Modal Enhancements */
.product-showcase {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border: 1px solid rgba(0,0,0,0.05);
}

.product-main-image {
    transition: transform 0.3s ease;
}

.product-main-image:hover {
    transform: scale(1.05);
}

.variant-card {
    transition: all 0.2s ease;
}

.variant-card:hover {
    transform: translateY(-2px);
}

.variant-option {
    transition: all 0.3s ease;
    border-width: 2px !important;
}

.variant-option:hover {
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    transform: translateY(-1px);
}

.variant-option.border-primary {
    box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.15);
    background-color: rgba(13, 110, 253, 0.02) !important;
}

.selected-indicator {
    animation: selectedPulse 0.5s ease;
}

@keyframes selectedPulse {
    0% {
        transform: scale(0);
        opacity: 0;
    }
    50% {
        transform: scale(1.2);
    }
    100% {
        transform: scale(1);
        opacity: 1;
    }
}

.purchase-panel {
    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
    border: 1px solid rgba(0,0,0,0.08) !important;
}

.product-badges .badge {
    font-size: 0.75rem;
    font-weight: 500;
    padding: 0.5rem 0.75rem;
}

.price-display {
    font-family: 'Segoe UI', system-ui, sans-serif;
}

.quantity-selector .input-group-lg .form-control {
    font-size: 1.25rem;
    font-weight: 600;
}

.total-section {
    background: linear-gradient(135deg, rgba(25, 135, 84, 0.05) 0%, rgba(25, 135, 84, 0.02) 100%) !important;
}

.action-buttons .btn {
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border-radius: 8px;
}

/* Modal Header Improvements */
.modal-header {
    padding: 1.5rem 1.5rem 1rem 1.5rem;
    border-bottom: 1px solid rgba(0,0,0,0.08) !important;
}

.modal-title {
    font-size: 1.25rem;
    font-weight: 700;
}

.btn-close {
    font-size: 1rem;
    opacity: 0.6;
    transition: opacity 0.2s ease;
}

.btn-close:hover {
    opacity: 1;
}

/* Enhanced Form Controls */
.form-control:focus,
.form-select:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.15);
}

.input-group-lg .form-control {
    border-radius: 8px;
}

.input-group-lg .btn {
    border-radius: 8px;
}

/* Card Enhancements */
.card {
    border-radius: 12px;
    border: 1px solid rgba(0,0,0,0.08);
}

.rounded-3 {
    border-radius: 12px !important;
}

/* Badges */
.badge {
    font-size: 0.7rem;
}

/* Dropdown animations */
.dropdown-menu {
    animation: fadeInDown 0.2s ease;
}

@keyframes fadeInDown {
    from {
        opacity: 0;
        transform: translateY(-10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}
</style>
@endpush
