{{-- Scripts simplificados para hardware POS --}}
<script>
// Configuración básica de hardware POS
const POSHardware = {
    // Inicializar escáner de código de barras
    initBarcodeScanner() {
        document.addEventListener('keydown', (e) => {
            // Si estamos en un input o textarea, no interceptar
            if (e.target.tagName === 'INPUT' || e.target.tagName === 'TEXTAREA') {
                return;
            }

            // Si es un carácter imprimible y no es una tecla especial
            if (e.key && e.key.length === 1 && !e.ctrlKey && !e.altKey && !e.metaKey) {
                e.preventDefault();
                console.log('Tecla presionada:', e.key);
            }
        });
    }
};

// Inicializar cuando el DOM esté listo
document.addEventListener('DOMContentLoaded', function() {
    POSHardware.initBarcodeScanner();
    console.log('Hardware POS básico inicializado');
});
</script>
