<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pantalla del Cliente - POS</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            overflow: hidden;
        }

        .customer-display {
            height: 100vh;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            padding: 2rem;
        }

        .header {
            text-align: center;
            margin-bottom: 2rem;
        }

        .logo {
            font-size: 2.5rem;
            font-weight: bold;
            margin-bottom: 0.5rem;
        }

        .welcome {
            font-size: 1.2rem;
            opacity: 0.9;
        }

        .current-item {
            background: rgba(255, 255, 255, 0.1);
            border-radius: 15px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .item-name {
            font-size: 1.5rem;
            font-weight: bold;
            margin-bottom: 0.5rem;
        }

        .item-price {
            font-size: 2rem;
            font-weight: bold;
            color: #ffd700;
        }

        .total-section {
            background: rgba(255, 255, 255, 0.2);
            border-radius: 20px;
            padding: 2rem;
            text-align: center;
            backdrop-filter: blur(15px);
            border: 2px solid rgba(255, 255, 255, 0.3);
        }

        .total-label {
            font-size: 1.5rem;
            opacity: 0.9;
            margin-bottom: 1rem;
        }

        .total-amount {
            font-size: 4rem;
            font-weight: bold;
            color: #ffd700;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.3);
        }

        .items-list {
            max-height: 200px;
            overflow-y: auto;
            margin-bottom: 1rem;
        }

        .list-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.5rem 0;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .list-item:last-child {
            border-bottom: none;
        }

        .item-info {
            flex: 1;
        }

        .item-quantity {
            background: rgba(255, 255, 255, 0.2);
            border-radius: 10px;
            padding: 0.25rem 0.5rem;
            font-size: 0.9rem;
            margin-right: 1rem;
        }

        .item-subtotal {
            font-weight: bold;
            color: #ffd700;
        }

        .payment-info {
            background: rgba(255, 255, 255, 0.1);
            border-radius: 15px;
            padding: 1rem;
            margin-top: 1rem;
            text-align: center;
        }

        .payment-method {
            font-size: 1.2rem;
            margin-bottom: 0.5rem;
        }

        .change-amount {
            font-size: 1.5rem;
            font-weight: bold;
            color: #90ee90;
        }

        .idle-message {
            text-align: center;
            font-size: 1.5rem;
            opacity: 0.8;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% { opacity: 0.8; }
            50% { opacity: 1; }
        }

        .thank-you {
            text-align: center;
            font-size: 2rem;
            font-weight: bold;
            color: #90ee90;
            animation: fadeIn 1s ease-in;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>
</head>
<body>
    <div class="customer-display">
        <div class="header">
            <div class="logo">
                <i class="ri-store-2-line"></i>
                SERVITEC
            </div>
            <div class="welcome">
                Bienvenido a su tienda de confianza
            </div>
        </div>

        <div id="display-content">
            <div class="idle-message">
                <i class="ri-shopping-bag-3-line" style="font-size: 4rem; display: block; margin-bottom: 1rem;"></i>
                Escaneando productos...
            </div>
        </div>

        <div class="footer">
            <div class="text-center opacity-75">
                <small>Gracias por su preferencia</small>
            </div>
        </div>
    </div>

    <script>
        // Función para actualizar la pantalla del cliente
        function updateCustomerDisplay(data) {
            const content = document.getElementById('display-content');

            if (data.type === 'idle') {
                content.innerHTML = `
                    <div class="idle-message">
                        <i class="ri-shopping-bag-3-line" style="font-size: 4rem; display: block; margin-bottom: 1rem;"></i>
                        Escaneando productos...
                    </div>
                `;
            } else if (data.type === 'cart') {
                const items = data.items || [];
                const total = data.total || 0;

                let itemsHtml = '';
                if (items.length > 0) {
                    itemsHtml = `
                        <div class="items-list">
                            ${items.map(item => `
                                <div class="list-item">
                                    <div class="item-info">
                                        <div class="item-name">${item.nombre}</div>
                                    </div>
                                    <div class="item-quantity">x${item.cantidad}</div>
                                    <div class="item-subtotal">$${(item.subtotal || 0).toFixed(2)}</div>
                                </div>
                            `).join('')}
                        </div>
                    `;
                }

                content.innerHTML = `
                    ${itemsHtml}
                    <div class="total-section">
                        <div class="total-label">TOTAL</div>
                        <div class="total-amount">$${total.toFixed(2)}</div>
                    </div>
                `;
            } else if (data.type === 'payment') {
                const { total, paymentMethod, montoPagado, cambio } = data;

                content.innerHTML = `
                    <div class="total-section">
                        <div class="total-label">TOTAL</div>
                        <div class="total-amount">$${total.toFixed(2)}</div>
                    </div>
                    <div class="payment-info">
                        <div class="payment-method">
                            <i class="ri-money-dollar-circle-line"></i>
                            ${paymentMethod === 'efectivo' ? 'Efectivo' :
                              paymentMethod === 'tarjeta' ? 'Tarjeta' :
                              paymentMethod === 'transferencia' ? 'Transferencia' :
                              paymentMethod === 'pago_movil' ? 'Pago Móvil' : 'Punto de Venta'}
                        </div>
                        ${montoPagado ? `
                            <div class="mb-2">
                                <small>Monto recibido: $${montoPagado.toFixed(2)}</small>
                            </div>
                        ` : ''}
                        ${cambio > 0 ? `
                            <div class="change-amount">
                                Cambio: $${cambio.toFixed(2)}
                            </div>
                        ` : ''}
                    </div>
                `;
            } else if (data.type === 'thank-you') {
                content.innerHTML = `
                    <div class="thank-you">
                        <i class="ri-check-double-line" style="font-size: 4rem; display: block; margin-bottom: 1rem;"></i>
                        ¡Gracias por su compra!
                        <div class="mt-3" style="font-size: 1.2rem; opacity: 0.8;">
                            Vuelva pronto
                        </div>
                    </div>
                `;

                // Volver al estado idle después de 5 segundos
                setTimeout(() => {
                    updateCustomerDisplay({ type: 'idle' });
                }, 5000);
            }
        }

        // Escuchar mensajes del POS principal
        window.addEventListener('message', (event) => {
            if (event.data && event.data.type === 'customerDisplay') {
                updateCustomerDisplay(event.data);
            }
        });

        // Estado inicial
        updateCustomerDisplay({ type: 'idle' });
    </script>
</body>
</html>
