<div>
    @if (session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    @if (session()->has('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header border-bottom">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="card-title mb-1">Aprobaciones de Movimientos de Caja</h5>
                            <p class="mb-0">Revisa y aprueba los movimientos pendientes de caja</p>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    @if(empty($movimientosPendientes))
                        <div class="text-center py-8">
                            <div class="mb-3">
                                <i class="ri-checkbox-circle-line" style="font-size: 48px; color: #10b981;"></i>
                            </div>
                            <h5 class="text-muted">No hay movimientos pendientes</h5>
                            <p class="text-muted">Todos los movimientos han sido procesados.</p>
                        </div>
                    @else
                        <div class="table-responsive">
                            <table class="table table-hover align-middle">
                                <thead class="table-light">
                                    <tr>
                                        <th>Fecha</th>
                                        <th>Usuario</th>
                                        <th>Tipo</th>
                                        <th>Monto</th>
                                        <th>Motivo</th>
                                        <th>IP</th>
                                        <th class="text-end">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($movimientosPendientes as $movimiento)
                                        <tr>
                                            <td>{{ $movimiento['fecha'] }}</td>
                                            <td>{{ $movimiento['usuario'] }}</td>
                                            <td>
                                                <span class="badge bg-warning text-dark">
                                                    {{ ucfirst($movimiento['tipo_salida']) }}
                                                </span>
                                            </td>
                                            <td>
                                                <x-dual-currency :amount="$movimiento['monto']" />
                                            </td>
                                            <td>{{ $movimiento['motivo'] }}</td>
                                            <td><code>{{ $movimiento['ip_address'] }}</code></td>
                                            <td class="text-end">
                                                <button wire:click="aprobarMovimiento({{ $movimiento['id'] }})" 
                                                        class="btn btn-sm btn-success me-2">
                                                    <i class="ri-check-line"></i> Aprobar
                                                </button>
                                                <button wire:click="abrirModalRechazo({{ $movimiento['id'] }})" 
                                                        class="btn btn-sm btn-danger">
                                                    <i class="ri-close-line"></i> Rechazar
                                                </button>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Modal de Rechazo -->
    @if($showModalRechazo)
        <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">
                            <i class="ri-alert-line text-danger"></i> Rechazar Movimiento
                        </h5>
                        <button type="button" class="btn-close" wire:click="cerrarModalRechazo"></button>
                    </div>
                    <div class="modal-body">
                        <p class="mb-3">Por favor, proporciona un motivo para rechazar este movimiento.</p>
                        <div class="mb-3">
                            <label class="form-label">Motivo del rechazo</label>
                            <textarea wire:model="motivoRechazo" 
                                      class="form-control @error('motivoRechazo') is-invalid @enderror"
                                      rows="3"
                                      placeholder="Describe el motivo del rechazo..."></textarea>
                            @error('motivoRechazo')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" 
                                wire:click="rechazarMovimiento"
                                class="btn btn-danger">
                            <i class="ri-close-line"></i> Rechazar Movimiento
                        </button>
                        <button type="button" 
                                wire:click="cerrarModalRechazo"
                                class="btn btn-secondary">
                            <i class="ri-arrow-go-back-line"></i> Cancelar
                        </button>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
