<div>
    <div class="container-fluid">
        <!-- Mensajes de notificación -->
        @if(session()->has('message'))
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-{{ session('message_type') === 'error' ? 'danger' : 'success' }} alert-dismissible fade show" role="alert">
                        <i class="mdi {{ session('message_type') === 'error' ? 'mdi-alert-circle-outline' : 'mdi-check-circle-outline' }} me-2"></iconify-icon>
                        {{ session('message') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                </div>
            </div>
        @endif

        <!-- Encabezado con título y breadcrumb -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">Crear Nuevo Pedido</h4>
                    <div class="page-title-right">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb breadcrumb-style m-0">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('admin.dashboard') }}">
                                        <i class=" ri-circle-line  fs-4"></i>
                                    </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('admin.pedidos.index') }}">Pedidos</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Crear</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <!-- Progress Steps -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card bg-light">
                    <div class="card-body">
                        <div class="row text-center">
                            <div class="col-4">
                                <div class="step-item active">
                                    <div class="step-icon bg-primary text-white rounded-circle mb-2 mx-auto">
                                        <i class=" ri-circle-line "></i>
                                    </div>
                                    <h6 class="text-primary">Cliente</h6>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="step-item">
                                    <div class="step-icon bg-light text-muted rounded-circle mb-2 mx-auto border">
                                        <i class=" ri-circle-line "></i>
                                    </div>
                                    <h6 class="text-muted">Productos</h6>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="step-item">
                                    <div class="step-icon bg-light text-muted rounded-circle mb-2 mx-auto border">
                                        <i class=" ri-circle-line "></i>
                                    </div>
                                    <h6 class="text-muted">Confirmación</h6>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Sección de Cliente - Card Mejorada -->
            <div class="col-lg-6">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-gradient-primary text-white d-flex align-items-center py-3">
                        <div class="d-flex align-items-center">
                            <div class="bg-white bg-opacity-20 rounded-circle p-2 me-3">
                                <i class=" ri-circle-line  ri-24px-line"></i>
                            </div>
                            <div>
                                <h5 class="mb-0 text-white">Información del Cliente</h5>
                                <small class="text-white-50">Datos de contacto y entrega</small>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-4">
                        <!-- Selector de cliente existente -->
                        <div class="mb-4">
                            <label class="form-label fw-semibold text-muted">
                                <i class=" ri-circle-line  me-1"></i>
                                Cliente Existente
                            </label>
                            <div class="position-relative">
                                <select wire:model.live="cliente_id" class="form-select form-select-lg @error('cliente_id') is-invalid @enderror" id="cliente_id">
                                    <option value="">Seleccione un cliente existente</option>
                                    @foreach($clientes as $id => $nombre)
                                        <option value="{{ $id }}">{{ $nombre }}</option>
                                    @endforeach
                                </select>
                                <div class="position-absolute top-50 end-0 translate-middle-y pe-3">
                                    <i class=" ri-circle-line  text-muted"></i>
                                </div>
                            </div>
                                @error('cliente_id')
                                    <div class="invalid-feedback">
                                        <i class=" ri-circle-line  me-1"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                        </div>

                        <!-- Separador con texto -->
                        <div class="position-relative my-4">
                            <hr class="border-2">
                            <div class="position-absolute top-50 start-50 translate-middle bg-white px-3">
                                <span class="text-muted fw-medium small">O crear nuevo cliente</span>
                            </div>
                        </div>

                        <!-- Formulario de nuevo cliente -->
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label fw-semibold text-muted">
                                    <i class=" ri-circle-line  me-1"></i>
                                    Nombres *
                                </label>
                                <div class="input-group input-group-merge">
                                    <span class="input-group-text bg-light">
                                        <i class=" ri-circle-line  text-muted"></i>
                                    </span>
                                    <input wire:model="nombres" type="text" class="form-control @error('nombres') is-invalid @enderror" placeholder="Juan Carlos">
                                </div>
                                @error('nombres')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold text-muted">
                                    <i class=" ri-circle-line  me-1"></i>
                                    Apellidos *
                                </label>
                                <div class="input-group input-group-merge">
                                    <span class="input-group-text bg-light">
                                        <i class=" ri-circle-line  text-muted"></i>
                                    </span>
                                    <input wire:model="apellidos" type="text" class="form-control @error('apellidos') is-invalid @enderror" placeholder="Pérez González">
                                </div>
                                @error('apellidos')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row g-3 mt-1">
                            <div class="col-md-6">
                                <label class="form-label fw-semibold text-muted">
                                    <i class=" ri-circle-line  me-1"></i>
                                    Email
                                </label>
                                <div class="input-group input-group-merge">
                                    <span class="input-group-text bg-light">
                                        <i class=" ri-circle-line  text-muted"></i>
                                    </span>
                                    <input wire:model="email" type="email" class="form-control @error('email') is-invalid @enderror" placeholder="cliente@ejemplo.com">
                                </div>
                                @error('email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold text-muted">
                                    <i class=" ri-circle-line  me-1"></i>
                                    Teléfono
                                </label>
                                <div class="input-group input-group-merge">
                                    <span class="input-group-text bg-light">
                                        <i class=" ri-circle-line  text-muted"></i>
                                    </span>
                                    <input wire:model="telefono" type="text" class="form-control @error('telefono') is-invalid @enderror" placeholder="+58 412-1234567">
                                </div>
                                @error('telefono')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="mt-3">
                            <label class="form-label fw-semibold text-muted">
                                <i class=" ri-circle-line  me-1"></i>
                                Dirección de Entrega
                            </label>
                            <div class="input-group input-group-merge">
                                <span class="input-group-text bg-light">
                                    <i class=" ri-circle-line  text-muted"></i>
                                </span>
                                <textarea wire:model="direccion" class="form-control @error('direccion') is-invalid @enderror" rows="3" placeholder="Calle Principal, Edificio, Apartamento..."></textarea>
                            </div>
                            @error('direccion')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sección de Pedido - Card Mejorada -->
            <div class="col-lg-6">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-gradient-info text-white d-flex align-items-center py-3">
                        <div class="d-flex align-items-center">
                            <div class="bg-white bg-opacity-20 rounded-circle p-2 me-3">
                                <i class=" ri-circle-line  ri-24px-line"></i>
                            </div>
                            <div>
                                <h5 class="mb-0 text-white">Detalles del Pedido</h5>
                                <small class="text-white-50">Información de entrega y notas</small>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-4">
                        <div class="row g-3">
                            <div class="col-12">
                                <label class="form-label fw-semibold text-muted">
                                    <i class=" ri-circle-line  me-1"></i>
                                    Fecha de Entrega
                                </label>
                                <div class="input-group input-group-merge">
                                    <span class="input-group-text bg-light">
                                        <i class=" ri-circle-line  text-muted"></i>
                                    </span>
                                    <input wire:model="fecha_entrega" type="date" class="form-control @error('fecha_entrega') is-invalid @enderror">
                                </div>
                                @error('fecha_entrega')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-12">
                                <label class="form-label fw-semibold text-muted">
                                    <i class=" ri-circle-line  me-1"></i>
                                    Notas del Pedido
                                </label>
                                <div class="input-group input-group-merge">
                                    <span class="input-group-text bg-light">
                                        <i class=" ri-circle-line  text-muted"></i>
                                    </span>
                                    <textarea wire:model="notas" class="form-control @error('notas') is-invalid @enderror" rows="4" placeholder="Instrucciones especiales, preferencias, detalles adicionales..."></textarea>
                                </div>
                                @error('notas')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Resumen de pago -->
                        <div class="bg-light rounded-3 p-3 mt-4">
                            <h6 class="fw-semibold text-muted mb-3">
                                <i class=" ri-circle-line  me-1"></i>
                                Resumen de Pago
                            </h6>
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="text-muted">Subtotal:</span>
                                <span class="fw-medium">$ {{ number_format($this->total, 2) }}</span>
                            </div>
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="text-muted">IVA (16%):</span>
                                <span class="fw-medium">$ {{ number_format($this->total * 0.16, 2) }}</span>
                            </div>
                            <hr class="my-2">
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="fw-bold text-primary">Total:</span>
                                <span class="fw-bold text-primary ">$ {{ number_format($this->total * 1.16, 2) }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sección de Productos - Card Mejorada con Búsqueda en Tiempo Real -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-gradient-warning text-white d-flex align-items-center justify-content-between py-3">
                        <div class="d-flex align-items-center">
                            <div class="bg-white bg-opacity-20 rounded-circle p-2 me-3">
                                <i class=" ri-circle-line  ri-24px-line"></i>
                            </div>
                            <div>
                                <h5 class="mb-0 text-white">Productos</h5>
                                <small class="text-white-50">Busque y agregue productos al pedido</small>
                            </div>
                        </div>
                        <div class="text-end">
                            <div class="badge bg-light text-dark fs-6">
                                <i class=" ri-circle-line  me-1"></i>
                                {{ count($cart) }} productos
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-4">
                        <!-- Búsqueda de productos en tiempo real -->
                        <div class="row mb-4">
                            <div class="col-lg-8">
                                <label class="form-label fw-semibold text-muted">
                                    <i class=" ri-circle-line  me-1"></i>
                                    Buscar Productos
                                </label>
                                <div class="position-relative" wire:ignore>
                                    <div class="input-group input-group-lg">
                                        <span class="input-group-text bg-light border-end-0">
                                            <i class=" ri-circle-line  text-muted"></i>
                                        </span>
                                        <input
                                            wire:model.live.debounce.300ms="searchTerm"
                                            type="text"
                                            class="form-control border-start-0"
                                            placeholder="Escriba el nombre, SKU o descripción del producto..."
                                            autocomplete="off"
                                        >
                                        <span class="input-group-text bg-light border-start-0">
                                            <div wire:loading wire:target="searchTerm" class="spinner-border spinner-border-sm text-primary" role="status">
                                                <span class="visually-hidden">Cargando...</span>
                                            </div>
                                            <div wire:loading.remove wire:target="searchTerm">
                                                <i class=" ri-circle-line  text-muted"></i>
                                            </div>
                                        </span>
                                    </div>

                                    <!-- Resultados de búsqueda -->
                                    @if($showSearchResults && count($searchResults) > 0)
                                        <div class="position-absolute w-100 mt-1" style="z-index: 1050;">
                                            <div class="card shadow-lg border-0">
                                                <div class="card-header bg-light py-2">
                                                    <small class="text-muted">
                                                        <i class=" ri-circle-line  me-1"></i>
                                                        {{ count($searchResults) }} productos encontrados
                                                    </small>
                                                </div>
                                                <div class="card-body p-0 max-h-300px overflow-y-auto">
                                                    @foreach($searchResults as $producto)
                                                        <div
                                                            class="d-flex align-items-center p-3 border-bottom hover-bg-light cursor-pointer transition-all"
                                                            wire:click="selectProduct({{ $producto->id }})"
                                                            style="cursor: pointer;"
                                                        >
                                                            <div class="me-3">
                                                                @if($producto->featuredImage)
                                                                    <img src="/media/producto/{{ $producto->featuredImage->path }}"
                                                                         alt="{{ $producto->name }}"
                                                                         class="rounded"
                                                                         width="50"
                                                                         height="50"
                                                                         style="object-fit: cover;">
                                                                @else
                                                                    <div class="bg-light rounded d-flex align-items-center justify-content-center"
                                                                     style="width: 50px; height: 50px;">
                                                                        <i class=" ri-circle-line  text-muted"></i>
                                                                    </div>
                                                                @endif
                                                            </div>
                                                            <div class="flex-grow-1">
                                                                <h6 class="mb-1 fw-semibold">{{ $producto->name }}</h6>
                                                                <p class="text-muted mb-1 small">{{ Str::limit($producto->description, 50) }}</p>
                                                                <div class="d-flex align-items-center">
                                                                    <span class="badge bg-label-primary me-2">
                                                                        <i class=" ri-circle-line  me-1"></i>
                                                                        {{ $producto->categoria->name ?? 'Sin categoría' }}
                                                                    </span>
                                                                    <span class="badge bg-label-{{ $producto->quantity > 0 ? 'success' : 'danger' }}">
                                                                        <i class=" ri-circle-line  me-1"></i>
                                                                        Stock: {{ $producto->quantity }}
                                                                    </span>
                                                                </div>
                                                            </div>
                                                            <div class="text-end">
                                                                <h5 class="text-primary mb-1">$ {{ number_format($producto->price, 2) }}</h5>
                                                                <small class="text-muted">C/U</small>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                    @elseif($showSearchResults && strlen($searchTerm) >= 2)
                                        <div class="position-absolute w-100 mt-1" style="z-index: 1050;">
                                            <div class="card shadow-lg border-0">
                                                <div class="card-body text-center py-4">
                                                    <i class=" ri-circle-line  ri-48px-line text-muted mb-3"></i>
                                                    <h6 class="text-muted">No se encontraron productos</h6>
                                                    <p class="text-muted small mb-0">Intenta con otro término de búsqueda</p>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <label class="form-label fw-semibold text-muted">
                                    <i class=" ri-circle-line  me-1"></i>
                                    Cantidad
                                </label>
                                <div class="input-group">
                                    <button
                                        class="btn btn-outline-secondary"
                                        type="button"
                                        wire:click="$set('quantity', Math.max(1, quantity - 1))"
                                        {{ $quantity <= 1 ? 'disabled' : '' }}
                                    >
                                        <i class=" ri-circle-line "></i>
                                    </button>
                                    <input
                                        wire:model="quantity"
                                        type="number"
                                        min="1"
                                        class="form-control text-center fw-bold"
                                        style="max-width: 80px;"
                                    >
                                    <button
                                        class="btn btn-outline-secondary"
                                        type="button"
                                        wire:click="$set('quantity', quantity + 1)"
                                    >
                                        <i class=" ri-circle-line "></i>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Botón para agregar producto -->
                        <div class="row mb-4">
                            <div class="col-12 text-center">
                                <button
                                    wire:click="addProductToCart"
                                    type="button"
                                    class="btn btn-primary btn-lg px-5"
                                    {{ !$selectedProduct ? 'disabled' : '' }}
                                >
                                    <i class=" ri-circle-line  me-2"></i>
                                    Agregar Producto al Carrito
                                </button>
                            </div>
                        </div>

                        <!-- Producto seleccionado actual -->
                        @if($selectedProduct)
                            @php
                                $selectedProductData = \App\Models\Producto::find($selectedProduct);
                            @endphp
                            @if($selectedProductData)
                                <div class="row mb-4">
                                    <div class="col-12">
                                        <div class="card border-primary">
                                            <div class="card-body p-3">
                                                <div class="d-flex align-items-center">
                                                    <div class="me-3">
                                                        @if($selectedProductData->featuredImage)
                                                            <img src="/media/producto/{{ $selectedProductData->featuredImage->path }}"
                                                                 alt="{{ $selectedProductData->name }}"
                                                                 class="rounded"
                                                                 width="60"
                                                                 height="60"
                                                                 style="object-fit: cover;">
                                                        @else
                                                            <div class="bg-light rounded d-flex align-items-center justify-content-center"
                                                                 style="width: 60px; height: 60px;">
                                                                <i class=" ri-circle-line  text-muted"></i>
                                                            </div>
                                                        @endif
                                                    </div>
                                                    <div class="flex-grow-1">
                                                        <h6 class="mb-1 fw-bold">{{ $selectedProductData->name }}</h6>
                                                        <p class="text-muted mb-1">{{ $selectedProductData->categoria->name ?? 'Sin categoría' }}</p>
                                                        <div class="d-flex align-items-center">
                                                            <span class="text-primary fw-bold me-3">$ {{ number_format($selectedProductData->price, 2) }}</span>
                                                            <span class="badge bg-label-{{ $selectedProductData->quantity > 0 ? 'success' : 'danger' }}">
                                                                <i class=" ri-circle-line  me-1"></i>
                                                                Stock: {{ $selectedProductData->quantity }}
                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="text-end">
                                                        <div class=" fw-bold text-primary">
                                                            $ {{ number_format($selectedProductData->price * $quantity, 2) }}
                                                        </div>
                                                        <small class="text-muted">Total</small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endif

                        <!-- Lista de productos en el carrito -->
                        @if(count($cart) > 0)
                            <div class="table-responsive">
                                <table class="table table-hover align-middle">
                                    <thead class="table-light">
                                        <tr>
                                            <th class="border-0">Producto</th>
                                            <th class="text-center border-0">Cantidad</th>
                                            <th class="text-end border-0">Precio Unit.</th>
                                            <th class="text-end border-0">Subtotal</th>
                                            <th class="text-center border-0">Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($cart as $index => $item)
                                            <tr class="border-bottom">
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="me-3">
                                                            @php
                                                                $producto = \App\Models\Producto::find($item['producto_id']);
                                                            @endphp
                                                            @if($producto && $producto->featuredImage)
                                                                <img src="/media/producto/{{ $producto->featuredImage->path }}"
                                                                     alt="{{ $item['nombre'] }}"
                                                                     class="rounded"
                                                                     width="40"
                                                                     height="40"
                                                                     style="object-fit: cover;">
                                                            @else
                                                                <div class="bg-light rounded d-flex align-items-center justify-content-center"
                                                                     style="width: 40px; height: 40px;">
                                                                    <i class=" ri-circle-line  text-muted"></i>
                                                                </div>
                                                            @endif
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-1 fw-semibold">{{ $item['nombre'] }}</h6>
                                                            <small class="text-muted">{{ $producto->categoria->name ?? 'Sin categoría' }}</small>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <span class="badge bg-primary rounded-pill px-3 py-2">
                                                        {{ $item['cantidad'] }}
                                                    </span>
                                                </td>
                                                <td class="text-end fw-medium">
                                                    $ {{ number_format($item['precio_unitario'], 2) }}
                                                </td>
                                                <td class="text-end fw-bold text-primary">
                                                    $ {{ number_format($item['subtotal'], 2) }}
                                                </td>
                                                <td class="text-center">
                                                    <button
                                                        wire:click="removeFromCart({{ $index }})"
                                                        type="button"
                                                        class="btn btn-sm btn-outline-danger rounded-circle"
                                                        data-bs-toggle="tooltip"
                                                        data-bs-placement="top"
                                                        title="Eliminar producto"
                                                    >
                                                        <i class=" ri-circle-line "></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr class="table-active">
                                            <th colspan="3" class="text-end text-uppercase">Total del Pedido:</th>
                                            <th class="text-end">
                                                <span class=" fw-bold text-primary">
                                                    $ {{ number_format($this->total, 2) }}
                                                </span>
                                            </th>
                                            <th></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        @else
                            <div class="text-center py-5">
                                <div class="mb-4">
                                    <i class=" ri-circle-line  ri-48px-line text-muted"></i>
                                </div>
                                <h5 class="text-muted mb-2">Carrito vacío</h5>
                                <p class="text-muted mb-4">Agrega productos al carrito para continuar con el pedido</p>
                                <div class="d-flex justify-content-center gap-2">
                                    <span class="badge bg-light text-dark">
                                        <i class=" ri-circle-line  me-1"></i>
                                        Tip: Usa la búsqueda para encontrar productos rápidamente
                                    </span>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Botones de acción mejorados -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card border-0 shadow-sm">
                    <div class="card-body p-4">
                        <div class="row align-items-center">
                            <div class="col-md-6">
                                <div class="d-flex align-items-center">
                                    <div class="bg-light rounded-circle p-3 me-3">
                                        <i class=" ri-circle-line  text-primary ri-24px-line"></i>
                                    </div>
                                    <div>
                                        <h6 class="mb-1 fw-semibold">¿Listo para crear el pedido?</h6>
                                        <small class="text-muted">Revisa todos los detalles antes de confirmar</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex justify-content-end gap-3">
                                    <a href="{{ route('admin.pedidos.index') }}" class="btn btn-outline-secondary btn-lg px-4">
                                        <i class=" ri-circle-line  me-2"></i>
                                        Cancelar
                                    </a>
                                    <button
                                        wire:click="save"
                                        type="button"
                                        class="btn btn-success btn-lg px-5"
                                        {{ count($cart) == 0 ? 'disabled' : '' }}
                                    >
                                        <i class=" ri-circle-line  me-2"></i>
                                        Crear Pedido
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Estilos personalizados -->
    <style>
        .hover-bg-light:hover {
            background-color: #f8f9fa !important;
        }
        .cursor-pointer {
            cursor: pointer;
        }
        .transition-all {
            transition: all 0.2s ease-in-out;
        }
        .max-h-300px {
            max-height: 300px;
        }
        .bg-gradient-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .bg-gradient-info {
            background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
        }
        .bg-gradient-warning {
            background: linear-gradient(135deg, #ffc107 0%, #e0a800 100%);
        }
        .step-item.active .step-icon {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            transform: scale(1.1);
        }
        .step-item .step-icon {
            transition: all 0.3s ease;
        }
        .step-item h6 {
            transition: all 0.3s ease;
        }
        .input-group-merge .form-control:not(:first-child) {
            border-left: 0;
        }
        .input-group-merge .form-control:focus {
            box-shadow: none;
            border-color: #86b7fe;
        }
        .input-group-merge .input-group-text {
            border-right: 0;
            background-color: #f8f9fa;
        }
        .input-group-merge .form-control:focus + .input-group-text {
            border-color: #86b7fe;
        }
    </style>

    <!-- JavaScript para mejorar la experiencia -->
    <script>
        // Inicializar tooltips
        document.addEventListener('DOMContentLoaded', function() {
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
        });

        // Cerrar resultados de búsqueda al hacer clic fuera
        document.addEventListener('click', function(e) {
            const searchContainer = document.querySelector('.position-relative.wire\\:ignore');
            if (searchContainer && !searchContainer.contains(e.target)) {
                @this.hideSearchResults();
            }
        });
    </script>
</div>
