<div>
    <!-- Header -->
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4 gap-3">
        <div>
            <h1 class="h3 mb-0 text-gray-800">Detalle de Nota de Venta</h1>
            <p class="mb-0 text-muted">{{ $notaVenta->numeroCompleto }} - {{ $notaVenta->fecha_emision->format('d/m/Y') }}</p>
        </div>
        <div class="d-flex flex-wrap gap-2">
            @if(!$notaVenta->venta_id && $notaVenta->estado !== 'anulada')
                <button wire:click="abrirModalConvertir" class="btn btn-success btn-sm" wire:loading.attr="disabled">
                    <span wire:loading.remove wire:target="abrirModalConvertir">
                        <i class="ri-exchange-line me-2"></i>Convertir a Venta
                    </span>
                    <span wire:loading wire:target="abrirModalConvertir">
                        <i class="ri-loader-4-line me-2 spinner-border spinner-border-sm"></i>Cargando...
                    </span>
                </button>
            @endif
            @if($notaVenta->venta_id)
                <a href="{{ route('admin.ventas.show', $notaVenta->venta_id) }}" class="btn btn-info btn-sm">
                    <i class="ri-file-text-line me-2"></i>Ver Venta
                </a>
            @endif
            <a href="{{ route('admin.notas-venta.index') }}" class="btn btn-outline-secondary btn-sm">
                <i class="ri-arrow-left-line me-2"></i>Volver
            </a>
            @if($notaVenta->estado === 'pendiente' && !$notaVenta->venta_id)
                <a href="{{ route('admin.notas-venta.edit', $notaVenta->id) }}" class="btn btn-warning btn-sm">
                    <i class="ri-edit-line me-2"></i>Editar
                </a>
            @endif
        </div>
    </div>

    <div class="row">
        <!-- Información de la Nota de Venta -->
        <div class="col-12 col-xl-8 mb-4">
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-0">
                    <h5 class="card-title mb-0">Información de la Nota de Venta</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-12 col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted small">CÓDIGO</label>
                                <p class="fw-semibold mb-0">{{ $notaVenta->codigo }}</p>
                            </div>
                            <div class="mb-3">
                                <label class="form-label text-muted small">CLIENTE</label>
                                <p class="fw-semibold mb-0">{{ $notaVenta->cliente->nombre_completo ?? 'Cliente general' }}</p>
                            </div>

                        </div>
                        <div class="col-12 col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted small">FECHA DE EMISIÓN</label>
                                <p class="fw-semibold mb-0">{{ $notaVenta->fecha_emision->format('d/m/Y H:i:s') }}</p>
                            </div>
                            @if($notaVenta->fecha_vencimiento)
                                <div class="mb-3">
                                    <label class="form-label text-muted small">FECHA DE VENCIMIENTO</label>
                                    <p class="fw-semibold mb-0">{{ $notaVenta->fecha_vencimiento->format('d/m/Y') }}</p>
                                </div>
                            @endif
                            <div class="mb-3">
                                <label class="form-label text-muted small">USUARIO</label>
                                <p class="fw-semibold mb-0">{{ $notaVenta->user->name }}</p>
                            </div>
                            <div class="mb-3">
                                <label class="form-label text-muted small">ESTADO</label>
                                <div>
                                    @switch($notaVenta->estado)
                                        @case('pendiente')
                                            <span class="badge bg-warning bg-opacity-10 text-warning border border-warning border-opacity-25 px-3 py-2">
                                                <i class="ri-time-line me-1"></i>Pendiente
                                            </span>
                                            @break
                                        @case('procesada')
                                            <span class="badge bg-success bg-opacity-10 text-success border border-success border-opacity-25 px-3 py-2">
                                                <i class="ri-check-line me-1"></i>Procesada
                                            </span>
                                            @break
                                        @case('anulada')
                                            <span class="badge bg-danger bg-opacity-10 text-danger border border-danger border-opacity-25 px-3 py-2">
                                                <i class="ri-close-line me-1"></i>Anulada
                                            </span>
                                            @break
                                    @endswitch
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Detalles de Productos -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-0">
                    <h5 class="card-title mb-0">Productos</h5>
                </div>
                <div class="card-body p-0">
                    <!-- Vista móvil -->
                    <div class="d-block d-md-none">
                        @foreach($notaVenta->detalles as $detalle)
                            <div class="border-bottom p-3">
                                <div class="d-flex align-items-start">
                                    <div class="bg-primary bg-opacity-10 rounded-3 p-2 me-3 flex-shrink-0">
                                        <i class="ri-product-hunt-line text-primary"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div class="fw-semibold mb-1">{{ $detalle->descripcion }}</div>
                                        @if($detalle->producto)
                                            <small class="text-muted d-block">{{ $detalle->producto->code }}</small>
                                        @endif
                                        @if($detalle->productoVariant)
                                            <div class="small text-info mb-2">
                                                <i class="ri-palette-line me-1"></i>{{ $detalle->productoVariant->name }}
                                            </div>
                                        @endif
                                        <div class="row g-2 mt-2">
                                            <div class="col-6">
                                                <small class="text-muted">Cantidad:</small>
                                                <div class="fw-semibold">{{ $detalle->cantidad }}</div>
                                            </div>
                                            <div class="col-6">
                                                <small class="text-muted">Precio:</small>
                                                <div class="fw-semibold">{{ format_money($detalle->precio_unitario) }}</div>
                                            </div>
                                            <div class="col-12">
                                                <small class="text-muted">Subtotal:</small>
                                                <div class="fw-bold text-success">{{ format_money($detalle->subtotal) }}</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                        <div class="p-3 bg-light">
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="fw-bold">Total:</span>
                                <span class="fw-bold fs-5 text-success">{{ format_money($notaVenta->total) }}</span>
                            </div>
                        </div>
                    </div>

                    <!-- Vista desktop -->
                    <div class="d-none d-md-block">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th class="border-0 fw-semibold text-uppercase text-muted small ps-4">Producto</th>
                                        <th class="border-0 fw-semibold text-uppercase text-muted small text-center">Cantidad</th>
                                        <th class="border-0 fw-semibold text-uppercase text-muted small text-end">Precio Unit.</th>
                                        <th class="border-0 fw-semibold text-uppercase text-muted small text-end pe-4">Subtotal</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($notaVenta->detalles as $detalle)
                                        <tr>
                                            <td class="ps-4">
                                                <div class="d-flex align-items-center">
                                                    <div class="bg-primary bg-opacity-10 rounded-3 p-2 me-3">
                                                        <i class="ri-product-hunt-line text-primary"></i>
                                                    </div>
                                                    <div>
                                                        <div class="fw-semibold">{{ $detalle->descripcion }}</div>
                                                        @if($detalle->producto)
                                                            <small class="text-muted">{{ $detalle->producto->code }}</small>
                                                        @endif
                                                        @if($detalle->productoVariant)
                                                            <div class="small text-info">
                                                                <i class="ri-palette-line me-1"></i>{{ $detalle->productoVariant->name }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="text-center">
                                                <span class="badge bg-light text-dark border">{{ $detalle->cantidad }}</span>
                                            </td>
                                            <td class="text-end">
                                                <span class="fw-semibold">{{ format_money($detalle->precio_unitario) }}</span>
                                            </td>
                                            <td class="text-end pe-4">
                                                <span class="fw-bold text-dark">{{ format_money($detalle->subtotal) }}</span>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot class="table-light">
                                    <tr>
                                        <td colspan="3" class="text-end fw-bold ps-4">Total:</td>
                                        <td class="text-end pe-4">
                                            <span class="fw-bold fs-5 text-success">{{ format_money($notaVenta->total) }}</span>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Información Adicional -->
        <div class="col-12 col-xl-4">
            <!-- Resumen -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-0">
                    <h5 class="card-title mb-0">Resumen</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Subtotal:</span>
                        <span class="fw-semibold">{{ format_money($notaVenta->subtotal ?? $notaVenta->total) }}</span>
                    </div>
                    @if($notaVenta->impuestos > 0)
                        <div class="d-flex justify-content-between mb-2">
                            <span>Impuestos:</span>
                            <span class="fw-semibold">{{ format_money($notaVenta->impuestos) }}</span>
                        </div>
                    @endif
                    <hr>
                    <div class="d-flex justify-content-between">
                        <span class="fw-bold">Total:</span>
                        <span class="fw-bold fs-5 text-success">{{ format_money($notaVenta->total) }}</span>
                    </div>
                </div>
            </div>

            <!-- Observaciones -->
            @if($notaVenta->observaciones)
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-0">
                        <h5 class="card-title mb-0">Observaciones</h5>
                    </div>
                    <div class="card-body">
                        <p class="mb-0">{{ $notaVenta->observaciones }}</p>
                    </div>
                </div>
            @endif

            <!-- Información de Empresa y Sucursal -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-0">
                    <h5 class="card-title mb-0">Información Adicional</h5>
                </div>
                <div class="card-body">
                    <div class="mb-2">
                        <span class="text-muted">Empresa:</span>
                        <span class="fw-semibold ms-2">{{ $notaVenta->empresa->nombre ?? 'N/A' }}</span>
                    </div>
                    <div class="mb-2">
                        <span class="text-muted">Sucursal:</span>
                        <span class="fw-semibold ms-2">{{ $notaVenta->sucursal->nombre ?? 'N/A' }}</span>
                    </div>
                    <div>
                        <span class="text-muted">Serie:</span>
                        <span class="fw-semibold ms-2">{{ $notaVenta->serie }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Convertir a Venta -->
    @if($showConvertModal)
        <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Convertir a Venta</h5>
                        <button type="button" wire:click="cerrarModalConvertir" class="btn-close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-info">
                            <i class="ri-information-line me-2"></i>
                            Se creará una venta con todos los productos de esta nota de venta.
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Método de Pago</label>
                            <select wire:model="metodo_pago" class="form-select" required>
                                @foreach($metodosPago as $key => $value)
                                    <option value="{{ $key }}">{{ $value }}</option>
                                @endforeach
                            </select>
                            @error('metodo_pago') <div class="text-danger small">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Observaciones para la Venta</label>
                            <textarea wire:model="observaciones_venta" class="form-control" rows="3"
                                      placeholder="Observaciones adicionales para la venta..."></textarea>
                        </div>

                        <div class="bg-light rounded p-3">
                            <div class="d-flex justify-content-between mb-2">
                                <span>Total a facturar:</span>
                                <span class="fw-bold">{{ format_money($notaVenta->total) }}</span>
                            </div>
                            <div class="d-flex justify-content-between">
                                <span>Cliente:</span>
                                <span class="fw-semibold">{{ $notaVenta->cliente->nombre_completo ?? 'Cliente general' }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" wire:click="cerrarModalConvertir" class="btn btn-secondary">Cancelar</button>
                        <button type="button" wire:click="convertirAVenta" class="btn btn-success" wire:loading.attr="disabled">
                            <span wire:loading.remove wire:target="convertirAVenta">
                                <i class="ri-exchange-line me-2"></i>Convertir a Venta
                            </span>
                            <span wire:loading wire:target="convertirAVenta">
                                <i class="ri-loader-4-line me-2 spinner-border spinner-border-sm"></i>Procesando...
                            </span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
