<div>
    <div class="">
    <!-- Header -->
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <div>
                    <h4 class="fw-bold py-3 mb-2">
                        <i class="ri-database-2-line me-2 text-primary"></i>
                        Respaldo de Base de Datos
                    </h4>
                    <p class="text-muted mb-0">Crea respaldos personalizados con filtros de fecha</p>
                </div>
                <div class="badge bg-label-info fs-6">
                    <i class="ri-shield-check-line me-1"></i>
                    Sistema Seguro
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Panel de Configuración -->
        <div class="col-xl-4 col-lg-5 mb-4">
            <div class="card h-100">
                <div class="card-header d-flex align-items-center">
                    <div class="card-title mb-0">
                        <h5 class="m-0 me-2">
                            <i class="ri-settings-3-line me-2 text-primary"></i>
                            Configuración
                        </h5>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Fecha y Hora -->
                    <div class="row mb-3">
                        <div class="col-6">
                            <label class="form-label fw-medium">
                                <i class="ri-calendar-line me-1"></i>
                                Fecha
                            </label>
                            <input type="date" class="form-control" wire:model="backupDate">
                        </div>
                        <div class="col-6">
                            <label class="form-label fw-medium">
                                <i class="ri-time-line me-1"></i>
                                Hora
                            </label>
                            <input type="time" class="form-control" wire:model="backupTime">
                        </div>
                    </div>

                    <!-- Filtro de Datos -->
                    <div class="mb-4">
                        <div class="card border border-primary">
                            <div class="card-body p-3">
                                <div class="form-check form-switch mb-3">
                                    <input class="form-check-input" type="checkbox" wire:model.live="useDataFilter" id="useDataFilter">
                                    <label class="form-check-label fw-medium" for="useDataFilter">
                                        <i class="ri-filter-3-line me-1"></i>
                                        Filtrar por fecha de creación
                                    </label>
                                </div>
                                @if($useDataFilter)
                                <div class="row">
                                    <div class="col-6">
                                        <label class="form-label text-muted small">Desde</label>
                                        <input type="date" class="form-control form-control-sm" wire:model="filterFromDate">
                                    </div>
                                    <div class="col-6">
                                        <label class="form-label text-muted small">Hasta</label>
                                        <input type="date" class="form-control form-control-sm" wire:model="filterToDate">
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Opciones de Estructura -->
                    <div class="mb-4">
                        <h6 class="fw-medium mb-3">
                            <i class="ri-settings-4-line me-1 text-warning"></i>
                            Opciones de Estructura
                        </h6>
                        <div class="form-check mb-2">
                            <input class="form-check-input" type="checkbox" wire:model="dropTables" id="dropTables">
                            <label class="form-check-label" for="dropTables">
                                Suprimir las tablas (DROP TABLE)
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" wire:model="truncateExistingData" id="truncateExistingData">
                            <label class="form-check-label" for="truncateExistingData">
                                Truncar datos existentes (TRUNCATE)
                            </label>
                        </div>
                    </div>

                    <!-- Modo de Datos -->
                    <div class="mb-4">
                        <h6 class="fw-medium mb-3">
                            <i class="ri-database-line me-1 text-info"></i>
                            Modo de Datos
                        </h6>
                        <div class="form-check mb-2">
                            <input class="form-check-input" type="radio" wire:model="dataMode" value="none" id="dataMode1">
                            <label class="form-check-label" for="dataMode1">
                                Sin datos (solo estructura)
                            </label>
                        </div>
                        <div class="form-check mb-2">
                            <input class="form-check-input" type="radio" wire:model="dataMode" value="delete_insert" id="dataMode2">
                            <label class="form-check-label" for="dataMode2">
                                Borrar + insertar (DELETE + INSERT)
                            </label>
                        </div>
                        <div class="form-check mb-2">
                            <input class="form-check-input" type="radio" wire:model="dataMode" value="insert" id="dataMode3">
                            <label class="form-check-label" for="dataMode3">
                                Insertar (INSERT)
                            </label>
                        </div>
                        <div class="form-check mb-2">
                            <input class="form-check-input" type="radio" wire:model="dataMode" value="insert_ignore" id="dataMode4">
                            <label class="form-check-label" for="dataMode4">
                                Insertar e ignorar (INSERT IGNORE)
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" wire:model="dataMode" value="replace" id="dataMode5">
                            <label class="form-check-label" for="dataMode5">
                                Reemplazar datos (REPLACE INTO)
                            </label>
                        </div>
                    </div>

                    <!-- Estadísticas -->
                    <div class="mb-4">
                        <div class="d-flex justify-content-between align-items-center p-3 bg-light rounded">
                            <div class="text-center">
                                <div class="fw-bold text-primary h4 mb-0">{{ count($selectedTables) }}</div>
                                <small class="text-muted">Seleccionadas</small>
                            </div>
                            <div class="text-center">
                                <div class="fw-bold text-info h4 mb-0">{{ count($allTables) }}</div>
                                <small class="text-muted">Total</small>
                            </div>
                        </div>
                    </div>

                    <!-- Acciones de Selección -->
                    <div class="mb-4">
                        <div class="btn-group w-100" role="group">
                            <button type="button" class="btn btn-outline-primary" wire:click="selectAllTables">
                                <i class="ri-checkbox-multiple-line me-1"></i>
                                Todas
                            </button>
                            <button type="button" class="btn btn-outline-secondary" wire:click="deselectAllTables">
                                <i class="ri-checkbox-blank-line me-1"></i>
                                Ninguna
                            </button>
                        </div>
                    </div>

                    <!-- Botón Principal -->
                    <div class="d-grid">
                        <button type="button"
                                class="btn btn-primary btn-lg"
                                wire:click="createBackup"
                                wire:loading.attr="disabled"
                                {{ empty($selectedTables) ? 'disabled' : '' }}>
                            <span wire:loading.remove wire:target="createBackup">
                                <i class="ri-download-cloud-2-line me-2"></i>
                                Crear Respaldo
                            </span>
                            <span wire:loading wire:target="createBackup">
                                <span class="spinner-border spinner-border-sm me-2"></span>
                                Procesando...
                            </span>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Panel de Tablas -->
        <div class="col-xl-8 col-lg-7 mb-4">
            <div class="card h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <div class="card-title mb-0">
                        <h5 class="m-0 me-2">
                            <i class="ri-table-line me-2 text-success"></i>
                            Seleccionar Tablas
                        </h5>
                    </div>
                    <div class="badge bg-label-success">
                        {{ count($selectedTables) }}/{{ count($allTables) }} seleccionadas
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive" style="max-height: 500px;">
                        <table class="table table-hover">
                            <thead class="table-light sticky-top">
                                <tr>
                                    <th width="50"></th>
                                    <th>Tabla</th>
                                    <th class="text-end">Registros</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($allTables as $table)
                                <tr class="cursor-pointer" wire:click="toggleTable('{{ $table['name'] }}')">
                                    <td>
                                        <div class="form-check">
                                            <input class="form-check-input"
                                                   type="checkbox"
                                                   id="table_{{ $table['name'] }}"
                                                   {{ in_array($table['name'], $selectedTables) ? 'checked' : '' }}>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <i class="ri-database-line me-2 text-muted"></i>
                                            <span class="fw-medium">{{ $table['name'] }}</span>
                                        </div>
                                    </td>
                                    <td class="text-end">
                                        <span class="badge bg-label-info">{{ number_format($table['row_count']) }}</span>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Panel de Información -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="text-primary mb-3">
                                <i class="ri-information-line me-2"></i>
                                Información del Respaldo
                            </h6>
                            <ul class="list-unstyled mb-0">
                                <li class="mb-2">
                                    <i class="ri-folder-line me-2 text-muted"></i>
                                    <strong>Ubicación:</strong> <code>/database/Respaldo/</code>
                                </li>
                                <li class="mb-2">
                                    <i class="ri-file-text-line me-2 text-muted"></i>
                                    <strong>Formato:</strong> <code>respaldo[DDMMAAAAHHMM].sql</code>
                                </li>
                                <li class="mb-2">
                                    <i class="ri-calendar-check-line me-2 text-muted"></i>
                                    <strong>Ejemplo:</strong> <code>respaldo281120251206.sql</code>
                                </li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h6 class="text-success mb-3">
                                <i class="ri-filter-2-line me-2"></i>
                                Filtros Avanzados
                            </h6>
                            <ul class="list-unstyled mb-0">
                                <li class="mb-2">
                                    <i class="ri-checkbox-circle-line me-2 text-muted"></i>
                                    Solo tablas seleccionadas
                                </li>
                                <li class="mb-2">
                                    <i class="ri-time-line me-2 text-muted"></i>
                                    Filtro por created_at O updated_at
                                </li>
                                <li class="mb-2">
                                    <i class="ri-database-2-line me-2 text-muted"></i>
                                    Lógica OR: creado O actualizado en el rango
                                </li>
                                <li class="mb-2">
                                    <i class="ri-settings-line me-2 text-muted"></i>
                                    Opciones avanzadas de estructura y datos
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.cursor-pointer {
    cursor: pointer;
}
.cursor-pointer:hover {
    background-color: rgba(var(--bs-primary-rgb), 0.05);
}
</style>
</div>
