<div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Crear Nueva Marca</h5>
                </div>
                <div class="card-body">
                    <form wire:submit.prevent="save">
                        <div class="row">
                            <div class="col-md-8 mb-3">
                                <label for="nombre" class="form-label">Nombre *</label>
                                <input type="text"
                                       class="form-control @error('nombre') is-invalid @enderror"
                                       id="nombre"
                                       wire:model="nombre"
                                       placeholder="Ingrese el nombre de la marca">
                                @error('nombre')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="activo" class="form-label">Estado</label>
                                <div class="form-check form-switch mt-2">
                                    <input class="form-check-input"
                                           type="checkbox"
                                           id="activo"
                                           wire:model="activo"
                                           {{ $activo ? 'checked' : '' }}>
                                    <label class="form-check-label" for="activo">
                                        {{ $activo ? 'Activo' : 'Inactivo' }}
                                    </label>
                                </div>
                            </div>

                            <div class="col-12 mb-3">
                                <label for="descripcion" class="form-label">Descripción</label>
                                <textarea class="form-control @error('descripcion') is-invalid @enderror"
                                          id="descripcion"
                                          wire:model="descripcion"
                                          rows="4"
                                          placeholder="Ingrese una descripción de la marca"></textarea>
                                @error('descripcion')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class=" ri-circle-line  me-1"></i>
                                Guardar Marca
                            </button>

                            <a href="{{ route('admin.marcas.index') }}" class="btn btn-secondary">
                                <i class=" ri-circle-line  me-1"></i>
                                Cancelar
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
