<div>
    @if (session()->has('message'))
        <script>
            window.addEventListener('DOMContentLoaded', function() {
                window.dispatchEvent(new CustomEvent('show-toast', {
                    detail: {
                        type: 'success',
                        message: '{{ session('message') }}',
                        timeout: 5000
                    }
                }));
            });
        </script>
    @endif

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Editar Empleado</h5>
                </div>
                <div class="card-body">
                    <form wire:submit.prevent="update">
                        <!-- Información Personal -->
                        <h6 class="text-muted mb-4">Información Personal</h6>
                        <div class="row g-6 mb-6">
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="text" wire:model="nombres" class="form-control @error('nombres') is-invalid @enderror" id="nombres" placeholder="Nombres">
                                    <label for="nombres">Nombres *</label>
                                    @error('nombres') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="text" wire:model="apellidos" class="form-control @error('apellidos') is-invalid @enderror" id="apellidos" placeholder="Apellidos">
                                    <label for="apellidos">Apellidos *</label>
                                    @error('apellidos') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row g-6 mb-6">
                            <div class="col-md-4">
                                <div class="form-floating form-floating-outline">
                                    <select wire:model="tipo_documento" class="form-select" id="tipo_documento">
                                        <option value="cedula">Cédula</option>
                                        <option value="pasaporte">Pasaporte</option>
                                        <option value="rif">RIF</option>
                                    </select>
                                    <label for="tipo_documento">Tipo Documento *</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-floating form-floating-outline">
                                    <input type="text" wire:model="documento" class="form-control @error('documento') is-invalid @enderror" id="documento" placeholder="Documento">
                                    <label for="documento">Documento *</label>
                                    @error('documento') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-floating form-floating-outline">
                                    <select wire:model="genero" class="form-select" id="genero">
                                        <option value="">Seleccionar</option>
                                        <option value="masculino">Masculino</option>
                                        <option value="femenino">Femenino</option>
                                        <option value="otro">Otro</option>
                                    </select>
                                    <label for="genero">Género</label>
                                </div>
                            </div>
                        </div>

                        <div class="row g-6 mb-6">
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="email" wire:model="email" class="form-control @error('email') is-invalid @enderror" id="email" placeholder="Email">
                                    <label for="email">Email *</label>
                                    @error('email') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="text" wire:model="telefono" class="form-control @error('telefono') is-invalid @enderror" id="telefono" placeholder="Teléfono">
                                    <label for="telefono">Teléfono *</label>
                                    @error('telefono') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row g-6 mb-6">
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="date" wire:model="fecha_nacimiento" class="form-control" id="fecha_nacimiento">
                                    <label for="fecha_nacimiento">Fecha Nacimiento</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <select wire:model="estado_civil" class="form-select" id="estado_civil">
                                        <option value="">Seleccionar</option>
                                        <option value="soltero">Soltero</option>
                                        <option value="casado">Casado</option>
                                        <option value="divorciado">Divorciado</option>
                                        <option value="viudo">Viudo</option>
                                    </select>
                                    <label for="estado_civil">Estado Civil</label>
                                </div>
                            </div>
                        </div>

                        <div class="row g-6 mb-6">
                            <div class="col-12">
                                <div class="form-floating form-floating-outline">
                                    <textarea wire:model="direccion" class="form-control h-px-100" id="direccion" placeholder="Dirección"></textarea>
                                    <label for="direccion">Dirección</label>
                                </div>
                            </div>
                        </div>

                        <!-- Información Laboral -->
                        <h6 class="text-muted mb-4">Información Laboral</h6>
                        <div class="row g-6 mb-6">
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="text" wire:model="cargo" class="form-control @error('cargo') is-invalid @enderror" id="cargo" placeholder="Cargo">
                                    <label for="cargo">Cargo *</label>
                                    @error('cargo') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="text" wire:model="departamento" class="form-control @error('departamento') is-invalid @enderror" id="departamento" placeholder="Departamento">
                                    <label for="departamento">Departamento *</label>
                                    @error('departamento') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row g-6 mb-6">
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="number" step="0.01" wire:model="salario" class="form-control" id="salario" placeholder="Salario">
                                    <label for="salario">Salario</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="date" wire:model="fecha_ingreso" class="form-control @error('fecha_ingreso') is-invalid @enderror" id="fecha_ingreso">
                                    <label for="fecha_ingreso">Fecha Ingreso *</label>
                                    @error('fecha_ingreso') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Contacto de Emergencia -->
                        <h6 class="text-muted mb-4">Contacto de Emergencia</h6>
                        <div class="row g-6 mb-6">
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="text" wire:model="contacto_emergencia" class="form-control" id="contacto_emergencia" placeholder="Contacto Emergencia">
                                    <label for="contacto_emergencia">Contacto Emergencia</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="text" wire:model="telefono_emergencia" class="form-control" id="telefono_emergencia" placeholder="Teléfono Emergencia">
                                    <label for="telefono_emergencia">Teléfono Emergencia</label>
                                </div>
                            </div>
                        </div>

                        <!-- Asignación -->
                        <h6 class="text-muted mb-4">Asignación</h6>
                        <div class="row g-6 mb-6">
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <select wire:model="empresa_id" class="form-select @error('empresa_id') is-invalid @enderror" id="empresa_id">
                                        <option value="">Seleccionar empresa</option>
                                        @foreach($empresas as $empresa)
                                            <option value="{{ $empresa->id }}">{{ $empresa->nombre }}</option>
                                        @endforeach
                                    </select>
                                    <label for="empresa_id">Empresa *</label>
                                    @error('empresa_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <select wire:model="sucursal_id" class="form-select @error('sucursal_id') is-invalid @enderror" id="sucursal_id">
                                        <option value="">Seleccionar sucursal</option>
                                        @foreach($sucursales as $sucursal)
                                            <option value="{{ $sucursal->id }}">{{ $sucursal->nombre }}</option>
                                        @endforeach
                                    </select>
                                    <label for="sucursal_id">Sucursal *</label>
                                    @error('sucursal_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row g-6 mb-6">
                            <div class="col-12">
                                <div class="form-floating form-floating-outline">
                                    <textarea wire:model="observaciones" class="form-control h-px-100" id="observaciones" placeholder="Observaciones"></textarea>
                                    <label for="observaciones">Observaciones</label>
                                </div>
                            </div>
                        </div>

                        <div class="row g-6">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary me-3">Guardar</button>
                                <a href="{{ route('admin.empleados.index') }}" class="btn btn-outline-secondary">Cancelar</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>