<div>
    @section('title', 'Mi Dashboard')

    @if(!$empleado)
    <div class="alert alert-warning">
        <i class="ri-alert-line me-2"></i>
        No se encontró tu perfil de empleado. Contacta al administrador.
    </div>
    @endif

    <!-- Bienvenida personalizada -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="avatar avatar-lg me-3">
                            <div class="avatar-initial bg-white text-primary rounded-circle">
                                <i class="ri-user-smile-line fs-2"></i>
                            </div>
                        </div>
                        <div>
                            <h4 class="text-white mb-1">¡Hola, {{ auth()->user()->name }}!</h4>
                            <p class="mb-0 opacity-75">{{ now()->format('l, d \d\e F \d\e Y') }}</p>
                            @if($empleado)
                                <small class="opacity-75">{{ $empleado->cargo ?? 'Empleado' }} - {{ $empleado->departamento ?? 'General' }}</small>
                            @endif
                        </div>
                        <div class="ms-auto">
                            <div class="text-end">
                                <h5 class="text-white mb-0">{{ $stats['efficiency_score'] }}%</h5>
                                <small class="opacity-75">Eficiencia</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Estadísticas Principales -->
    <div class="row g-4 mb-4">
        <div class="col-xl-2 col-lg-4 col-sm-6">
            <div class="card hover-shadow">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="mb-1 text-muted">Hoy</h6>
                            <h3 class="mb-0 text-primary">{{ $stats['orders_today'] }}</h3>
                            <small class="text-muted">Pedidos</small>
                        </div>
                        <div class="avatar">
                            <div class="avatar-initial bg-label-primary rounded">
                                <i class="ri-calendar-today-line"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-2 col-lg-4 col-sm-6">
            <div class="card hover-shadow">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="mb-1 text-muted">Esta Semana</h6>
                            <h3 class="mb-0 text-info">{{ $stats['orders_week'] }}</h3>
                            <small class="text-muted">Pedidos</small>
                        </div>
                        <div class="avatar">
                            <div class="avatar-initial bg-label-info rounded">
                                <i class="ri-calendar-week-line"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-2 col-lg-4 col-sm-6">
            <div class="card hover-shadow {{ $stats['pending_orders'] > 0 ? 'border-warning' : '' }}">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="mb-1 text-muted">Pendientes</h6>
                            <h3 class="mb-0 text-warning">{{ $stats['pending_orders'] }}</h3>
                            <small class="text-muted">Por procesar</small>
                        </div>
                        <div class="avatar">
                            <div class="avatar-initial bg-label-warning rounded">
                                <i class="ri-time-line"></i>
                            </div>
                        </div>
                    </div>
                    @if($stats['pending_orders'] > 0)
                        <div class="mt-2">
                            <button wire:click="viewPendingOrders" class="btn btn-sm btn-warning w-100">
                                <i class="ri-eye-line me-1"></i> Ver Pendientes
                            </button>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-xl-2 col-lg-4 col-sm-6">
            <div class="card hover-shadow">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="mb-1 text-muted">En Proceso</h6>
                            <h3 class="mb-0 text-secondary">{{ $stats['processing_orders'] }}</h3>
                            <small class="text-muted">Trabajando</small>
                        </div>
                        <div class="avatar">
                            <div class="avatar-initial bg-label-secondary rounded">
                                <i class="ri-loader-4-line"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-2 col-lg-4 col-sm-6">
            <div class="card hover-shadow">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="mb-1 text-muted">Completados</h6>
                            <h3 class="mb-0 text-success">{{ $stats['completed_orders'] }}</h3>
                            <small class="text-muted">Entregados</small>
                        </div>
                        <div class="avatar">
                            <div class="avatar-initial bg-label-success rounded">
                                <i class="ri-checkbox-circle-line"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-2 col-lg-4 col-sm-6">
            <div class="card hover-shadow">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="mb-1 text-muted">Ingresos Mes</h6>
                            <h3 class="mb-0 text-success">{{ format_money($stats['total_revenue_month']) }}</h3>
                            <small class="text-muted">Generados</small>
                        </div>
                        <div class="avatar">
                            <div class="avatar-initial bg-label-success rounded">
                                <i class="ri-money-dollar-circle-line"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Meta Semanal y Rendimiento -->
    <div class="row g-4 mb-4">
        <div class="col-lg-6">
            <div class="card h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h5 class="mb-0"><i class="ri-target-line me-2"></i>Meta Semanal</h5>
                    <span class="badge bg-{{ $stats['weekly_goal_percentage'] >= 100 ? 'success' : ($stats['weekly_goal_percentage'] >= 75 ? 'warning' : 'info') }}">{{ $stats['weekly_goal_percentage'] }}%</span>
                </div>
                <div class="card-body text-center">
                    <div class="mb-3">
                        <h1 class="display-4 text-primary mb-1">{{ $stats['weekly_progress'] }}<small class="text-muted fs-4">/{{ $stats['weekly_goal'] }}</small></h1>
                        <p class="text-muted mb-0">Pedidos esta semana</p>
                    </div>
                    <div class="progress mb-3" style="height: 12px;">
                        <div class="progress-bar bg-gradient bg-{{ $stats['weekly_goal_percentage'] >= 100 ? 'success' : ($stats['weekly_goal_percentage'] >= 75 ? 'warning' : 'primary') }}"
                             role="progressbar" style="width: {{ min(100, $stats['weekly_goal_percentage']) }}%"></div>
                    </div>
                    <div class="row text-center">
                        <div class="col-6">
                            <small class="text-muted d-block">Faltan</small>
                            <strong class="text-primary">{{ max(0, $stats['weekly_goal'] - $stats['weekly_progress']) }}</strong>
                        </div>
                        <div class="col-6">
                            <small class="text-muted d-block">Días restantes</small>
                            <strong class="text-info">{{ 7 - now()->dayOfWeek }}</strong>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="card h-100">
                <div class="card-header">
                    <h5 class="mb-0"><i class="ri-line-chart-line me-2"></i>Rendimiento Mensual</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-4 text-center">
                            <div class="avatar avatar-lg mx-auto mb-2">
                                <div class="avatar-initial bg-label-primary rounded">
                                    <i class="ri-calendar-line fs-4"></i>
                                </div>
                            </div>
                            <h4 class="mb-0 text-primary">{{ $performance['this_month'] }}</h4>
                            <small class="text-muted">Este mes</small>
                        </div>
                        <div class="col-4 text-center">
                            <div class="avatar avatar-lg mx-auto mb-2">
                                <div class="avatar-initial bg-label-secondary rounded">
                                    <i class="ri-history-line fs-4"></i>
                                </div>
                            </div>
                            <h4 class="mb-0 text-secondary">{{ $performance['last_month'] }}</h4>
                            <small class="text-muted">Mes anterior</small>
                        </div>
                        <div class="col-4 text-center">
                            <div class="avatar avatar-lg mx-auto mb-2">
                                <div class="avatar-initial bg-label-{{ $performance['growth_percentage'] >= 0 ? 'success' : 'danger' }} rounded">
                                    <i class="ri-arrow-{{ $performance['growth_percentage'] >= 0 ? 'up' : 'down' }}-line fs-4"></i>
                                </div>
                            </div>
                            <h4 class="mb-0 text-{{ $performance['growth_percentage'] >= 0 ? 'success' : 'danger' }}">{{ $performance['growth_percentage'] > 0 ? '+' : '' }}{{ $performance['growth_percentage'] }}%</h4>
                            <small class="text-muted">Crecimiento</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Acciones Rápidas -->
    <div class="row g-4 mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="ri-flashlight-line me-2"></i>Acciones Rápidas</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        @foreach($quickActions as $action)
                        <div class="col-lg-3 col-md-6">
                            <button wire:click="{{ $action['action'] }}" class="btn btn-outline-{{ $action['color'] }} w-100 d-flex flex-column align-items-center justify-content-center p-3 hover-shadow" style="min-height: 80px; transition: all 0.2s;">
                                <i class="{{ $action['icon'] }} mb-2 fs-3"></i>
                                <span class="fw-medium">{{ $action['title'] }}</span>
                            </button>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Notificaciones y Pedidos Recientes -->
    <div class="row g-4 mb-4">
        <div class="col-lg-12">
            @livewire('admin.real-time-notifications')
        </div>
        <div class="col-lg-12">
            <div class="card h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div class="d-flex align-items-center">
                        <h5 class="mb-0 me-3"><i class="ri-shopping-cart-line me-2"></i>Mis Pedidos Recientes</h5>
                        <span class="badge bg-label-primary rounded-pill">{{ $recentOrders->count() }}</span>
                    </div>
                    <div class="d-flex gap-2">
                        <button wire:click="refreshDashboard" class="btn btn-sm btn-outline-secondary" title="Actualizar">
                            <i class="ri-refresh-line"></i>
                        </button>
                        <button wire:click="viewMyOrders" class="btn btn-sm btn-primary">
                            <i class="ri-external-link-line me-1"></i> Ver Todos
                        </button>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="perfect-scrollbar" style="height: 420px;">
                        @forelse($recentOrders as $order)
                            <div class="order-item d-flex align-items-center p-3 border-bottom hover-bg-light" style="cursor: pointer; transition: all 0.2s;" onclick="window.open('{{ route('admin.empleados.pedido.detalle', $order->codigo) }}', '_blank')">
                                <!-- Estado Visual -->
                                <div class="status-indicator me-3">
                                    <div class="avatar avatar-sm">
                                        <div class="avatar-initial bg-label-{{ $order->estado == 'Pendiente' ? 'warning' : ($order->estado == 'entregado' ? 'success' : ($order->estado == 'Procesando' ? 'info' : 'secondary')) }} rounded">
                                            @if($order->estado == 'Pendiente')
                                                <i class="ri-time-line"></i>
                                            @elseif($order->estado == 'Procesando')
                                                <i class="ri-loader-4-line"></i>
                                            @elseif($order->estado == 'entregado')
                                                <i class="ri-check-line"></i>
                                            @else
                                                <i class="ri-file-list-line"></i>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <!-- Información Principal -->
                                <div class="flex-grow-1">
                                    <div class="d-flex justify-content-between align-items-start mb-1">
                                        <div class="d-flex align-items-center gap-2">
                                            <h6 class="mb-0 fw-bold">#{{ $order->codigo }}</h6>
                                            <span class="badge bg-{{ $order->estado == 'Pendiente' ? 'warning' : ($order->estado == 'entregado' ? 'success' : ($order->estado == 'Procesando' ? 'info' : 'secondary')) }} rounded-pill">{{ $order->estado }}</span>
                                        </div>
                                        <small class="text-muted">{{ $order->created_at->format('H:i') }}</small>
                                    </div>

                                    <div class="d-flex align-items-center mb-1">
                                        <i class="ri-user-line me-2 text-muted fs-6"></i>
                                        <span class="text-dark fw-medium">{{ $order->user->name ?? 'Cliente' }}</span>
                                        <span class="mx-2 text-muted">•</span>
                                        <span class="text-primary fw-semibold">{{ format_money($order->total_usd) }}</span>
                                    </div>

                                    <div class="d-flex align-items-center text-muted">
                                        <i class="ri-calendar-line me-2 fs-6"></i>
                                        <small>{{ $order->created_at->diffForHumans() }}</small>
                                        <span class="mx-2">•</span>
                                        <i class="ri-shopping-bag-line me-1 fs-6"></i>
                                        <small>{{ $order->detalles->count() }} {{ $order->detalles->count() == 1 ? 'producto' : 'productos' }}</small>
                                        @if($order->ubicacion)
                                            <span class="mx-2">•</span>
                                            <i class="ri-map-pin-line me-1 fs-6"></i>
                                            <small>{{ Str::limit($order->ubicacion, 25) }}</small>
                                        @endif
                                    </div>
                                </div>

                                <!-- Acciones Rápidas -->
                                <div class="action-buttons d-flex gap-1 ms-2" onclick="event.stopPropagation();">
                                    @if($order->estado == 'Pendiente')
                                        <button class="btn btn-sm btn-success" wire:click="updateOrderStatus({{ $order->id }}, 'Procesando')" title="Procesar Pedido">
                                            <i class="ri-play-line"></i>
                                        </button>
                                    @elseif($order->estado == 'Procesando')
                                        <button class="btn btn-sm btn-primary" wire:click="updateOrderStatus({{ $order->id }}, 'entregado')" title="Marcar Entregado">
                                            <i class="ri-check-line"></i>
                                        </button>
                                    @endif

                                    @if($order->user->telefono)
                                        <a href="tel:{{ $order->user->telefono }}" class="btn btn-sm btn-outline-success" title="Llamar Cliente">
                                            <i class="ri-phone-line"></i>
                                        </a>
                                    @endif

                                    @if($order->latitud && $order->longitud)
                                        <a href="https://www.google.com/maps/dir//{{ $order->latitud }},{{ $order->longitud }}" target="_blank" class="btn btn-sm btn-outline-info" title="Navegar">
                                            <i class="ri-navigation-line"></i>
                                        </a>
                                    @endif
                                </div>
                            </div>
                        @empty
                            <div class="empty-state text-center py-5">
                                <div class="avatar avatar-xl mx-auto mb-3">
                                    <div class="avatar-initial bg-label-secondary rounded">
                                        <i class="ri-shopping-bag-line" style="font-size: 2rem;"></i>
                                    </div>
                                </div>
                                <h6 class="text-muted mb-2">No tienes pedidos asignados</h6>
                                <p class="text-muted mb-3 small">Los pedidos que te asignen aparecerán aquí</p>
                                <button wire:click="refreshDashboard" class="btn btn-sm btn-outline-primary">
                                    <i class="ri-refresh-line me-1"></i> Actualizar
                                </button>
                            </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>


</div>

@push('styles')
<style>
.hover-shadow:hover { box-shadow: 0 4px 12px rgba(0,0,0,0.1) !important; }
.hover-bg-light:hover { background-color: #f8f9fa !important; }
.timeline-item { transition: all 0.2s ease; }
.perfect-scrollbar {
    position: relative;
    overflow: hidden;
}
.order-item:hover {
    background-color: #f8f9fa;
    transform: translateX(2px);
}
.order-item .action-buttons {
    opacity: 0.7;
    transition: opacity 0.2s ease;
}
.order-item:hover .action-buttons {
    opacity: 1;
}
.status-indicator .avatar {
    position: relative;
}
.status-indicator .avatar::after {
    content: '';
    position: absolute;
    top: -2px;
    right: -2px;
    width: 8px;
    height: 8px;
    border-radius: 50%;
    border: 2px solid white;
}
.bg-label-warning .avatar::after { background-color: #ff9f43; }
.bg-label-success .avatar::after { background-color: #28c76f; }
.bg-label-info .avatar::after { background-color: #00cfe8; }
.empty-state {
    padding: 3rem 1rem;
}
</style>
@endpush

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    if (typeof PerfectScrollbar !== 'undefined') {
        const scrollContainer = document.querySelector('.perfect-scrollbar');
        if (scrollContainer) {
            new PerfectScrollbar(scrollContainer, {
                wheelSpeed: 2,
                wheelPropagation: false,
                minScrollbarLength: 20
            });
        }
    }
});
</script>
@endpush
