<div>
    @section('title', 'Dashboard')

    @push('styles')
    <style>
        /* Eliminar overlays problemáticos */
        .modal-backdrop,
        .offcanvas-backdrop,
        .tooltip,
        .popover {
            display: none !important;
        }

        .alert-icon {
            font-size: 1.5rem;
        }

        .top-employee-badge {
            font-size: 0.9rem;
        }

        .medal-icon {
            font-size: 1.8rem;
        }

        .employee-ranking-card {
            transition: transform 0.2s ease-in-out;
        }

        .employee-ranking-card:hover {
            transform: translateY(-3px);
        }

        .gold-medal {
            border: 2px solid #FFD700 !important;
            box-shadow: 0 0 10px rgba(255, 215, 0, 0.3);
        }

        .silver-medal {
            border: 2px solid #C0C0C0 !important;
            box-shadow: 0 0 10px rgba(192, 192, 192, 0.3);
        }

        .bronze-medal {
            border: 2px solid #CD7F32 !important;
            box-shadow: 0 0 10px rgba(205, 127, 50, 0.3);
        }

        .comparison-chart-container {
            min-height: 200px;
        }

        .comparison-value {
            font-size: 1.8rem;
            font-weight: 600;
        }
    </style>
    @endpush

    <!-- Compact Period Selector -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h4 class="mb-1">Dashboard Administrativo</h4>
                    <p class="text-muted mb-0">Período: <span class="fw-medium">{{ $dateRangeOptions[$dateRange] }}</span></p>
                </div>
                <div class="d-flex align-items-center gap-2">
                    <div class="btn-group" role="group">
                        <button class="btn btn-sm {{ $dateRange === 'week' ? 'btn-primary' : 'btn-outline-primary' }}" wire:click="updateDateRange('week')">Semana</button>
                        <button class="btn btn-sm {{ $dateRange === 'month' ? 'btn-primary' : 'btn-outline-primary' }}" wire:click="updateDateRange('month')">Mes</button>
                        <button class="btn btn-sm {{ $dateRange === 'quarter' ? 'btn-primary' : 'btn-outline-primary' }}" wire:click="updateDateRange('quarter')">Trimestre</button>
                        <button class="btn btn-sm {{ $dateRange === 'year' ? 'btn-primary' : 'btn-outline-primary' }}" wire:click="updateDateRange('year')">Año</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Stats Cards -->
    <div class="row g-4 mb-4">
        <div class="col-xl-3 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="text-muted mb-1">Total Pedidos</h6>
                            <h3 class="mb-0 text-primary">{{ number_format($stats['total_orders']) }}</h3>
                            @if($stats['orders_growth'] != 0)
                            <small class="text-{{ $stats['orders_growth'] >= 0 ? 'success' : 'danger' }}">
                                <i class="ri-arrow-{{ $stats['orders_growth'] >= 0 ? 'up' : 'down' }}-line"></i>
                                {{ abs($stats['orders_growth']) }}% vs período anterior
                            </small>
                            @endif
                        </div>
                        <div class="avatar avatar-lg">
                            <div class="avatar-initial bg-primary rounded">
                                <i class="ri-shopping-cart-line ri-1x text-white"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="text-muted mb-1">Ventas Totales</h6>
                            <h3 class="mb-0 text-success">{{ format_money($stats['total_sales']) }}</h3>
                            @if($stats['sales_growth'] != 0)
                            <small class="text-{{ $stats['sales_growth'] >= 0 ? 'success' : 'danger' }}">
                                <i class="ri-arrow-{{ $stats['sales_growth'] >= 0 ? 'up' : 'down' }}-line"></i>
                                {{ abs($stats['sales_growth']) }}% vs período anterior
                            </small>
                            @endif
                        </div>
                        <div class="avatar avatar-lg">
                            <div class="avatar-initial bg-success rounded">
                                <i class="ri-money-dollar-circle-line ri-1x text-white"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="text-muted mb-1">Nuevos Clientes</h6>
                            <h3 class="mb-0 text-info">{{ number_format($stats['total_customers']) }}</h3>
                            <small class="text-muted">En el período seleccionado</small>
                        </div>
                        <div class="avatar avatar-lg">
                            <div class="avatar-initial bg-info rounded">
                                <i class="ri-user-add-line ri-1x text-white"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="text-muted mb-1">Valor Promedio</h6>
                            <h3 class="mb-0 text-warning">{{ format_money($stats['avg_order_value']) }}</h3>
                            <small class="text-muted">Por pedido</small>
                        </div>
                        <div class="avatar avatar-lg">
                            <div class="avatar-initial bg-warning rounded">
                                <i class="ri-calculator-line ri-1x text-white"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-6 mb-6">
        <!-- Sales Overview -->
        <div class="col-lg-8">
            <div class="card h-100">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-1">Resumen de Ventas - {{ $dateRangeOptions[$dateRange] }}</h5>
                        <div class="d-flex align-items-center">
                            <span class="badge bg-label-primary me-2">{{ $dateRangeOptions[$dateRange] ?? 'Este mes' }}</span>
                        </div>
                    </div>
                    <div class="d-flex align-items-center card-subtitle">
                        <div class="me-2">Total {{ $stats['total_orders'] }} Pedidos</div>
                        <div class="d-flex align-items-center {{ $stats['orders_growth'] >= 0 ? 'text-success' : 'text-danger' }}">
                            <p class="mb-0 fw-medium">{{ $stats['orders_growth'] >= 0 ? '+' : '' }}{{ number_format($stats['orders_growth'], 1) }}%</p>
                            <i class="ri-arrow-{{ $stats['orders_growth'] >= 0 ? 'up' : 'down' }}-line"></i>
                            <small class="ms-2 text-muted">vs período anterior</small>
                        </div>
                    </div>
                </div>
                <div class="card-body d-flex justify-content-between flex-wrap gap-4">
                    <div class="d-flex align-items-center gap-3">
                        <div class="avatar">
                            <div class="avatar-initial bg-label-success rounded">
                                <i class="ri-check-double-line ri-1x"></i>
                            </div>
                        </div>
                        <div class="card-info">
                            <h5 class="mb-0">{{ $stats['completed_orders'] }}</h5>
                            <p class="mb-0">Completados</p>
                            <small class="text-muted">{{ $stats['conversion_rate'] }}% tasa conversión</small>
                        </div>
                    </div>
                    <div class="d-flex align-items-center gap-3">
                        <div class="avatar">
                            <div class="avatar-initial bg-label-warning rounded">
                                <i class="ri-time-line"></i>
                            </div>
                        </div>
                        <div class="card-info">
                            <h5 class="mb-0">{{ $stats['pending_orders'] }}</h5>
                            <p class="mb-0">Pendientes</p>
                            <small class="text-muted">Requieren atención</small>
                        </div>
                    </div>
                    <div class="d-flex align-items-center gap-3">
                        <div class="avatar">
                            <div class="avatar-initial bg-label-info rounded">
                                <i class="ri-shopping-bag-line"></i>
                            </div>
                        </div>
                        <div class="card-info">
                            <h5 class="mb-0">{{ number_format($stats['total_products']) }}</h5>
                            <p class="mb-0">Productos</p>
                            <small class="text-muted">En catálogo</small>
                        </div>
                    </div>
                    <div class="d-flex align-items-center gap-3">
                        <div class="avatar">
                            <div class="avatar-initial bg-label-secondary rounded">
                                <i class="ri-timer-line delivery-time-icon"></i>
                            </div>
                        </div>
                        <div class="card-info">
                            <h5 class="mb-0">{{ $performance['avg_delivery_time'] }} días</h5>
                            <p class="mb-0">Tiempo Entrega</p>
                            <small class="text-muted">Promedio</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Order Status -->
        <div class="col-lg-2 col-sm-6">
            <div class="card h-100">
                <div class="row">
                    <div class="col-12">
                        <div class="card-body">
                            <div class="card-info mb-3">
                                <h6 class="mb-2 text-nowrap">Pedidos Pendientes</h6>
                                <div class="badge bg-label-warning rounded-pill lh-xs">Requieren Atención</div>
                            </div>
                            <div class="d-flex align-items-center justify-content-center">
                                <h4 class="mb-0 me-2">{{ $stats['pending_orders'] }}</h4>
                                <p class="mb-0 text-warning">Pendientes</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Completed Orders -->
        <div class="col-lg-2 col-sm-6">
            <div class="card h-100">
                <div class="row">
                    <div class="col-12">
                        <div class="card-body">
                            <div class="card-info mb-3">
                                <h6 class="mb-2 text-nowrap">Completados</h6>
                                <div class="badge bg-label-success rounded-pill lh-xs">Este Período</div>
                            </div>
                            <div class="d-flex align-items-center justify-content-center">
                                <h4 class="mb-0 me-2">{{ $stats['completed_orders'] }}</h4>
                                <p class="mb-0 text-success">Finalizados</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Additional Key Metrics -->
    <div class="row g-6 mb-6">
        <!-- Repeat Customers -->
        <div class="col-lg-3 col-sm-6">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="mb-1">Clientes Recurrentes</h6>
                            <h4 class="mb-0 text-primary">{{ number_format($performance['repeat_customers'], 1) }}%</h4>
                            <small class="text-muted">Con múltiples pedidos</small>
                        </div>
                        <div class="avatar">
                            <div class="avatar-initial bg-label-primary rounded">
                                <i class=" ri-user-follow-line"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Average Response Time -->
        <div class="col-lg-3 col-sm-6">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="mb-1">Tiempo Respuesta</h6>
                            <h4 class="mb-0 text-warning">{{ $performance['avg_response_time'] }} min</h4>
                            <small class="text-muted">Soporte al cliente</small>
                        </div>
                        <div class="avatar">
                            <div class="avatar-initial bg-label-warning rounded">
                                <i class=" ri-timer-flash-line"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Cancellation Rate -->
        <div class="col-lg-3 col-sm-6">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="mb-1">Tasa Cancelación</h6>
                            <h4 class="mb-0 text-danger">{{ number_format($performance['cancellation_rate'], 1) }}%</h4>
                            <small class="text-muted">Pedidos cancelados</small>
                        </div>
                        <div class="avatar">
                            <div class="avatar-initial bg-label-danger rounded">
                                <i class=" ri-close-circle-line"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Inventory Turnover -->
        <div class="col-lg-3 col-sm-6">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="mb-1">Rotación Inventario</h6>
                            <h4 class="mb-0 text-success">{{ format_money($performance['inventory_turnover'], 1) }}</h4>
                            <small class="text-muted">Veces al mes</small>
                        </div>
                        <div class="avatar">
                            <div class="avatar-initial bg-label-success rounded">
                                <i class=" ri-loop-right-line"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Alerts Section -->
    @if($alerts->count() > 0)
    <div class="row g-6 mb-6">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Alertas</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        @foreach($alerts as $alert)
                        <div class="col-md-6 col-lg-4">
                            <div class="alert alert-{{ $alert['type'] }} alert-dismissible fade show" role="alert">
                                <div class="d-flex align-items-center">
                                    <iconify-icon icon="{{ $alert['icon'] }}" class="me-2"></iconify-icon>
                                    <div>
                                        <h6 class="mb-1">{{ $alert['title'] }}</h6>
                                        <p class="mb-0">{{ $alert['message'] }}</p>
                                    </div>
                                </div>
                                @if(isset($alert['action']))
                                <a href="{{ $alert['action'] }}" class="btn btn-sm btn-{{ $alert['type'] }} mt-2">Ver detalles</a>
                                @endif
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Monthly Comparison Chart -->
    <div class="row g-6 mb-6">
        <div class="col-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Comparación de Pedidos Entregados</h5>
                    <small class="text-muted">Mes actual vs mes anterior</small>
                </div>
                <div class="card-body">
                    <div class="row g-4 align-items-center">
                        <div class="col-lg-4">
                            <div class="d-flex justify-content-between">
                                <div class="text-center">
                                    <div class="comparison-value text-primary">{{ $monthlyComparison['current'] }}</div>
                                    <p class="mb-0 text-muted">Mes Actual</p>
                                    <small class="text-muted">{{ now()->format('F') }}</small>
                                </div>
                                <div class="text-center align-self-center">
                                    <iconify-icon icon="ri:arrow-left-right-line" class="text-muted" style="font-size: 1.5rem;"></iconify-icon>
                                </div>
                                <div class="text-center">
                                    <div class="comparison-value {{ $monthlyComparison['change'] >= 0 ? 'text-success' : 'text-danger' }}">{{ $monthlyComparison['previous'] }}</div>
                                    <p class="mb-0 text-muted">Mes Anterior</p>
                                    <small class="text-muted">{{ now()->subMonth()->format('F') }}</small>
                                </div>
                            </div>
                            <div class="mt-3 text-center">
                                <span class="badge bg-label-{{ $monthlyComparison['change'] >= 0 ? 'success' : 'danger' }} p-2">
                                    @if($monthlyComparison['change'] >= 0)
                                        <iconify-icon icon="ri:arrow-up-line" class="me-1"></iconify-icon>
                                    @else
                                        <iconify-icon icon="ri:arrow-down-line" class="me-1"></iconify-icon>
                                    @endif
                                    {{ $monthlyComparison['change'] >= 0 ? '+' : '' }}{{ format_money($monthlyComparison['change'], 1) }}%
                                    respecto al mes anterior
                                </span>
                            </div>
                        </div>
                        <div class="col-lg-8">
                            <div id="monthlyComparisonChart" class="comparison-chart-container" wire:ignore></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-6 col-lg-5">
            @livewire('admin.real-time-notifications')
        </div>
    </div>

    <!-- Top Employee Section -->
    @if($topEmployee && $topEmployee->count() > 0 && $this->canShowSection('employees'))
    <div class="row g-6 mb-6">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Empleados Destacados del Año</h5>
                </div>
                <div class="card-body">
                    <div class="row g-4">
                        @foreach($topEmployee as $index => $employee)
                        <div class="col-md-4">
                            <div class="d-flex align-items-center">
                                @if($index == 0)
                                <!-- Oro -->
                                <div class="avatar avatar-lg me-3">
                                    <div class="avatar-initial bg-label-warning rounded-circle gold-medal">
                                        <i class="ri-award-line ri-1x text-warning medal-icon"></i>
                                    </div>
                                </div>
                                @elseif($index == 1)
                                <!-- Plata -->
                                <div class="avatar avatar-lg me-3">
                                    <div class="avatar-initial bg-label-secondary rounded-circle silver-medal">
                                        <i class="ri-award-line ri-1x text-secondary medal-icon"></i>
                                    </div>
                                </div>
                                @else
                                <!-- Bronce -->
                                <div class="avatar avatar-lg me-3">
                                    <div class="avatar-initial bg-label-danger rounded-circle bronze-medal">
                                        <i class="ri-award-line ri-1x text-danger medal-icon"></i>
                                    </div>
                                </div>
                                @endif

                                <div class="flex-grow-1">
                                    <h5 class="mb-0">{{ $employee->name }}</h5>
                                    <p class="mb-0 text-muted">
                                        {{ $employee->total_deliveries }} entregas completadas
                                    </p>
                                </div>

                                @if($index == 0)
                                <div class="badge bg-warning rounded-pill">
                                    Oro
                                </div>
                                @elseif($index == 1)
                                <div class="badge bg-secondary rounded-pill">
                                    Plata
                                </div>
                                @else
                                <div class="badge bg-danger rounded-pill">
                                    Bronce
                                </div>
                                @endif
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

    <div class="row g-6 mb-6">
        <!-- Sales Chart -->
        @if($this->canShowSection('charts'))
        <div class="col-lg-8">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-header bg-transparent border-bottom">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-1">Tendencia de Ventas</h5>
                            <small class="text-muted">{{ $dateRangeOptions[$dateRange] }}</small>
                        </div>
                        <div class="d-flex align-items-center gap-2">
                            <span class="badge bg-primary">{{ $salesChart->count() }} períodos</span>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-6">
                            <div class="d-flex align-items-center">
                                <div class="avatar avatar-sm me-2">
                                    <div class="avatar-initial bg-success rounded">
                                        <i class="ri-money-dollar-circle-line"></i>
                                    </div>
                                </div>
                                <div>
                                    <h6 class="mb-0">{{ format_money($salesChart->sum('sales')) }}</h6>
                                    <small class="text-muted">Ventas Totales</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="d-flex align-items-center">
                                <div class="avatar avatar-sm me-2">
                                    <div class="avatar-initial bg-primary rounded">
                                        <i class="ri-shopping-cart-line"></i>
                                    </div>
                                </div>
                                <div>
                                    <h6 class="mb-0">{{ $salesChart->sum('orders') }}</h6>
                                    <small class="text-muted">Pedidos Totales</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="salesChart" style="min-height: 300px;" wire:ignore></div>
                </div>
            </div>
        </div>

        <!-- Payment Methods Chart -->
        <div class="col-lg-4">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-header bg-transparent border-bottom">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Métodos de Pago</h5>
                        <span class="badge bg-light text-dark">{{ $paymentMethods->sum('count') }} pedidos</span>
                    </div>
                </div>
                <div class="card-body">
                    @if($paymentMethods->count() > 0)
                        <div id="paymentChart" style="min-height: 250px;" wire:ignore></div>
                        <div class="mt-3">
                            @foreach($paymentMethods as $method => $data)
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="text-muted">{{ ucfirst($method) }}</span>
                                <div class="text-end">
                                    <div class="fw-medium">{{ $data['count'] }} pedidos</div>
                                    <small class="text-muted">{{ format_money($data['total']) }}</small>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-4">
                            <i class="ri-pie-chart-line ri-3x text-muted mb-2"></i>
                            <p class="text-muted mb-0">No hay datos de métodos de pago</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
        @endif
    </div>

    <!-- Business Health Indicators -->
    @if($this->canShowSection('metrics'))
    <div class="row g-6 mb-6">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Indicadores de Salud del Negocio</h5>
                </div>
                <div class="card-body">
                    <div class="row g-4">
                        <div class="col-md-3">
                            <div class="d-flex align-items-center">
                                <div class="avatar me-3">
                                    <div class="avatar-initial bg-label-success rounded">
                                        <i class="ri-check-double-line"></i>
                                    </div>
                                </div>
                                <div>
                                    <h5 class="mb-0">{{ $stats['completed_orders'] }}</h5>
                                    <small class="text-muted">Pedidos Completados</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="d-flex align-items-center">
                                <div class="avatar me-3">
                                    <div class="avatar-initial bg-label-warning rounded">
                                        <i class="ri-time-line"></i>
                                    </div>
                                </div>
                                <div>
                                    <h5 class="mb-0">{{ $stats['pending_orders'] }}</h5>
                                    <small class="text-muted">Pedidos Pendientes</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="d-flex align-items-center">
                                <div class="avatar me-3">
                                    <div class="avatar-initial bg-label-primary rounded">
                                        <i class="ri-money-dollar-circle-line"></i>
                                    </div>
                                </div>
                                <div>
                                    <h5 class="mb-0">{{ format_money($stats['total_sales']) }}</h5>
                                    <small class="text-muted">Ventas Totales</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="d-flex align-items-center">
                                <div class="avatar me-3">
                                    <div class="avatar-initial bg-label-info rounded">
                                        <i class="ri-timer-line"></i>
                                    </div>
                                </div>
                                <div>
                                    <h5 class="mb-0">{{ $performance['avg_delivery_time'] }} días</h5>
                                    <small class="text-muted">Tiempo Entrega</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

    <div class="row g-6 mb-6">
        <!-- Performance Metrics -->
        @if($this->canShowSection('performance'))
        <div class="col-lg-3 col-sm-6">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="mb-1">Valor Promedio</h6>
                            <h4 class="mb-0 text-primary">{{ format_money($performance['avg_order_value']) }}</h4>
                            <small class="text-muted">Por pedido</small>
                        </div>
                        <div class="avatar">
                            <div class="avatar-initial bg-label-primary rounded">
                                <i class=" ri-calculator-line"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-sm-6">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="mb-1">Tasa Conversión</h6>
                            <h4 class="mb-0 text-success">{{ format_money($performance['conversion_rate'], 1) }}%</h4>
                            <small class="text-muted">Pedidos completados</small>
                        </div>
                        <div class="avatar">
                            <div class="avatar-initial bg-label-success rounded">
                                <i class=" ri-percent-line"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-sm-6">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="mb-1">Stock Crítico</h6>
                            <h4 class="mb-0 text-warning">{{ $stats['critical_stock'] ?? 0 }}</h4>
                            <small class="text-muted">Productos ≤ 5 unidades</small>
                        </div>
                        <div class="avatar">
                            <div class="avatar-initial bg-label-warning rounded">
                                <i class=" ri-alert-line"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-sm-6">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="mb-1">Sin Stock</h6>
                            <h4 class="mb-0 text-danger">{{ $stats['out_of_stock'] ?? 0 }}</h4>
                            <small class="text-muted">Productos agotados</small>
                        </div>
                        <div class="avatar">
                            <div class="avatar-initial bg-label-danger rounded">
                                <i class=" ri-close-circle-line"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif
    </div>

    <div class="row g-6">
        <!-- Recent Orders -->
        <div class="col-12 col-md-6 col-xl-8">
            <div class="card h-100">
                <div class="card-header">
                    <div class="d-flex justify-content-between">
                        <h5 class="mb-0">Pedidos Recientes</h5>
                        <a href="{{ route('admin.pedidos.index') }}" class="btn btn-sm btn-outline-primary">Ver Todos</a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Pedido</th>
                                    <th>Cliente</th>
                                    <th>Estado</th>
                                    <th>Total</th>
                                    <th>Fecha</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($recentOrders as $order)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar avatar-sm me-2">
                                                    <div class="avatar-initial bg-label-primary rounded">
                                                        <i class=" ri-file-list-line"></i>
                                                    </div>
                                                </div>
                                                <span class="fw-medium">#{{ $order->codigo }}</span>
                                            </div>
                                        </td>
                                        <td>{{ $order->user->name ?? 'N/A' }}</td>
                                        <td>
                                            <span class="badge bg-label-{{ $order->estado == 'Pendiente' ? 'warning' : ($order->estado == 'Completado' ? 'success' : 'info') }} rounded-pill">
                                                {{ $order->estado }}
                                            </span>
                                        </td>
                                        <td class="fw-medium">{{ money($order->total_usd) }}</td>
                                        <td>{{ $order->created_at->format('d/m/Y') }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center text-muted">No hay pedidos recientes</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Top Products -->
        <div class="col-xl-4 col-md-6">
            <div class="card h-100">
                <div class="card-header">
                    <div class="d-flex justify-content-between">
                        <h5 class="mb-0">Productos Más Vendidos</h5>
                    </div>
                </div>
                <div class="card-body">
                    @forelse($topProducts as $index => $product)
                        <div class="d-flex align-items-center mb-4 {{ !$loop->last ? 'border-bottom pb-3' : '' }}">
                            <div class="avatar avatar-sm me-3">
                                <div class="avatar-initial bg-label-{{ ['primary', 'success', 'warning', 'info', 'secondary'][$index] ?? 'secondary' }} rounded">
                                    {{ $index + 1 }}
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-0">{{ Str::limit($product->name, 25) }}</h6>
                                <small class="text-muted">{{ $product->total_sold }} vendidos</small>
                            </div>
                        </div>
                    @empty
                        <div class="text-center text-muted">
                            <i class=" ri-shopping-bag-line fs-1 mb-3"></i>
                            <p class="mb-0">No hay datos de productos</p>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Esperar a que todos los elementos estén completamente cargados
            setTimeout(function() {
                initializeCharts();
            }, 100);
        });



        // Función para inicializar los gráficos
        function initializeCharts() {
            // Verificar que ApexCharts esté disponible
            if (typeof ApexCharts === 'undefined') {
                console.error('ApexCharts no está disponible');
                return;
            }

            // Monthly Comparison Chart
            var monthlyComparisonChartEl = document.getElementById('monthlyComparisonChart');
            if (monthlyComparisonChartEl) {
                // Verificar si ya existe una instancia del gráfico y destruirla si es necesario
                if (monthlyComparisonChartEl._chart) {
                    monthlyComparisonChartEl._chart.destroy();
                    delete monthlyComparisonChartEl._chart;
                }

                const monthlyData = @json($monthlyComparison);

                const monthlyComparisonChartConfig = {
                    chart: {
                        height: 200,
                        type: 'bar',
                        toolbar: {
                            show: false
                        }
                    },
                    plotOptions: {
                        bar: {
                            horizontal: false,
                            columnWidth: '55%',
                            endingShape: 'rounded'
                        },
                    },
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        show: true,
                        width: 2,
                        colors: ['transparent']
                    },
                    series: [{
                        name: 'Pedidos Entregados',
                        data: [monthlyData.previous, monthlyData.current]
                    }],
                    xaxis: {
                        categories: ['{{ now()->subMonth()->format('F') }}', '{{ now()->format('F') }}'],
                        labels: {
                            style: {
                                colors: '#9b9ea2',
                                fontSize: '13px',
                                fontFamily: 'Inter'
                            }
                        }
                    },
                    yaxis: {
                        labels: {
                            style: {
                                colors: '#9b9ea2',
                                fontSize: '13px',
                                fontFamily: 'Inter'
                            }
                        }
                    },
                    grid: {
                        show: true,
                        borderColor: '#f0f2f8',
                        strokeDashArray: 6
                    },
                    fill: {
                        opacity: 1
                    },
                    tooltip: {
                        y: {
                            formatter: function(value) {
                                return value + ' pedidos';
                            }
                        }
                    },
                    colors: ['#6c757d', monthlyData.change >= 0 ? '#28c76f' : '#ea5455']
                };

                const monthlyComparisonChart = new ApexCharts(monthlyComparisonChartEl, monthlyComparisonChartConfig);
                monthlyComparisonChart.render();
                monthlyComparisonChartEl._chart = monthlyComparisonChart; // Guardar referencia al gráfico
            }

            // Sales Chart
            var salesChartEl = document.getElementById('salesChart');
            if (salesChartEl) {
                // Verificar si ya existe una instancia del gráfico y destruirla si es necesario
                if (salesChartEl._chart) {
                    salesChartEl._chart.destroy();
                    delete salesChartEl._chart;
                }

                const salesData = @json($salesChart);



                if (!salesData || salesData.length === 0) {
                    salesChartEl.innerHTML = '<div class="d-flex justify-content-center align-items-center" style="height: 300px;"><p class="text-muted">No hay datos para el período seleccionado</p></div>';
                    return;
                }

                // Verificar que los datos no estén vacíos
                if (!salesData || salesData.length === 0) {
                    salesChartEl.innerHTML = '<div class="d-flex justify-content-center align-items-center" style="height: 300px;"><p class="text-muted">No hay datos disponibles para el rango seleccionado</p></div>';
                    return;
                }

                const salesChartConfig = {
                    chart: {
                        height: 300,
                        type: 'area',
                        toolbar: {
                            show: false
                        }
                    },
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        curve: 'smooth',
                        width: 3
                    },
                    legend: {
                        show: false
                    },
                    series: [{
                        name: 'Ventas (USD)',
                        data: salesData.map(item => parseFloat(item.sales || 0))
                    }],
                    xaxis: {
                        categories: salesData.map(item => item.period || 'N/A'),
                        axisBorder: {
                            show: false
                        },
                        axisTicks: {
                            show: false
                        },
                        labels: {
                            style: {
                                colors: '#9b9ea2',
                                fontSize: '13px',
                                fontFamily: 'Inter'
                            }
                        }
                    },
                    yaxis: {
                        labels: {
                            formatter: function(value) {
                                return '$' + value.toLocaleString();
                            },
                            style: {
                                colors: '#9b9ea2',
                                fontSize: '13px',
                                fontFamily: 'Inter'
                            }
                        }
                    },
                    grid: {
                        show: true,
                        borderColor: '#f0f2f8',
                        strokeDashArray: 6,
                        padding: {
                            left: 0,
                            right: 0
                        }
                    },
                    tooltip: {
                        y: {
                            formatter: function(value) {
                                return '$' + value.toLocaleString(undefined, {
                                    minimumFractionDigits: 2,
                                    maximumFractionDigits: 2
                                });
                            }
                        }
                    },
                    fill: {
                        type: 'gradient',
                        gradient: {
                            shade: 'light',
                            type: 'vertical',
                            shadeIntensity: 0.25,
                            gradientToColors: ['#7367f0'],
                            inverseColors: true,
                            opacityFrom: 0.8,
                            opacityTo: 0.1,
                            stops: [0, 100]
                        }
                    }
                };

                if (salesChartEl._chart) {
                    salesChartEl._chart.destroy();
                }
                const salesChart = new ApexCharts(salesChartEl, salesChartConfig);
                salesChart.render();
                salesChartEl._chart = salesChart;
            }

            // Payment Methods Chart
            var paymentChartEl = document.getElementById('paymentChart');
            if (paymentChartEl) {
                // Verificar si ya existe una instancia del gráfico y destruirla si es necesario
                if (paymentChartEl._chart) {
                    paymentChartEl._chart.destroy();
                    delete paymentChartEl._chart;
                }

                const paymentData = @json($paymentMethods);

                if (!paymentData || Object.keys(paymentData).length === 0) {
                    paymentChartEl.innerHTML = '<div class="d-flex justify-content-center align-items-center" style="height: 300px;"><p class="text-muted">No hay datos para el período seleccionado</p></div>';
                    return;
                }

                // Verificar que los datos no estén vacíos
                if (!paymentData || Object.keys(paymentData).length === 0) {
                    paymentChartEl.innerHTML = '<div class="d-flex justify-content-center align-items-center" style="height: 300px;"><p class="text-muted">No hay datos disponibles para el rango seleccionado</p></div>';
                    return;
                }

                const labels = Object.keys(paymentData);
                const values = Object.values(paymentData).map(val => {
                    if (typeof val === 'object' && val.count !== undefined) {
                        return parseInt(val.count);
                    }
                    return parseInt(val) || 0;
                });
                const colors = ['#7367f0', '#28c76f', '#ff9f43', '#ea5455', '#474360'];

                const paymentChartConfig = {
                    chart: {
                        height: 300,
                        type: 'donut'
                    },
                    labels: labels,
                    series: values,
                    colors: colors.slice(0, labels.length),
                    stroke: {
                        show: false,
                        width: 0
                    },
                    dataLabels: {
                        enabled: true,
                        formatter: function(val, opts) {
                            return opts.w.config.series[opts.seriesIndex];
                        }
                    },
                    legend: {
                        position: 'bottom',
                        markers: {
                            width: 8,
                            height: 8,
                            offsetX: -4
                        },
                        itemMargin: {
                            horizontal: 5,
                            vertical: 2
                        },
                        labels: {
                            colors: '#9b9ea2',
                            fontSize: '13px',
                            fontFamily: 'Inter'
                        }
                    },
                    tooltip: {
                        y: {
                            formatter: function(value) {
                                return value + ' pedidos';
                            }
                        }
                    },
                    states: {
                        hover: {
                            filter: {
                                type: 'none'
                            }
                        },
                        active: {
                            filter: {
                                type: 'none'
                            }
                        }
                    }
                };

                if (paymentChartEl._chart) {
                    paymentChartEl._chart.destroy();
                }
                const paymentChart = new ApexCharts(paymentChartEl, paymentChartConfig);
                paymentChart.render();
                paymentChartEl._chart = paymentChart;
            }
        }

        // Inicializar gráficos cuando Livewire esté listo
        document.addEventListener('livewire:init', function () {
            setTimeout(initializeCharts, 100);
        });

        // Reinicializar gráficos cuando Livewire se actualiza
        document.addEventListener('livewire:updated', function () {
            setTimeout(initializeCharts, 100);
        });

        // Escuchar evento de actualización de gráfico
        document.addEventListener('livewire:init', function () {
            Livewire.on('updateChart', (event) => {
                setTimeout(() => {
                    updateChartsWithNewData(event.chartData, event.paymentData);
                }, 100);
            });
        });

        function updateChartsWithNewData(newSalesData, newPaymentData) {
            // Actualizar Sales Chart
            var salesChartEl = document.getElementById('salesChart');
            if (salesChartEl && salesChartEl._chart && newSalesData) {
                salesChartEl._chart.updateSeries([{
                    name: 'Ventas (USD)',
                    data: newSalesData.map(item => parseFloat(item.sales || 0))
                }]);
                salesChartEl._chart.updateOptions({
                    xaxis: {
                        categories: newSalesData.map(item => item.period || 'N/A')
                    }
                });
            }

            // Actualizar Payment Chart
            var paymentChartEl = document.getElementById('paymentChart');
            if (paymentChartEl && paymentChartEl._chart && newPaymentData) {
                const labels = Object.keys(newPaymentData);
                const values = Object.values(newPaymentData).map(val => {
                    return typeof val === 'object' && val.count !== undefined ? parseInt(val.count) : parseInt(val) || 0;
                });

                paymentChartEl._chart.updateOptions({
                    labels: labels,
                    series: values
                });
            }
        }

        // Escuchar cambios en la URL
        window.addEventListener('popstate', function(event) {
            Livewire.dispatch('$refresh');
        });

        // Inicializar cuando la página carga
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(initializeCharts, 200);
        });
    </script>
    @endpush
</div>
