<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">
            <i class="ri-time-line me-2"></i>
            Estado de Automatización de Cajas y Tasas
        </h5>
        <div>
            <button wire:click="cargarDatos" class="btn btn-sm btn-outline-primary me-2">
                <i class="ri-refresh-line"></i> Actualizar
            </button>
            <span class="badge bg-{{ $config['en_verificacion_tasa'] ? 'success' : 'secondary' }}">
                {{ $config['hora_actual'] }}
            </span>
        </div>
    </div>
    <div class="card-body">
        <div class="row">
            {{-- Estado de Tasa --}}
            <div class="col-md-6 mb-3">
                <div class="card border-{{ $tasaActual ? 'success' : 'warning' }}">
                    <div class="card-body">
                        <h6 class="card-title">
                            <i class="ri-money-dollar-circle-line me-1"></i>
                            Tasa de Cambio
                        </h6>
                        @if($tasaActual)
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>USD = {{ number_format($tasaActual->usd_rate, 4) }} Bs.</strong>
                                    <br>
                                    <small class="text-muted">
                                        Fuente: {{ $tasaActual->source }} 
                                        | Actualizada: {{ $tasaActual->fetch_time }}
                                    </small>
                                </div>
                                <button wire:click="actualizarTasaManual" class="btn btn-sm btn-outline-primary">
                                    <i class="ri-refresh-line"></i>
                                </button>
                            </div>
                        @else
                            <div class="text-warning">
                                <i class="ri-alert-line"></i>
                                No hay tasa registrada hoy
                            </div>
                            <button wire:click="actualizarTasaManual" class="btn btn-sm btn-warning mt-2">
                                <i class="ri-refresh-line"></i> Actualizar Ahora
                            </button>
                        @endif
                    </div>
                </div>
            </div>

            {{-- Próximos Cortes de Caja --}}
            <div class="col-md-6 mb-3">
                <div class="card">
                    <div class="card-body">
                        <h6 class="card-title">
                            <i class="ri-time-line me-1"></i>
                            Próximos Cortes de Caja
                        </h6>
                        @if(count($proximosCortes) > 0)
                            @foreach($proximosCortes as $corte)
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <span class="text-primary">
                                        <i class="ri-calendar-todo-line"></i>
                                        {{ $corte['hora'] }}
                                    </span>
                                    <small class="text-muted">{{ $corte['faltan'] }}</small>
                                </div>
                            @endforeach
                        @else
                            <div class="text-muted">
                                <i class="ri-check-double-line"></i>
                                No hay cortes programados para hoy
                            </div>
                        @endif
                        <button wire:click="realizarCorteManual" class="btn btn-sm btn-outline-primary mt-2">
                            <i class="ri-scissors-cut-line"></i> Corte Manual
                        </button>
                    </div>
                </div>
            </div>
        </div>

        {{-- Configuración Actual --}}
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h6 class="card-title">Configuración de Automatización</h6>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="text-center">
                                    <div class="mb-2">
                                        <i class="ri-time-line fs-3 text-{{ $config['en_verificacion_tasa'] ? 'success' : 'secondary' }}"></i>
                                    </div>
                                    <small class="text-muted">Verificación Tasa</small>
                                    <br>
                                    <strong>{{ $config['en_verificacion_tasa'] ? 'Activa' : 'Inactiva' }}</strong>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="text-center">
                                    <div class="mb-2">
                                        <i class="ri-refresh-line fs-3 text-{{ $config['es_actualizacion_tasa'] ? 'warning' : 'secondary' }}"></i>
                                    </div>
                                    <small class="text-muted">Actualización Tasa</small>
                                    <br>
                                    <strong>{{ $config['es_actualizacion_tasa'] ? 'Ahora' : 'Esperando' }}</strong>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="text-center">
                                    <div class="mb-2">
                                        <i class="ri-scissors-cut-line fs-3 text-{{ $config['hora_corte_caja'] ? 'info' : 'secondary' }}"></i>
                                    </div>
                                    <small class="text-muted">Corte de Caja</small>
                                    <br>
                                    <strong>{{ $config['hora_corte_caja'] ? $config['hora_corte_caja'] : 'No' }}</strong>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="text-center">
                                    <div class="mb-2">
                                        <i class="ri-calendar-line fs-3 text-primary"></i>
                                    </div>
                                    <small class="text-muted">Próximo Corte</small>
                                    <br>
                                    <strong>{{ $config['proximo_corte_caja'] ?? 'N/A' }}</strong>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Logs Recientes --}}
        @if(count($logsRecientes) > 0)
            <div class="row mt-3">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <h6 class="card-title">
                                <i class="ri-file-list-line me-1"></i>
                                Logs Recientes
                            </h6>
                            <div style="max-height: 200px; overflow-y: auto;">
                                @foreach($logsRecientes as $log)
                                    <div class="small text-muted mb-1">
                                        <strong>{{ $log['archivo'] }}:</strong>
                                        {{ $log['linea'] }}
                                        <small class="float-end">{{ $log['fecha'] }}</small>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>

@push('scripts')
<script>
    // Actualizar cada 5 minutos
    setInterval(() => {
        Livewire.emit('refreshStatus');
    }, 300000);
</script>
@endpush