@section('styles')
<link rel="stylesheet" href="/assets/vendor/css/pages/app-academy.css" />
<link rel="stylesheet" href="/assets/vendor/libs/select2/select2.css" />
<link rel="stylesheet" href="/assets/vendor/libs/plyr/plyr.css" />


@endsection

<div class="row">

<section id="landingReviews" class=" mt-5 bg-body landing-reviews pb-0">
<!-- What people say slider: Start -->
<div wire:ignore>
  <div class="row align-items-center gx-0 gy-4 g-lg-3 mb-5 pb-md-3 mt-6">
    <div class="col-md-4 col-lg-3 col-xl-12" >
        <div class="swiper-reviews-carousel " >
        <div class="swiper" id="swiper-reviews" style="width: 60em;">
            <h6 class="mr-4">¡Hola! ¿Qué estás buscando hoy?</h6>
            @php
                $plast = \App\Models\Producto::where('status',1)->take(10)->orderBy('id','DESC')->get()
            @endphp
            <div class="swiper-wrapper">
            @foreach ($plast as $item)
            <div class="swiper-slide">
                <div class="card h-10">
                    <div class="card-body text-body d-flex flex-column justify-content-center">
                    <div class="mb-2">
                        <img
                        src="/media/producto/{{ $item->image->path }}"
                        alt="client logo"
                        style="max-width: 100%"  />
                    </div>
                    </div>
                </div>
                </div>
            @endforeach
            </div>

        </div>
        </div>
    </div>
  </div>
</div>

<!-- What people say slider: End -->
<!-- Logo slider: End -->

</section>
<div class="col-lg-6 text-start text-sm-center text-lg-start">
        <h3 class="cta-title text-primary fw-bold mb-0">Alimentos</h3>
        <h5 class="text-body mb-8">Nuestros productos son de excelente calidad.</h5>
    </div>
<section id="landingReviews" class=" bg-body landing-reviews pb-0">
    <!-- What people say slider: Start -->
    <div  wire:ignore>
      <div class="row align-items-center gx-0 ">

        <div class="col-md-6 col-lg-7 col-xl-12">
          <div class="swiper-reviews-carousel overflow-hidden">
            <div class="swiper" id="swiper-alimentos">
              <div class="swiper-wrapper">
                @php
                  $product = \App\Models\Producto::where('status',1)
                  ->where('categoriaId',1)
                  ->take(20)
                  ->orderBy('id','DESC')
                  ->get()
                @endphp
                 @foreach ($product as $item)
                 <div class="swiper-slide">
                    <div class="col-sm-12 col-lg-12">
                        <div class="card p-2 h-100 shadow-none border">
                          <div class="rounded-2 text-center mb-4">
                            <a href="/"
                              ><img
                              style="max-width: 60%"
                                src="/media/producto/{{ $item->image->path }}"
                                alt="tutor image 1"
                            /></a>
                          </div>
                          <div class="card-body p-4 pt-2">
                            <div class="d-flex justify-content-between align-items-center mb-4">
                              <span class="badge bg-label-primary">{{ $item->categoria->name }}</span>
                              <p class="d-flex align-items-center justify-content-center fw-medium gap-1 mb-0">
                                4.4 <span class="text-warning"><i class="ti ti-star-filled ti-lg me-1"></iconify-icon></span
                                ><span class="fw-normal">(1.23k)</span>
                              </p>
                            </div>
                            <a href="/" class="h5">{{ $item->name }}</a>
                            <p class="mt-1">{{ $item->description }}</p>
                            <p class="d-flex align-items-center mb-1"><i class="ti ti-coins me-1"></iconify-icon>{{ money($item->price) }}</p>
                            <div class="progress rounded-pill mb-4" style="height: 8px">

                            </div>
                            @auth
                            <div
                            class="d-flex flex-column flex-md-row gap-4 text-nowrap flex-wrap flex-md-nowrap flex-lg-wrap flex-xxl-nowrap">
                            <a  wire:click='addCart({{ $item->id }})' class="w-100 btn btn-label-secondary d-flex align-items-center">
                              <i class="ti ti-shopping-cart ti-xs align-middle scaleX-n1-rtl me-2"></iconify-icon></span>
                              <span class="add-to-cart">Añadir al carrito</span>
                          </a>
                          <a wire:click='addWishlist({{ $item->id }})' class="w-100 btn btn-label-primary d-flex align-items-center">
                              @if (\App\Models\Wishlist::where('producto_id',$item->id)->first() != null)
                              <i class="ti ti-heart ti-xs align-middle scaleX-n1-rtl me-2 text-danger"></iconify-icon></span>
                              @else
                              <i class="ti ti-heart ti-xs align-middle scaleX-n1-rtl me-2"></iconify-icon></span>
                              @endif
                              <span>Agregar a favoritos</span>
                              </a>
                          </div>
                            @endauth
                          </div>
                        </div>
                      </div>
                 </div>
                 @endforeach
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- What people say slider: End -->

    <!-- Logo slider: End -->
  </section>
  <section class="position-relative p-lg-0 pb-0 mb-5 gy-5"  wire:ignore>
    <img
    src="/media/banner/Banner-Largo-Ofertas-Web-1.jpg"
    class="img-fluid"
    alt="cta image"
 />
  </section>

<div class="col-lg-6 text-start text-sm-center text-lg-start gy-5">
    <h3 class="cta-title text-primary fw-bold mb-0">Bebidas</h3>
    <small class="text-body mb-8">Productos refrescantes.</small>
</div>
<section id="landingReviews" class=" bg-body landing-reviews pb-0">
<!-- What people say slider: Start -->
<div  wire:ignore>
  <div class="row align-items-center gx-0 gy-4 g-lg-5 mb-5 pb-md-5">

    <div class="col-md-6 col-lg-7 col-xl-12">
      <div class="swiper-reviews-carousel overflow-hidden">
        <div class="swiper" id="swiper-bebidas">
          <div class="swiper-wrapper">
            @php
              $product = \App\Models\Producto::where('status',1)
              ->where('categoriaId',2)
              ->take(20)
              ->orderBy('id','DESC')
              ->get()
            @endphp
             @foreach ($product as $item)
             <div class="swiper-slide">
                <div class="col-sm-12 col-lg-12">
                    <div class="card p-2 h-100 shadow-none border">
                      <div class="rounded-2 text-center mb-4">
                        <a href="/"
                          ><img
                          style="max-width: 60%"
                            src="/media/producto/{{ $item->image->path }}"
                            alt="tutor image 1"
                        /></a>
                      </div>
                      <div class="card-body p-4 pt-2">
                        <div class="d-flex justify-content-between align-items-center mb-4">
                          <span class="badge bg-label-primary">{{ $item->categoria->name }}</span>
                          <p class="d-flex align-items-center justify-content-center fw-medium gap-1 mb-0">
                            4.4 <span class="text-warning"><i class="ti ti-star-filled ti-lg me-1"></iconify-icon></span
                            ><span class="fw-normal">(1.23k)</span>
                          </p>
                        </div>
                        <a href="/" class="h5">{{ $item->name }}</a>
                        <p class="mt-1">{{ $item->description }}</p>
                        <p class="d-flex align-items-center mb-1"><i class="ti ti-coins me-1"></iconify-icon>{{ money($item->price) }}</p>
                        <div class="progress rounded-pill mb-4" style="height: 8px">

                        </div>
                        @auth
                        <div
                        class="d-flex flex-column flex-md-row gap-4 text-nowrap flex-wrap flex-md-nowrap flex-lg-wrap flex-xxl-nowrap">
                        <a  wire:click='addCart({{ $item->id }})' class="w-100 btn btn-label-secondary d-flex align-items-center">
                          <i class="ti ti-shopping-cart ti-xs align-middle scaleX-n1-rtl me-2"></iconify-icon></span>
                          <span class="add-to-cart">Añadir al carrito</span>
                      </a>
                      <a wire:click='addWishlist({{ $item->id }})' class="w-100 btn btn-label-primary d-flex align-items-center">
                          @if (\App\Models\Wishlist::where('producto_id',$item->id)->first() != null)
                          <i class="ti ti-heart ti-xs align-middle scaleX-n1-rtl me-2 text-danger"></iconify-icon></span>
                          @else
                          <i class="ti ti-heart ti-xs align-middle scaleX-n1-rtl me-2"></iconify-icon></span>
                          @endif
                          <span>Agregar a favoritos</span>
                          </a>
                      </div>
                        @endauth
                      </div>
                    </div>
                  </div>
             </div>
             @endforeach
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- What people say slider: End -->

<!-- Logo slider: End -->
</section>
<div class="app-academy">
    <div class="card p-0 mb-6">
      <div class="card-body d-flex flex-column flex-md-row justify-content-between p-0 pt-6">
        <div class="app-academy-md-25 card-body py-0 pt-6 ps-12">

        </div>
        <div
          class="app-academy-md-50 card-body d-flex align-items-md-center flex-column text-md-center mb-6 py-6">

          <p class="mb-4 px-0 px-md-2">
           Puedes usar nuestro buscador rápido, donde obtendrás los datos necesarios sobre nuestros productos para tu mayor comodidad y seguridad de compra.
          </p>
          <div class="d-flex align-items-center justify-content-between app-academy-md-80">
            <input type="search" wire:model.live='search' placeholder="Buscar producto" class="form-control me-4" />

          </div>
        </div>
        <div class="app-academy-md-25 card-body py-0 pt-6 ps-12">

        </div>
      </div>
    </div>

    <div class="card mb-6">
      <div class="card-header d-flex flex-wrap justify-content-between gap-4">
        <div class="card-title mb-0 me-1">
          <h5 class="mb-0">Nuestros productos</h5>
          <p class="mb-0">Total {{ count($productos) }} productos encontrados.</p>
        </div>
        <div class="d-flex justify-content-md-end align-items-center column-gap-6">
            <select name="" id="" class="form-select mt" wire:model.change='categoriaId'>
                <option value="">Categorías</option>
                @foreach ($categorias as $item)
                <option value="{{ $item->name }}">{{ $item->name }}</option>
                @endforeach
         </select>
         <select name="" id="" class="form-select" wire:model.live='perPage'>
            <option value="">Seleccione</option>
            <option value="10">10</option>
            <option value="20">20</option>
            <option value="30">30</option>
            <option value="40">40</option>
            <option value="50">50</option>
         </select>
        </div>
        <div class="result-toggler">
            @auth
            <div class="btn-group">
                <a class="btn btn-info" href="{{ route('wishlist.index') }}">Favoritos  <span style="margin-left: 2em;" class="badge bg-label-primary">@livewire('front.wishlist.index')</span></a>
                <a class="btn btn-primary" href="{{ route('cart.index') }}">Ver carrito  <span style="margin-left: 2em;" class="badge bg-label-primary">@livewire('front.cart.count')</span></a>
            </div>
                @else
                <div class="btn-group">
                    <a data-bs-toggle="modal" data-bs-target="#registerUser" class="btn btn-info btn-wishlist">

                        <span class="text-white">Registrarse</span>
                        </a>
                        <a  data-bs-toggle="modal" data-bs-target="#loginUser" class="btn btn-primary btn-cart">

                            <span class="text-white">Iniciar sesión</span>
                        </a>
                </div>
            @endauth
        </div>
      </div>
      <div class="card-body">
        @include('layouts.front.modals.data')
        <div class="row gy-6 mb-6">
            @foreach ($productos as $item)
            <div class="col-sm-6 col-lg-4">
                <div class="card p-2 h-100 shadow-none border">
                  <div class="rounded-2 text-center mb-4">
                    <a href="/"
                      ><img
                        class="img-fluid"
                        src="/media/producto/{{ $item->image->path }}"
                        alt="tutor image 1"
                    /></a>
                  </div>
                  <div class="card-body p-4 pt-2">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                      <span class="badge bg-label-primary">{{ $item->categoria->name }}</span>
                      <p class="d-flex align-items-center justify-content-center fw-medium gap-1 mb-0">
                        4.4 <span class="text-warning"><i class="ti ti-star-filled ti-lg me-1"></iconify-icon></span
                        ><span class="fw-normal">(1.23k)</span>
                      </p>
                    </div>
                    <a href="/" class="h5">{{ $item->name }}</a>
                    <p class="mt-1">{{ $item->description }}</p>
                    <p class="d-flex align-items-center mb-1"><i class="ti ti-coins me-1"></iconify-icon>{{ money($item->price) }}</p>
                    <div class="progress rounded-pill mb-4" style="height: 8px">

                    </div>
                    @auth
                    <div
                    class="d-flex flex-column flex-md-row gap-4 text-nowrap flex-wrap flex-md-nowrap flex-lg-wrap flex-xxl-nowrap">
                    <a  wire:click='addCart({{ $item->id }})' class="w-100 btn btn-label-secondary d-flex align-items-center">
                      <i class="ti ti-shopping-cart ti-xs align-middle scaleX-n1-rtl me-2"></iconify-icon></span>
                      <span class="add-to-cart">Añadir al carrito</span>
                  </a>
                  <a wire:click='addWishlist({{ $item->id }})' class="w-100 btn btn-label-primary d-flex align-items-center">
                      @if (\App\Models\Wishlist::where('producto_id',$item->id)->first() != null)
                      <i class="ti ti-heart ti-xs align-middle scaleX-n1-rtl me-2 text-danger"></iconify-icon></span>
                      @else
                      <i class="ti ti-heart ti-xs align-middle scaleX-n1-rtl me-2"></iconify-icon></span>
                      @endif
                      <span>Agregar a favoritos</span>
                      </a>
                  </div>
                    @endauth
                  </div>
                </div>
              </div>
            @endforeach

        </div>
      </div>
{{--
    <div class="row gy-6 mb-6">
      <div class="col-lg-6">
        <div class="card shadow-none bg-label-primary h-100">
          <div class="card-body d-flex justify-content-between flex-wrap-reverse">
            <div
              class="mb-0 w-100 app-academy-sm-60 d-flex flex-column justify-content-between text-center text-sm-start">
              <div class="card-title">
                <h5 class="text-primary mb-2">Earn a Certificate</h5>
                <p class="text-body w-sm-80 app-academy-xl-100">
                  Get the right professional certificate program for you.
                </p>
              </div>
              <div class="mb-0"><button class="btn btn-sm btn-primary">View Programs</button></div>
            </div>
            <div
              class="w-100 app-academy-sm-40 d-flex justify-content-center justify-content-sm-end h-px-150 mb-4 mb-sm-0">
              <img
                class="img-fluid scaleX-n1-rtl"
                src="/assets/img/illustrations/boy-app-academy.png"
                alt="boy illustration" />
            </div>
          </div>
        </div>
      </div>
      <div class="col-lg-6">
        <div class="card shadow-none bg-label-danger h-100">
          <div class="card-body d-flex justify-content-between flex-wrap-reverse">
            <div
              class="mb-0 w-100 app-academy-sm-60 d-flex flex-column justify-content-between text-center text-sm-start">
              <div class="card-title">
                <h5 class="text-danger mb-2">Best Rated Courses</h5>
                <p class="text-body app-academy-sm-60 app-academy-xl-100">
                  Enroll now in the most popular and best rated courses.
                </p>
              </div>
              <div class="mb-0"><button class="btn btn-sm btn-danger">View Courses</button></div>
            </div>
            <div
              class="w-100 app-academy-sm-40 d-flex justify-content-center justify-content-sm-end h-px-150 mb-4 mb-sm-0">
              <img
                class="img-fluid scaleX-n1-rtl"
                src="/assets/img/illustrations/girl-app-academy.png"
                alt="girl illustration" />
            </div>
          </div>
        </div>
      </div>
    </div>
     --}}
  </div>
</div>

