<!-- Modal Vista Rápida -->
<div class="modal fade" id="quickViewModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Vista Rápida del Producto</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="quickViewContent">
                <div class="text-center py-4">
                    <div class="spinner-border" role="status">
                        <span class="visually-hidden">Cargando...</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('livewire:init', () => {
    Livewire.on('openQuickView', (event) => {
        const productId = event.productId;

        // Mostrar modal
        const modal = new bootstrap.Modal(document.getElementById('quickViewModal'));
        modal.show();

        // Cargar contenido del producto
        fetch(`/api/product/${productId}/quick-view`)
            .then(response => response.json())
            .then(data => {
                if (data.error) {
                    throw new Error(data.error);
                }

                document.getElementById('quickViewContent').innerHTML = `
                    <div class="row">
                        <div class="col-md-6">
                            <img src="/media/producto/${data.image || '1746716467.webp'}"
                                 class="img-fluid rounded"
                                 alt="${data.name || 'Producto'}">
                        </div>
                        <div class="col-md-6">
                            <h4>${data.name || 'Producto sin nombre'}</h4>
                            <p class="text-muted">
                                <i class=" ri-circle-line  me-1"></i>${data.categoria || 'Sin categoría'}
                                ${data.marca ? ` | ${data.marca}` : ''}
                            </p>
                            <p>${data.description || 'Sin descripción disponible'}</p>
                            <div class="mb-3">
                                <span class="h4 text-primary">${data.price || '$0.00'}</span>
                                ${data.precio_bs ? `<br><small class="text-muted">${data.precio_bs}</small>` : ''}
                            </div>
                            <p class="text-${data.stock > 10 ? 'success' : (data.stock > 0 ? 'warning' : 'danger')}">
                                <i class=" ri-circle-line "></i>
                                ${data.stock > 10 ? 'Disponible' : (data.stock > 0 ? `Solo ${data.stock} disponibles` : 'Agotado')}
                            </p>
                            <button class="btn btn-primary w-100"
                                    onclick="addToCartQuick(${data.id})"
                                    ${data.stock <= 0 ? 'disabled' : ''}>
                                <i class=" ri-circle-line  me-2"></i>
                                ${data.stock <= 0 ? 'Agotado' : 'Añadir al carrito'}
                            </button>
                        </div>
                    </div>
                `;
            })
            .catch(error => {
                document.getElementById('quickViewContent').innerHTML = `
                    <div class="alert alert-danger">
                        Error al cargar la información del producto
                    </div>
                `;
            });
    });
});

function addToCartQuick(productId) {
    Livewire.dispatch('addCart', { productId: productId });
    bootstrap.Modal.getInstance(document.getElementById('quickViewModal')).hide();
}

// Asegurar que el carrusel siga funcionando correctamente con el modal
document.addEventListener('DOMContentLoaded', function() {
    const quickViewModal = document.getElementById('quickViewModal');
    
    // Verificar y reiniciar el carrusel si se detuvo al abrir el modal
    quickViewModal.addEventListener('show.bs.modal', function() {
        setTimeout(function() {
            if (window.relatedProductsSwiper && window.relatedProductsSwiper.autoplay && window.relatedProductsSwiper.autoplay.running === false) {
                console.log('Verificando estado del carrusel al abrir modal...');
                // No pausar, solo verificar que esté funcionando
                if (window.relatedProductsSwiper.autoplay.paused) {
                    window.relatedProductsSwiper.autoplay.resume();
                    console.log('Carrusel resumido desde estado pausado');
                }
            }
        }, 500);
    });
    
    // Asegurar que el carrusel siga funcionando cuando se cierre el modal
    quickViewModal.addEventListener('hidden.bs.modal', function() {
        // Verificar que el carrusel esté funcionando correctamente
        setTimeout(function() {
            if (window.relatedProductsSwiper && window.relatedProductsSwiper.autoplay) {
                if (window.relatedProductsSwiper.autoplay.running === false || window.relatedProductsSwiper.autoplay.paused) {
                    window.relatedProductsSwiper.autoplay.start();
                    console.log('Carrusel reiniciado después de cerrar modal');
                }
            }
        }, 300);
    });
    
    // También verificar si se hace clic en cerrar
    quickViewModal.addEventListener('click', function(e) {
        if (e.target === this || e.target.classList.contains('btn-close')) {
            setTimeout(function() {
                if (window.relatedProductsSwiper && window.relatedProductsSwiper.autoplay) {
                    if (window.relatedProductsSwiper.autoplay.running === false) {
                        window.relatedProductsSwiper.autoplay.start();
                        console.log('Carrusel verificado después de clic en cerrar');
                    }
                }
            }, 300);
        }
    });
});
</script>