<!-- Sistema de Notificaciones Unificado -->
<script src="{{ asset('js/unified-notifications.js') }}"></script>

<!-- Script para procesar mensajes flash de Laravel -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Asegurar que el contenedor de notificaciones exista
        const container = document.getElementById('toast-container');
        if (!container) {
            const newContainer = document.createElement('div');
            newContainer.id = 'toast-container';
            newContainer.className = 'toast-container';
            newContainer.style.position = 'fixed';
            newContainer.style.bottom = '20px';
            newContainer.style.right = '20px';
            newContainer.style.zIndex = '9999';
            document.body.appendChild(newContainer);
            console.log('Contenedor de notificaciones creado');
        }

        // Procesar mensajes flash de Laravel
        @if(session('success'))
            console.log('Procesando mensaje success:', '{{ session('success') }}');
            showNotification('success', '{{ session('success') }}');
        @endif

        @if(session('error'))
            console.log('Procesando mensaje error:', '{{ session('error') }}');
            showNotification('error', '{{ session('error') }}');
        @endif

        @if(session('warning'))
            console.log('Procesando mensaje warning:', '{{ session('warning') }}');
            showNotification('warning', '{{ session('warning') }}');
        @endif

        @if(session('info'))
            console.log('Procesando mensaje info:', '{{ session('info') }}');
            showNotification('info', '{{ session('info') }}');
        @endif

        @if(session('message'))
            console.log('Procesando mensaje message:', '{{ session('message') }}');
            showNotification('info', '{{ session('message') }}');
        @endif

        @if(session('danger'))
            console.log('Procesando mensaje danger:', '{{ session('danger') }}');
            showNotification('error', '{{ session('danger') }}');
        @endif

        @if(session('alert'))
            console.log('Procesando mensaje alert:', '{{ session('alert') }}');
            showNotification('warning', '{{ session('alert') }}');
        @endif

        // Procesar errores de validación
        @if($errors->any())
            @foreach($errors->all() as $error)
                console.log('Procesando error de validación:', '{{ $error }}');
                showNotification('error', '{{ $error }}');
            @endforeach
        @endif
    });
</script>