<ul class="menu-inner py-1">
  <!-- Dashboard -->
  <li class="menu-item {{ request()->routeIs('admin/dashboard') || request()->routeIs('superadmin/dashboard') ? 'active' : '' }}">
    <a href="{{ url('/') }}" class="menu-link">
       <i class="menu-icon tf-icons ri ri-home-2-line"></i>
      <div>Dashboard</div>
    </a>
  </li>
    @can('access whatsapp dashboard')
  <!-- WhatsApp Dashboard -->
  <li class="menu-item {{ request()->is('admin/whatsapp*') ? 'active' : '' }}">
    <a href="{{ route('admin.whatsapp.index') }}" class="menu-link">
      <i class="menu-icon tf-icons ri ri-whatsapp-line"></i>
      <div>WhatsApp</div>
    </a>
  </li>
  @endcan

  @can('access pedidos')
  <!-- Pedidos -->
  <li class="menu-item {{ request()->routeIs('admin.pedidos.*') ? 'active open' : '' }}">
    <a href="javascript:void(0);" class="menu-link menu-toggle">
      <i class="menu-icon tf-icons ri ri-luggage-cart-line"></i>
      <div>Pedidos</div>
    </a>
    <ul class="menu-sub">
      <li class="menu-item {{ request()->routeIs('admin.pedidos.index') ? 'active' : '' }}">
        <a href="{{ route('admin.pedidos.index') }}" class="menu-link">
          <div>Gestión</div>
        </a>
      </li>
      @can('create pedidos')
      <li class="menu-item {{ request()->routeIs('admin.pedidos.create') ? 'active' : '' }}">
        <a href="{{ route('admin.pedidos.create') }}" class="menu-link">
          <div>Crear Pedido</div>
        </a>
      </li>
      @endcan
    </ul>
  </li>
  @endcan
     @can('access pos')
      <li class="menu-item {{ request()->routeIs('admin.pos.*') ? 'active open' : '' }}">
        <a href="javascript:void(0);" class="menu-link menu-toggle">
          <i class="menu-icon tf-icons ri ri-store-2-line"></i>
          <div>Punto de Venta</div>
        </a>
        <ul class="menu-sub">
          <li class="menu-item {{ request()->routeIs('admin.pos.index') ? 'active' : '' }}">
            <a href="{{ route('admin.pos.index') }}" class="menu-link">
              <div>Terminal POS</div>
            </a>
          </li>
          @can('aprobar salidas cajas')
          <li class="menu-item {{ request()->routeIs('admin.pos.aprobaciones') ? 'active' : '' }}">
            <a href="{{ route('admin.pos.aprobaciones') }}" class="menu-link">
              <div>Aprobaciones</div>
            </a>
          </li>
          @endcan

        </ul>
      </li>
  @endcan

  @can('access ventas')
  <!-- Ventas -->
  <li class="menu-item {{ request()->routeIs('admin.ventas.*') || request()->routeIs('admin.notas-credito.*') || request()->routeIs('admin.notas-venta.*') || request()->routeIs('admin.cotizaciones.*') ? 'active open' : '' }}">
    <a href="javascript:void(0);" class="menu-link menu-toggle">
      <i class="menu-icon tf-icons ri ri-shopping-cart-line"></i>
      <div>Ventas</div>
    </a>
    <ul class="menu-sub">
      <li class="menu-item {{ request()->routeIs('admin.ventas.index') ? 'active' : '' }}">
        <a href="{{ route('admin.ventas.index') }}" class="menu-link">
          <div>Listado general</div>
        </a>
      </li>

      <li class="menu-item {{ request()->routeIs('admin.notas-credito.*') ? 'active' : '' }}">
        <a href="{{ route('admin.notas-credito.index') }}" class="menu-link">
          <div>Notas de Crédito</div>
        </a>
      </li>
      <li class="menu-item {{ request()->routeIs('admin.notas-venta.*') ? 'active' : '' }}">
        <a href="{{ route('admin.notas-venta.index') }}" class="menu-link">
          <div>Notas de Venta</div>
        </a>
      </li>
      <li class="menu-item {{ request()->routeIs('admin.cotizaciones.*') ? 'active' : '' }}">
        <a href="{{ route('admin.cotizaciones.index') }}" class="menu-link">
          <div>Cotizaciones</div>
        </a>
      </li>
    </ul>
  </li>
  @endcan



  @canany(['access categorias', 'access marcas'])
  <!-- Catálogos -->
  <li class="menu-item {{ request()->is('admin/categorias*', 'admin/marcas*', 'admin/productos*', 'admin/ofertas*') ? 'active open' : '' }}">
    <a href="javascript:void(0);" class="menu-link menu-toggle">
        <i class="menu-icon tf-icons ri ri-folder-line"></i>
        <div>Catálogos</div>
    </a>
    <ul class="menu-sub">
        @can('access categorias')
        <li class="menu-item {{ request()->is('admin/categorias*') ? 'active' : '' }}">
            <a href="{{ route('admin.categorias.index') }}" class="menu-link">
                <div>Categorías</div>
            </a>
        </li>
        @endcan

        @can('access marcas')
        <li class="menu-item {{ request()->is('admin/marcas*') ? 'active' : '' }}">
            <a href="{{ route('admin.marcas.index') }}" class="menu-link">
                <div>Marcas</div>
            </a>
        </li>
        @endcan

        @can('access productos')
        <li class="menu-item {{ request()->is('admin/productos*') ? 'active' : '' }}">
            <a href="{{ route('admin.productos.index') }}" class="menu-link">
                <div>Productos</div>
            </a>
        </li>
        @endcan


    </ul>
  </li>
  @endcanany

  @canany(['access pagos', 'access conceptos pago', 'access cajas'])
  <!-- Pagos y Finanzas -->
  <li class="menu-item {{ request()->routeIs('admin.pagos.*') || request()->routeIs('admin.conceptos-pago.*') || request()->routeIs('admin.cajas.*') ? 'active open' : '' }}">
    <a href="javascript:void(0);" class="menu-link menu-toggle">
      <i class="menu-icon tf-icons ri ri-coins-line"></i>
      <div>Pagos y Finanzas</div>
    </a>
    <ul class="menu-sub">

      @can('access cajas')
      <li class="menu-item {{ request()->routeIs('admin.cajas.index') ? 'active' : '' }}">
        <a href="{{ route('admin.cajas.index') }}" class="menu-link">
          <div>Caja Chica</div>
        </a>
      </li>
      @endcan

    </ul>
  </li>
  @endcan

  @can('access reportes')
  <!-- Reportes -->
  <li class="menu-item {{ request()->routeIs('admin.reportes.*') ? 'active open' : '' }}">
    <a href="javascript:void(0);" class="menu-link menu-toggle">
      <i class="menu-icon tf-icons ri ri-pie-chart-2-line"></i>
      <div>Reportes</div>
    </a>
    <ul class="menu-sub">

    </ul>
  </li>
  @endcan

  @canany(['access empresas', 'access paises', 'access sucursales', 'access school periods', 'access niveles educativos', 'access turnos'])
  <!-- Configuración Institucional -->
  <li class="menu-item {{ request()->routeIs('admin.empresas.*') || request()->routeIs('admin.paises.*') || request()->routeIs('admin.sucursales.*') || request()->routeIs('admin.school-periods.*') || request()->routeIs('admin.niveles-educativos.*') || request()->routeIs('admin.turnos.*') ? 'active open' : '' }}">
    <a href="javascript:void(0);" class="menu-link menu-toggle">
      <i class="menu-icon tf-icons ri ri-building-line"></i>
      <div>Configuración</div>
    </a>
    <ul class="menu-sub">
      @can('access empresas')
      <li class="menu-item {{ request()->routeIs('admin.empresas.index') ? 'active' : '' }}">
        <a href="{{ route('admin.empresas.index') }}" class="menu-link">
          <div>Empresas</div>
        </a>
      </li>
      @endcan
      @can('access paises')
      <li class="menu-item {{ request()->routeIs('admin.paises.index') ? 'active' : '' }}">
        <a href="{{ route('admin.paises.index') }}" class="menu-link">
          <div>Países</div>
        </a>
      </li>
      @endcan
      @can('access sucursales')
      <li class="menu-item {{ request()->routeIs('admin.sucursales.index') ? 'active' : '' }}">
        <a href="{{ route('admin.sucursales.index') }}" class="menu-link">
          <div>Sucursales</div>
        </a>
      </li>
      @endcan

    </ul>
  </li>
  @endcan

  @can('access series')
  <!-- Series de Documentos -->
  <li class="menu-item {{ request()->routeIs('admin.series.*') ? 'active' : '' }}">
    <a href="{{ route('admin.series.index') }}" class="menu-link">
      <i class="menu-icon tf-icons ri ri-file-text-line"></i>
      <div>Series</div>
    </a>
  </li>
  @endcan

  @can('view exchange-rates')
    @php
        $regionalConfig = app(\App\Services\RegionalConfigurationService::class)->getCurrentConfiguration();
    @endphp
    {{-- Mostrar opción de tasas solo si el país es Venezuela (VES) --}}
    @if(($regionalConfig['currency'] ?? 'USD') === 'VES' || ($regionalConfig['dual_currency'] ?? false))
    <!-- Tasas de Cambio -->
    <li class="menu-item {{ request()->routeIs('admin.exchange-rates') ? 'active' : '' }}">
      <a href="{{ route('admin.exchange-rates') }}" class="menu-link">
        <i class="menu-icon tf-icons ri ri-exchange-funds-line"></i>
        <div>Tasas BCV</div>
      </a>
    </li>
    @endif
  @endcan

  <!-- Personalización de Plantilla -->
  <li class="menu-item {{ request()->routeIs('admin.template-customization') ? 'active' : '' }}">
    <a href="{{ route('admin.template-customization') }}" class="menu-link">
      <i class="menu-icon tf-icons ri ri-palette"></i>
      <div>Personalización</div>
    </a>
  </li>

  @can('access empleados')
  <!-- Empleados -->
  <li class="menu-item {{ request()->routeIs('admin.empleados.*') ? 'active' : '' }}">
    <a href="{{ route('admin.empleados.index') }}" class="menu-link">
      <i class="menu-icon tf-icons ri ri-user-line"></i>
      <div>Empleados</div>
    </a>
  </li>
  @endcan


  @canany(['access users', 'access roles', 'access permissions'])
  <!-- Usuarios y Permisos -->
  <li class="menu-item {{ request()->routeIs('admin.users.*') || request()->routeIs('admin.roles.*') || request()->routeIs('admin.permissions.*') ? 'active open' : '' }}">
    <a href="javascript:void(0);" class="menu-link menu-toggle">
      <i class="menu-icon tf-icons ri ri-account-box-line"></i>
      <div>Administración</div>
    </a>
    <ul class="menu-sub">
      @can('access users')
      <li class="menu-item {{ request()->routeIs('admin.users.index') ? 'active' : '' }}">
        <a href="{{ route('admin.users.index') }}" class="menu-link">
          <div>Usuarios</div>
        </a>
      </li>
      @endcan
      @can('access roles')
      <li class="menu-item {{ request()->routeIs('admin.roles.index') ? 'active' : '' }}">
        <a href="{{ route('admin.roles.index') }}" class="menu-link">
          <div>Roles</div>
        </a>
      </li>
      @endcan
      @can('access permissions')
      <li class="menu-item {{ request()->routeIs('admin.permissions.index') ? 'active' : '' }}">
        <a href="{{ route('admin.permissions.index') }}" class="menu-link">
          <div>Permisos</div>
        </a>
      </li>
      @endcan
    </ul>
  </li>
  @endcan

  @canany(['view active sessions', 'access activity log', 'access monitoreo'])
  <!-- Sistema y Monitoreo -->
  <li class="menu-item {{ request()->routeIs('admin.active-sessions*') || request()->is('admin/activity-log*') || request()->routeIs('admin.monitoreo.*') ? 'active open' : '' }}">
    <a href="javascript:void(0);" class="menu-link menu-toggle">
      <i class="menu-icon tf-icons ri ri-dashboard-3-line"></i>
      <div>Monitoreo</div>
    </a>
    <ul class="menu-sub">
      @can('view active sessions')
      <li class="menu-item {{ request()->routeIs('admin.active-sessions*') ? 'active' : '' }}">
        <a href="{{ route('admin.active-sessions.index') }}" class="menu-link">
          <div>Sesiones</div>
        </a>
      </li>
      @endcan
      @can('access activity log')
      <li class="menu-item {{ request()->is('admin/activity-log*') ? 'active' : '' }}">
        <a href="{{ route('admin.activity-log') }}" class="menu-link">
          <div>Actividad</div>
        </a>
      </li>
      @endcan
      @can('access database backup')
      <li class="menu-item {{ request()->routeIs('admin.monitoreo.database-backup') ? 'active' : '' }}">
        <a href="{{ route('admin.monitoreo.database-backup') }}" class="menu-link">
          <div>Respaldo BD</div>
        </a>
      </li>
      @endcan
      @can('access database import')
      <li class="menu-item {{ request()->routeIs('admin.monitoreo.database-import') ? 'active' : '' }}">
        <a href="{{ route('admin.monitoreo.database-import') }}" class="menu-link">
          <div>Importar BD</div>
        </a>
      </li>
      @endcan
    </ul>
  </li>
  @endcan


</ul>
