<!DOCTYPE html>
<html
  lang="{{ str_replace('_', '-', app()->getLocale()) }}"
  class="layout-navbar-fixed layout-menu-fixed{{ isset($templateSettings) && $templateSettings->menu_collapsed ? ' layout-menu-collapsed' : '' }}{{ isset($templateSettings) ? ($templateSettings->content_layout === 'wide' ? ' layout-wide' : ' layout-compact') : ' layout-compact' }}{{ isset($templateSettings) && $templateSettings->footer_fixed ? ' layout-footer-fixed' : '' }}"
  dir="{{ isset($templateSettings) ? $templateSettings->text_direction : 'ltr' }}"
  data-skin="{{ isset($templateSettings) ? ($templateSettings->skin == 1 ? 'bordered' : 'default') : 'default' }}"
  data-bs-theme="{{ isset($templateSettings) ? $templateSettings->theme : 'light' }}"
  data-assets-path="{{ asset('materialize/assets/') }}/"
  data-template="{{ isset($templateSettings) && $templateSettings->layout_type === 'horizontal' ? 'horizontal-menu-template' : 'vertical-menu-template' }}">
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>{{ $title ?? config('app.name') }}</title>
    <meta name="description" content="{{ config('app.name') }} - {{ config('app.description') }}" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('materialize/assets/img/favicon/favicon.ico') }}" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
      rel="stylesheet" />

    <!-- Remix Icons -->
    <link href="https://cdn.jsdelivr.net/npm/remixicon@4.7.0/fonts/remixicon.css" rel="stylesheet">

    <link rel="stylesheet" href="/materialize/assets/vendor/fonts/iconify-icons.css" />
    <link rel="stylesheet" href="/materialize/assets/vendor/fonts/themify-icons.css" />
    <link rel="stylesheet" href="/materialize/assets/vendor/fonts/materialdesignicons.css" />

    <!-- Core CSS -->
    <!-- build:css assets/vendor/css/theme.css -->

    <link rel="stylesheet" href="/materialize/assets/vendor/libs/node-waves/node-waves.css" />

    <script src="/materialize/assets/vendor/libs/@algolia/autocomplete-js.js"></script>

    <link rel="stylesheet" href="/materialize/assets/vendor/libs/pickr/pickr-themes.css" />

    <link rel="stylesheet" href="/materialize/assets/vendor/css/core.css" />
    <link rel="stylesheet" href="/materialize/assets/css/demo.css" />

    <!-- Vendors CSS -->

    <link rel="stylesheet" href="/materialize/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />

    <!-- endbuild -->

    <link rel="stylesheet" href="/materialize/assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="/materialize/assets/vendor/libs/swiper/swiper.css" />

    <!-- Page CSS -->
    <link rel="stylesheet" href="/materialize/assets/vendor/css/pages/cards-statistics.css" />

    <!-- Helpers -->
    <script src="/materialize/assets/vendor/js/helpers.js"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->

    <!--? Template customizer: To hide customizer set displayCustomizer value false in config.js. -->
    <script src="/materialize/assets/vendor/js/template-customizer.js"></script>

    <!--? Config: Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file. -->

    <script src="/materialize/assets/js/config.js"></script>

    @include('components.template-config')

     <!-- Cropper.js CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.12/cropper.min.css">

    <!-- Chat y Biblioteca CSS -->
    <link rel="stylesheet" href="{{ asset('css/chat-biblioteca.css') }}">

    @if(isset($templateSettings) && $templateSettings->primary_color)
    <style>
      :root {
        --bs-primary: {{ $templateSettings->primary_color }};
        --bs-primary-rgb: {{ implode(',', sscanf($templateSettings->primary_color, '#%02x%02x%02x')) }};
      }
    </style>
    @endif

  <style>
    .photo-preview-card {
      transition: transform 0.2s;
    }

    .photo-preview-card:hover {
      transform: scale(1.02);
    }

    .camera-feed {
      background: #000;
      border-radius: 0.5rem;
    }

    .capture-btn {
      box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    }

    /* Estilos para breadcrumbs */
    .breadcrumb-style {
      background-color: transparent;
      padding: 0.75rem 1rem;
      margin-bottom: 1rem;
      border-radius: 0.375rem;
      font-size: 0.875rem;
    }

    .breadcrumb-style .breadcrumb-item + .breadcrumb-item::before {
      content: ">";
      color: #6c757d;
    }

    .breadcrumb-style .breadcrumb-item a {
      color: #007bff;
      text-decoration: none;
    }

    .breadcrumb-style .breadcrumb-item a:hover {
      text-decoration: underline;
    }

    .breadcrumb-style .breadcrumb-item.active {
      color: #495057;
    }

    /* Mejoras de accesibilidad */
    .sr-only {
      position: absolute;
      width: 1px;
      height: 1px;
      padding: 0;
      margin: -1px;
      overflow: hidden;
      clip: rect(0, 0, 0, 0);
      white-space: nowrap;
      border-width: 0;
    }

    /* Estilos para notificaciones */
    .notification-badge {
      position: absolute;
      top: 0;
      right: 0;
      transform: translate(50%, -50%);
      padding: 0.25em 0.5em;
      font-size: 0.75em;
      border-radius: 50%;
      min-width: 1.5em;
      min-height: 1.5em;
      display: flex;
      align-items: center;
      justify-content: center;
      font-weight: bold;
    }

    /* Eliminar overlays problemáticos */
    .modal-backdrop,
    .offcanvas-backdrop,
    .tooltip,
    .popover,
    .dropdown-backdrop {
      display: none !important;
      opacity: 0 !important;
      visibility: hidden !important;
    }

    /* Asegurar que no haya z-index problemáticos */
    .layout-overlay {
      z-index: -1 !important;
    }

    /* Responsive improvements */
    @media (max-width: 768px) {
      .breadcrumb-style {
        padding: 0.5rem 0.75rem;
        font-size: 0.75rem;
      }

      .container-fluid {
        padding-left: 1rem;
        padding-right: 1rem;
      }
    }
  </style>

    <!-- Livewire Styles -->
    @livewireStyles

    @stack('styles')

    <!-- Custom Icon Sizes -->
    <style>
      /* Tamaño estándar para iconos con  */
      . {
        font-size: 26px !important;
      }

      /* Tamaño específico para iconos del menú */
      .layout-menu .menu-item .menu-link .menu-icon,
      .layout-menu .menu-item .menu-link i[class*="ri-"] {
        font-size: 18px !important;
      }

      /* Tamaño para menú horizontal */
      .layout-navbar .navbar-nav .nav-item .nav-link i[class*="ri-"] {
        font-size: 18px !important;
      }
    </style>
  </head>

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->
        @include('components.partials.menu')

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->
          @include('components.partials.navbar')

          <!-- Content wrapper -->
          <div class="content-wrapper">

            <!-- Content -->
            <div class="container-fluid flex-grow-1 container-p-y">

              {{ $slot }}
            </div>
            <!-- /Content -->

            <!-- Footer -->
            @include('components.partials.footer')

            <!-- <div class="content-backdrop fade"></div> -->
          </div>
          <!-- /Content wrapper -->
        </div>
        <!-- /Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>

      <!-- Drag Target Area To SlideIn Menu On Small Screens -->
      <div class="drag-target"></div>
    </div>
    <!-- /Layout wrapper -->

    <!-- Contenedor de notificaciones -->
    <div id="notification-container"></div>

    <!-- Core JS -->
     <script src="/materialize/assets/vendor/libs/jquery/jquery.js"></script>

    <script src="/materialize/assets/vendor/libs/popper/popper.js"></script>
    <script src="/materialize/assets/vendor/js/bootstrap.js"></script>
    <script src="/materialize/assets/vendor/libs/node-waves/node-waves.js"></script>

    <script src="/materialize/assets/vendor/libs/@algolia/autocomplete-js.js"></script>

    <script src="/materialize/assets/vendor/libs/pickr/pickr.js"></script>

    <script src="/materialize/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>

    <script src="/materialize/assets/vendor/libs/hammer/hammer.js"></script>

    <script src="/materialize/assets/vendor/libs/i18n/i18n.js"></script>

    <script src="/materialize/assets/vendor/js/menu.js"></script>

    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="/materialize/assets/vendor/libs/apex-charts/apexcharts.js"></script>
    <script src="/materialize/assets/vendor/libs/swiper/swiper.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <!-- Main JS -->
    <script src="/materialize/assets/js/main.js"></script>

    <!-- Livewire Scripts -->
    @livewireScripts

    <!-- Script para eliminar overlays problemáticos -->
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Eliminar cualquier backdrop o overlay problemático
        function removeProblematicOverlays() {
            const overlays = document.querySelectorAll('.modal-backdrop, .offcanvas-backdrop, .content-backdrop, .fade.show');
            overlays.forEach(overlay => {
                if (overlay.style.backgroundColor === 'rgba(0, 0, 0, 0.5)' || overlay.classList.contains('show')) {
                    overlay.remove();
                }
            });
        }

        // Ejecutar inmediatamente
        removeProblematicOverlays();

        // Ejecutar cada segundo para asegurar que no aparezcan overlays
        setInterval(removeProblematicOverlays, 1000);
    });
    </script>


   <!-- Cropper.js JS -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.12/cropper.min.js"></script>

  <!-- Chart.js -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>

    <!-- Script para manejar notificaciones -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Función para mostrar notificaciones
            function showNotification(type, message) {
                const iconMap = {
                    'success': 'success',
                    'error': 'error',
                    'warning': 'warning',
                    'info': 'info'
                };
                
                Swal.fire({
                    icon: iconMap[type] || 'info',
                    title: message,
                    showConfirmButton: false,
                    timer: 2000,
                    timerProgressBar: true
                });
            }

            // Listener para eventos show-toast de Livewire
            window.addEventListener('show-toast', event => {
                const detail = event.detail;
                showNotification(detail.type || detail[0]?.type, detail.message || detail[0]?.message);
            });

            // Procesar mensajes flash de Laravel
            @if(session('success'))
                showNotification('success', '{{ session('success') }}');
            @endif

            @if(session('error'))
                showNotification('error', '{{ session('error') }}');
            @endif

            @if(session('warning'))
                showNotification('warning', '{{ session('warning') }}');
            @endif

            @if(session('info'))
                showNotification('info', '{{ session('info') }}');
            @endif

            @if(session('message'))
                showNotification('info', '{{ session('message') }}');
            @endif

            @if(session('danger'))
                showNotification('error', '{{ session('danger') }}');
            @endif

            @if(session('alert'))
                showNotification('warning', '{{ session('alert') }}');
            @endif

            // Procesar errores de validación
            @if($errors->any())
                @foreach($errors->all() as $error)
                    showNotification('error', '{{ $error }}');
                @endforeach
            @endif
        });
    </script>

    @stack('scripts')

    <!-- Accessibility improvements -->
    <script>
      // Mejorar la navegación por teclado
      document.addEventListener('DOMContentLoaded', function() {
        // Añadir skip links para usuarios de teclado
        const skipLink = document.createElement('a');
        skipLink.href = '#main-content';
        skipLink.className = 'sr-only sr-only-focusable';
        skipLink.textContent = 'Saltar al contenido principal';
        skipLink.style.cssText = `
          position: absolute;
          top: 10px;
          left: 10px;
          background: #000;
          color: #fff;
          padding: 10px;
          z-index: 10000;
        `;

        skipLink.addEventListener('focus', function() {
          this.style.top = '10px';
        });

        skipLink.addEventListener('blur', function() {
          this.style.top = '-40px';
        });

        document.body.insertBefore(skipLink, document.body.firstChild);

        // Asegurar que todos los elementos interactivos tengan focus visible
        const focusableElements = document.querySelectorAll('a, button, input, select, textarea, [tabindex]:not([tabindex="-1"])');
        focusableElements.forEach(element => {
          if (!element.hasAttribute('aria-label') && !element.hasAttribute('aria-labelledby') && element.title) {
            element.setAttribute('aria-label', element.title);
          }
        });
      });
    </script>
  </body>
</html>
