@props(['amount', 'showBoth' => true, 'class' => '', 'currency' => 'USD'])

@php
    $isVenezuela = is_venezuela_company();
    $rate = $isVenezuela ? \App\Models\ExchangeRate::getLatestRate('USD') : null;
    $amountValue = is_numeric($amount) ? (float) $amount : 0;
    $config = get_regional_config();
    $currencySymbol = $config['currency_symbol'] ?? '$';
    $decimalSep = $config['decimal_separator'] ?? '.';
    $thousandSep = $config['thousand_separator'] ?? ',';
    $decimals = $config['decimals'] ?? 2;
@endphp

<span class="{{ $class }}">
    {{-- Aplicar configuración regional para mostrar la moneda correcta --}}
    <span class="text-success fw-bold">{{ $currencySymbol }}{{ number_format($amountValue, $decimals, $decimalSep, $thousandSep) }}</span>
</span>
