<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "🔑 Generando token JWT simple...\n\n";

try {
    // Obtener usuario
    $user = App\Models\User::first();
    
    if (!$user) {
        echo "❌ No se encontró ningún usuario\n";
        exit(1);
    }

    // Generar token usando JWTAuth
    $token = \Tymon\JWTAuth\Facades\JWTAuth::fromUser($user);
    
    echo "✅ Token generado exitosamente\n";
    echo "Usuario: {$user->name} (ID: {$user->id})\n";
    echo "Token: {$token}\n\n";
    
    // Actualizar archivo de configuración
    $configFile = 'whatsapp-service-config.env';
    if (file_exists($configFile)) {
        $content = file_get_contents($configFile);
        $content = preg_replace('/LARAVEL_API_KEY=.*/', "LARAVEL_API_KEY={$token}", $content);
        file_put_contents($configFile, $content);
        echo "✅ Actualizado: {$configFile}\n";
    }
    
    echo "\n🚀 Token JWT configurado correctamente\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}