<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "🔑 Generando nuevo token JWT...\n\n";

try {
    // Obtener el primer usuario admin
    $user = App\Models\User::whereHas('roles', function($query) {
        $query->whereIn('name', ['SuperAdmin', 'Administrador']);
    })->first();

    if (!$user) {
        $user = App\Models\User::first();
    }

    if (!$user) {
        echo "❌ No se encontró ningún usuario\n";
        exit(1);
    }

    // Generar token JWT
    $token = auth()->login($user);
    
    echo "✅ Token generado exitosamente\n";
    echo "Usuario: {$user->name} (ID: {$user->id})\n";
    echo "Token: {$token}\n\n";
    
    // Actualizar archivos de configuración
    $files = [
        'whatsapp-service-config.env',
        'resources/js/whatsapp/.env'
    ];
    
    foreach ($files as $file) {
        if (file_exists($file)) {
            $content = file_get_contents($file);
            $content = preg_replace('/LARAVEL_API_KEY=.*/', "LARAVEL_API_KEY={$token}", $content);
            file_put_contents($file, $content);
            echo "✅ Actualizado: {$file}\n";
        }
    }
    
    echo "\n🚀 Configuración actualizada. Reinicia el servidor Node.js:\n";
    echo "cd resources/js/whatsapp && npm start\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}