<?php

namespace Database\Seeders;

use App\Models\Empresa;
use App\Models\WhatsAppSession;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Http;

class WhatsAppTestSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->command->info('Creando empresas de prueba para WhatsApp...');

        // Crear empresas de prueba si no existen
        $empresas = [
            [
                'razon_social' => 'Empresa de Prueba 1 S.A.',
                'documento' => 'EMP001',
                'direccion' => 'Av. Principal 123',
                'email' => 'contacto1@empresa.com',
            ],
            [
                'razon_social' => 'Empresa de Prueba 2 S.A.',
                'documento' => 'EMP002',
                'direccion' => 'Calle Secundaria 456',
                'email' => 'contacto2@empresa.com',
            ],
            [
                'razon_social' => 'Empresa de Prueba 3 S.A.',
                'documento' => 'EMP003',
                'direccion' => 'Plaza Central 789',
                'email' => 'contacto3@empresa.com',
            ],
        ];

        foreach ($empresas as $empresaData) {
            $empresa = Empresa::firstOrCreate(
                ['documento' => $empresaData['documento']],
                $empresaData
            );
            $this->command->info("Empresa creada/actualizada: {$empresa->razon_social} ({$empresa->documento})");
        }

        $this->command->info('Empresas de prueba creadas exitosamente!');
        $this->command->info('Ahora puedes crear sesiones WhatsApp para estas empresas en el panel de administración.');
        $this->command->info('Accede a: /admin/whatsapp-multi-sessions');
    }
}
