<?php

namespace Database\Seeders;

use App\Models\TemplateCustomization;
use Illuminate\Database\Seeder;

class TemplateCustomizationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Crear configuración por defecto si no existe
        TemplateCustomization::firstOrCreate([], [
            'primary_color' => '#7367F0',
            'skin' => 0,
            'theme' => 'light',
            'semi_dark' => true,
            'content_layout' => 'compact',
            'header_type' => 'static',
            'menu_collapsed' => false,
            'navbar_type' => 'sticky',
            'text_direction' => 'ltr',
            'footer_fixed' => false,
            'dropdown_on_hover' => false,
            'layout_type' => 'horizontal'
        ]);
    }
}
