<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Producto;
use App\Models\Marca;
use App\Models\Categoria;

class SantoniSeeder extends Seeder
{
    public function run(): void
    {
        $marca = Marca::where('nombre', 'Santoni')->first();
        $categoria = Categoria::where('nombre', 'Helados')->first();

        $productos = [
            ['nombre' => 'Santoni Vainilla 1L', 'precio' => 8.50],
            ['nombre' => 'Santoni Chocolate 1L', 'precio' => 8.50],
            ['nombre' => 'Santoni Fresa 1L', 'precio' => 8.50],
            ['nombre' => 'Santoni Cookies & Cream 1L', 'precio' => 9.00],
            ['nombre' => 'Santoni Dulce de Leche 1L', 'precio' => 9.00],
            ['nombre' => 'Santoni Napolitano 1L', 'precio' => 8.75],
            ['nombre' => 'Santoni Limón 1L', 'precio' => 8.25],
            ['nombre' => 'Santoni Coco 1L', 'precio' => 8.75],
        ];

        foreach ($productos as $producto) {
            Producto::create([
                'nombre' => $producto['nombre'],
                'precio' => $producto['precio'],
                'marca_id' => $marca->id,
                'categoria_id' => $categoria->id,
                'activo' => true,
            ]);
        }
    }
}