<?php

namespace Database\Seeders;

use App\Models\Categoria;
use App\Models\Marca;
use App\Models\Producto;
use App\Models\ProductoVariant;
use App\Models\Empresa;
use App\Models\Sucursal;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class PringlesSeeder extends Seeder
{
    public function run(): void
    {
        $empresa = Empresa::first();
        $sucursal = Sucursal::where('empresa_id', $empresa->id)->first();
        
        $categoria = Categoria::firstOrCreate(
            ['nombre' => 'Confitería', 'empresa_id' => $empresa->id],
            [
                'slug' => Str::slug('Confitería'),
                'descripcion' => 'Productos de confitería',
                'activo' => true,
                'sucursal_id' => $sucursal->id,
            ]
        );

        $marca = Marca::firstOrCreate(
            ['nombre' => 'Pringles', 'empresa_id' => $empresa->id],
            [
                'slug' => Str::slug('Pringles'),
                'descripcion' => 'Productos Pringles',
                'activo' => true,
                'sucursal_id' => $sucursal->id,
            ]
        );

        $productos = [
            ['nombre' => 'Pringles Original', 'descripcion' => 'Papas fritas sabor original', 'precio_base' => 2.50, 'variantes' => [['nombre' => 'Peso: 110g', 'values' => ['Peso' => '110g'], 'sku' => 'PRI-ORI-110', 'precio_ajuste' => 0, 'cantidad' => 100], ['nombre' => 'Peso: 158g', 'values' => ['Peso' => '158g'], 'sku' => 'PRI-ORI-158', 'precio_ajuste' => 1.20, 'cantidad' => 80]]],
            ['nombre' => 'Pringles Crema y Cebolla', 'descripcion' => 'Papas fritas sabor crema y cebolla', 'precio_base' => 2.50, 'variantes' => [['nombre' => 'Peso: 110g', 'values' => ['Peso' => '110g'], 'sku' => 'PRI-CYC-110', 'precio_ajuste' => 0, 'cantidad' => 100], ['nombre' => 'Peso: 158g', 'values' => ['Peso' => '158g'], 'sku' => 'PRI-CYC-158', 'precio_ajuste' => 1.20, 'cantidad' => 80]]],
            ['nombre' => 'Pringles Queso Cheddar', 'descripcion' => 'Papas fritas sabor queso cheddar', 'precio_base' => 2.50, 'variantes' => [['nombre' => 'Peso: 110g', 'values' => ['Peso' => '110g'], 'sku' => 'PRI-QUE-110', 'precio_ajuste' => 0, 'cantidad' => 100], ['nombre' => 'Peso: 158g', 'values' => ['Peso' => '158g'], 'sku' => 'PRI-QUE-158', 'precio_ajuste' => 1.20, 'cantidad' => 80]]],
            ['nombre' => 'Pringles Barbacoa BBQ', 'descripcion' => 'Papas fritas sabor barbacoa BBQ', 'precio_base' => 2.50, 'variantes' => [['nombre' => 'Peso: 110g', 'values' => ['Peso' => '110g'], 'sku' => 'PRI-BBQ-110', 'precio_ajuste' => 0, 'cantidad' => 100], ['nombre' => 'Peso: 158g', 'values' => ['Peso' => '158g'], 'sku' => 'PRI-BBQ-158', 'precio_ajuste' => 1.20, 'cantidad' => 80]]],
            ['nombre' => 'Pringles Ranch', 'descripcion' => 'Papas fritas sabor ranch', 'precio_base' => 2.50, 'variantes' => [['nombre' => 'Peso: 110g', 'values' => ['Peso' => '110g'], 'sku' => 'PRI-RAN-110', 'precio_ajuste' => 0, 'cantidad' => 100], ['nombre' => 'Peso: 158g', 'values' => ['Peso' => '158g'], 'sku' => 'PRI-RAN-158', 'precio_ajuste' => 1.20, 'cantidad' => 80]]],
            ['nombre' => 'Pringles Pizza', 'descripcion' => 'Papas fritas sabor pizza', 'precio_base' => 2.50, 'variantes' => [['nombre' => 'Peso: 110g', 'values' => ['Peso' => '110g'], 'sku' => 'PRI-PIZ-110', 'precio_ajuste' => 0, 'cantidad' => 100], ['nombre' => 'Peso: 158g', 'values' => ['Peso' => '158g'], 'sku' => 'PRI-PIZ-158', 'precio_ajuste' => 1.20, 'cantidad' => 80]]],
            ['nombre' => 'Pringles Enchilada', 'descripcion' => 'Papas fritas sabor enchilada', 'precio_base' => 2.70, 'variantes' => [['nombre' => 'Peso: 124g', 'values' => ['Peso' => '124g'], 'sku' => 'PRI-ENC-124', 'precio_ajuste' => 0, 'cantidad' => 100]]],
            ['nombre' => 'Pringles Habanero', 'descripcion' => 'Papas fritas sabor habanero', 'precio_base' => 2.70, 'variantes' => [['nombre' => 'Peso: 124g', 'values' => ['Peso' => '124g'], 'sku' => 'PRI-HAB-124', 'precio_ajuste' => 0, 'cantidad' => 100]]],
        ];

        foreach ($productos as $productoData) {
            $producto = Producto::create([
                'code' => strtoupper(substr(Str::slug($productoData['nombre']), 0, 3)) . '-' . rand(10000, 99999),
                'name' => $productoData['nombre'],
                'price' => $productoData['precio_base'],
                'precio_bs' => $productoData['precio_base'] * 35,
                'description' => $productoData['descripcion'],
                'quantity' => array_sum(array_column($productoData['variantes'], 'cantidad')),
                'quantity_alert' => 10,
                'status' => true,
                'empresa_id' => $empresa->id,
                'categoria_id' => $categoria->id,
                'marca_id' => $marca->id,
            ]);

            foreach ($productoData['variantes'] as $varianteData) {
                ProductoVariant::create([
                    'producto_id' => $producto->id,
                    'name' => $varianteData['nombre'],
                    'values' => $varianteData['values'],
                    'sku' => $varianteData['sku'],
                    'price_adjustment' => $varianteData['precio_ajuste'],
                    'quantity' => $varianteData['cantidad'],
                    'image_path' => null,
                    'image_thumbnail_path' => null,
                    'alt_text' => $varianteData['nombre'] . ' - ' . $productoData['nombre'],
                    'empresa_id' => $empresa->id,
                ]);
            }
        }

        $this->command->info('Pringles: 8 productos creados con 14 variantes');
    }
}