<?php

namespace Database\Seeders;

use App\Models\Categoria;
use App\Models\Marca;
use App\Models\Producto;
use App\Models\ProductoVariant;
use App\Models\Empresa;
use App\Models\Sucursal;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class NutribelaSeeder extends Seeder
{
    public function run(): void
    {
        $empresa = Empresa::first();
        $sucursal = Sucursal::where('empresa_id', $empresa->id)->first();
        
        $categoria = Categoria::firstOrCreate(
            ['nombre' => 'Higiene Personal', 'empresa_id' => $empresa->id],
            [
                'slug' => Str::slug('Higiene Personal'),
                'descripcion' => 'Productos de cuidado e higiene personal',
                'activo' => true,
                'sucursal_id' => $sucursal->id,
            ]
        );

        $marca = Marca::firstOrCreate(
            ['nombre' => 'Nutribela', 'empresa_id' => $empresa->id],
            [
                'slug' => Str::slug('Nutribela'),
                'descripcion' => 'Productos Nutribela',
                'activo' => true,
                'sucursal_id' => $sucursal->id,
            ]
        );

        $productos = [
            ['nombre' => 'Nutribela Biokeratina', 'descripcion' => 'Tratamiento capilar Biokeratina 300ml', 'precio_base' => 18.40, 'variantes' => [['nombre' => 'Presentación: 300ml', 'values' => ['Presentación' => '300ml'], 'sku' => 'NUT-BIO-300', 'precio_ajuste' => 0, 'cantidad' => 50], ['nombre' => 'Presentación: 12 sobres', 'values' => ['Presentación' => '12 sobres'], 'sku' => 'NUT-BIO-SOB', 'precio_ajuste' => -1.90, 'cantidad' => 100]]],
            ['nombre' => 'Nutribela Enzimoterapia', 'descripcion' => 'Tratamiento capilar Enzimoterapia 300ml', 'precio_base' => 18.40, 'variantes' => [['nombre' => 'Presentación: 300ml', 'values' => ['Presentación' => '300ml'], 'sku' => 'NUT-ENZ-300', 'precio_ajuste' => 0, 'cantidad' => 50], ['nombre' => 'Presentación: 12 sobres', 'values' => ['Presentación' => '12 sobres'], 'sku' => 'NUT-ENZ-SOB', 'precio_ajuste' => -1.90, 'cantidad' => 100]]],
            ['nombre' => 'Nutribela Células Madres', 'descripcion' => 'Tratamiento capilar Células Madres 300ml', 'precio_base' => 18.40, 'variantes' => [['nombre' => 'Presentación: 300ml', 'values' => ['Presentación' => '300ml'], 'sku' => 'NUT-CEL-300', 'precio_ajuste' => 0, 'cantidad' => 50], ['nombre' => 'Presentación: 12 sobres', 'values' => ['Presentación' => '12 sobres'], 'sku' => 'NUT-CEL-SOB', 'precio_ajuste' => -1.90, 'cantidad' => 100]]],
            ['nombre' => 'Nutribela Pro Hialurónico', 'descripcion' => 'Tratamiento capilar Pro Hialurónico 300ml', 'precio_base' => 18.40, 'variantes' => [['nombre' => 'Presentación: 300ml', 'values' => ['Presentación' => '300ml'], 'sku' => 'NUT-HIA-300', 'precio_ajuste' => 0, 'cantidad' => 50], ['nombre' => 'Presentación: 12 sobres', 'values' => ['Presentación' => '12 sobres'], 'sku' => 'NUT-HIA-SOB', 'precio_ajuste' => -1.90, 'cantidad' => 100]]],
            ['nombre' => 'Nutribela Termoprotección', 'descripcion' => 'Tratamiento capilar Termoprotección 300ml', 'precio_base' => 18.40, 'variantes' => [['nombre' => 'Presentación: 300ml', 'values' => ['Presentación' => '300ml'], 'sku' => 'NUT-TER-300', 'precio_ajuste' => 0, 'cantidad' => 50], ['nombre' => 'Presentación: 12 sobres', 'values' => ['Presentación' => '12 sobres'], 'sku' => 'NUT-TER-SOB', 'precio_ajuste' => -1.90, 'cantidad' => 100]]],
            ['nombre' => 'Nutribela Reparación Intensiva', 'descripcion' => 'Tratamiento capilar Reparación Intensiva 300ml', 'precio_base' => 18.40, 'variantes' => [['nombre' => 'Presentación: 300ml', 'values' => ['Presentación' => '300ml'], 'sku' => 'NUT-REP-300', 'precio_ajuste' => 0, 'cantidad' => 50], ['nombre' => 'Presentación: 12 sobres', 'values' => ['Presentación' => '12 sobres'], 'sku' => 'NUT-REP-SOB', 'precio_ajuste' => -1.90, 'cantidad' => 100]]],
            ['nombre' => 'Nutribela Nutrición Avanzada', 'descripcion' => 'Tratamiento capilar Nutrición Avanzada 300ml', 'precio_base' => 18.40, 'variantes' => [['nombre' => 'Presentación: 300ml', 'values' => ['Presentación' => '300ml'], 'sku' => 'NUT-NUT-300', 'precio_ajuste' => 0, 'cantidad' => 50], ['nombre' => 'Presentación: 12 sobres', 'values' => ['Presentación' => '12 sobres'], 'sku' => 'NUT-NUT-SOB', 'precio_ajuste' => -1.90, 'cantidad' => 100]]],
            ['nombre' => 'Nutribela Repolarización en Frío', 'descripcion' => 'Tratamiento capilar Repolarización en Frío 300ml', 'precio_base' => 18.40, 'variantes' => [['nombre' => 'Presentación: 300ml', 'values' => ['Presentación' => '300ml'], 'sku' => 'NUT-REF-300', 'precio_ajuste' => 0, 'cantidad' => 50], ['nombre' => 'Presentación: 12 sobres', 'values' => ['Presentación' => '12 sobres'], 'sku' => 'NUT-REF-SOB', 'precio_ajuste' => -1.90, 'cantidad' => 100]]],
        ];

        foreach ($productos as $productoData) {
            $producto = Producto::create([
                'code' => strtoupper(substr(Str::slug($productoData['nombre']), 0, 3)) . '-' . rand(10000, 99999),
                'name' => $productoData['nombre'],
                'price' => $productoData['precio_base'],
                'precio_bs' => $productoData['precio_base'] * 35,
                'description' => $productoData['descripcion'],
                'quantity' => array_sum(array_column($productoData['variantes'], 'cantidad')),
                'quantity_alert' => 10,
                'status' => true,
                'empresa_id' => $empresa->id,
                'categoria_id' => $categoria->id,
                'marca_id' => $marca->id,
            ]);

            foreach ($productoData['variantes'] as $varianteData) {
                ProductoVariant::create([
                    'producto_id' => $producto->id,
                    'name' => $varianteData['nombre'],
                    'values' => $varianteData['values'],
                    'sku' => $varianteData['sku'],
                    'price_adjustment' => $varianteData['precio_ajuste'],
                    'quantity' => $varianteData['cantidad'],
                    'image_path' => null,
                    'image_thumbnail_path' => null,
                    'alt_text' => $varianteData['nombre'] . ' - ' . $productoData['nombre'],
                    'empresa_id' => $empresa->id,
                ]);
            }
        }

        $this->command->info('Nutribela: 8 productos creados con 16 variantes');
    }
}