<?php

namespace Database\Seeders;

use App\Models\Categoria;
use App\Models\Marca;
use App\Models\Producto;
use App\Models\ProductoVariant;
use App\Models\Empresa;
use App\Models\Sucursal;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class MarySeeder extends Seeder
{
    public function run(): void
    {
        $empresa = Empresa::first();
        $sucursal = Sucursal::where('empresa_id', $empresa->id)->first();
        
        $categoria = Categoria::firstOrCreate(
            ['nombre' => 'Víveres', 'empresa_id' => $empresa->id],
            [
                'slug' => Str::slug('Víveres'),
                'descripcion' => 'Productos de despensa básica',
                'activo' => true,
                'sucursal_id' => $sucursal->id,
            ]
        );

        $marca = Marca::firstOrCreate(
            ['nombre' => 'Mary', 'empresa_id' => $empresa->id],
            [
                'slug' => Str::slug('Mary'),
                'descripcion' => 'Productos Mary',
                'activo' => true,
                'sucursal_id' => $sucursal->id,
            ]
        );

        $productos = [
            ['nombre' => 'Arroz Blanco Tradicional 900gr Mary', 'descripcion' => 'Arroz blanco tradicional de 900gr', 'precio_base' => 1.61, 'variantes' => [['nombre' => 'Peso: 900gr', 'values' => ['Peso' => '900gr'], 'sku' => 'ARZ-MARY-TRAD-900', 'precio_ajuste' => 0, 'cantidad' => 100]]],
            ['nombre' => 'Arroz Superior 900gr Mary', 'descripcion' => 'Arroz superior de 900gr', 'precio_base' => 1.85, 'variantes' => [['nombre' => 'Peso: 900gr', 'values' => ['Peso' => '900gr'], 'sku' => 'ARZ-MARY-SUP-900', 'precio_ajuste' => 0, 'cantidad' => 90]]],
            ['nombre' => 'Arroz Premium 900gr Mary', 'descripcion' => 'Arroz premium de 900gr', 'precio_base' => 2.67, 'variantes' => [['nombre' => 'Peso: 900gr', 'values' => ['Peso' => '900gr'], 'sku' => 'ARZ-MARY-PREM-900', 'precio_ajuste' => 0, 'cantidad' => 80]]],
            ['nombre' => 'Arroz Blanco Esmeralda 900gr Mary', 'descripcion' => 'Arroz blanco esmeralda de 900gr', 'precio_base' => 2.84, 'variantes' => [['nombre' => 'Peso: 900gr', 'values' => ['Peso' => '900gr'], 'sku' => 'ARZ-MARY-ESM-900', 'precio_ajuste' => 0, 'cantidad' => 75]]],
            ['nombre' => 'Arroz Integral 800gr Mary', 'descripcion' => 'Arroz integral de 800gr', 'precio_base' => 2.51, 'variantes' => [['nombre' => 'Peso: 800gr', 'values' => ['Peso' => '800gr'], 'sku' => 'ARZ-MARY-INT-800', 'precio_ajuste' => 0, 'cantidad' => 70]]],
            ['nombre' => 'Arroz Agua Blanca 1kg Mary', 'descripcion' => 'Arroz Agua Blanca de 1kg', 'precio_base' => 1.75, 'variantes' => [['nombre' => 'Peso: 1kg', 'values' => ['Peso' => '1kg'], 'sku' => 'ARZ-MARY-AGUA-1KG', 'precio_ajuste' => 0, 'cantidad' => 95]]],
            ['nombre' => 'Harina de Maíz Blanco 900gr Mary', 'descripcion' => 'Harina de maíz blanco de 900gr', 'precio_base' => 1.33, 'variantes' => [['nombre' => 'Peso: 900gr', 'values' => ['Peso' => '900gr'], 'sku' => 'HAR-MARY-MAIZ-900', 'precio_ajuste' => 0, 'cantidad' => 110]]],
            ['nombre' => 'Harina de Trigo Leudante 900gr Mary', 'descripcion' => 'Harina de trigo leudante de 900gr', 'precio_base' => 1.65, 'variantes' => [['nombre' => 'Peso: 900gr', 'values' => ['Peso' => '900gr'], 'sku' => 'HAR-MARY-TRIG-900', 'precio_ajuste' => 0, 'cantidad' => 100]]],
            ['nombre' => 'Pasta Larga Premium Linguini 500gr Mary', 'descripcion' => 'Pasta larga premium linguini de 500gr', 'precio_base' => 1.49, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-MARY-LING-500', 'precio_ajuste' => 0, 'cantidad' => 90]]],
            ['nombre' => 'Pasta Premium Macarron 500gr Mary', 'descripcion' => 'Pasta premium macarron de 500gr', 'precio_base' => 1.64, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-MARY-MAC-500', 'precio_ajuste' => 0, 'cantidad' => 85]]],
            ['nombre' => 'Pasta Premium Pluma 500gr Mary', 'descripcion' => 'Pasta premium pluma de 500gr', 'precio_base' => 1.64, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-MARY-PLUM-500', 'precio_ajuste' => 0, 'cantidad' => 85]]],
            ['nombre' => 'Crema de Arroz 450gr Mary', 'descripcion' => 'Crema de arroz de 450gr', 'precio_base' => 1.23, 'variantes' => [['nombre' => 'Peso: 450gr', 'values' => ['Peso' => '450gr'], 'sku' => 'CRE-MARY-450', 'precio_ajuste' => 0, 'cantidad' => 95]]],
            ['nombre' => 'Lentejas 400gr Mary', 'descripcion' => 'Lentejas de 400gr', 'precio_base' => 1.85, 'variantes' => [['nombre' => 'Peso: 400gr', 'values' => ['Peso' => '400gr'], 'sku' => 'LEN-MARY-400', 'precio_ajuste' => 0, 'cantidad' => 80]]],
            ['nombre' => 'Palmitos Enteros 400gr Mary', 'descripcion' => 'Palmitos enteros de 400gr', 'precio_base' => 5.90, 'variantes' => [['nombre' => 'Peso: 400gr', 'values' => ['Peso' => '400gr'], 'sku' => 'PAL-MARY-400', 'precio_ajuste' => 0, 'cantidad' => 60]]],
        ];

        foreach ($productos as $productoData) {
            $producto = Producto::create([
                'code' => strtoupper(substr(Str::slug($productoData['nombre']), 0, 3)) . '-' . rand(10000, 99999),
                'name' => $productoData['nombre'],
                'price' => $productoData['precio_base'],
                'precio_bs' => $productoData['precio_base'] * 35,
                'description' => $productoData['descripcion'],
                'quantity' => array_sum(array_column($productoData['variantes'], 'cantidad')),
                'quantity_alert' => 10,
                'status' => true,
                'empresa_id' => $empresa->id,
                'categoria_id' => $categoria->id,
                'marca_id' => $marca->id,
            ]);

            foreach ($productoData['variantes'] as $varianteData) {
                ProductoVariant::create([
                    'producto_id' => $producto->id,
                    'name' => $varianteData['nombre'],
                    'values' => $varianteData['values'],
                    'sku' => $varianteData['sku'],
                    'price_adjustment' => $varianteData['precio_ajuste'],
                    'quantity' => $varianteData['cantidad'],
                    'image_path' => null,
                    'image_thumbnail_path' => null,
                    'alt_text' => $varianteData['nombre'] . ' - ' . $productoData['nombre'],
                    'empresa_id' => $empresa->id,
                ]);
            }
        }

        $this->command->info('Mary: 14 productos creados con 14 variantes');
    }
}