<?php

namespace Database\Seeders;

use App\Models\Empresa;
use App\Models\Marca;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class MarcaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Obtener la primera empresa como ejemplo
        $empresa = Empresa::first();
        
        if ($empresa) {
            $marcas = [
                // Marcas tecnológicas internacionales
                [
                    'nombre' => 'Samsung',
                    'descripcion' => 'Electrónica y tecnología Samsung',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Apple',
                    'descripcion' => 'Productos Apple Inc.',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Nike',
                    'descripcion' => 'Ropa y calzado deportivo Nike',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Adidas',
                    'descripcion' => 'Ropa y accesorios Adidas',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Sony',
                    'descripcion' => 'Electrónica y entretenimiento Sony',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                
                // Marcas venezolanas
                [
                    'nombre' => 'Polar',
                    'descripcion' => 'Productos alimenticios Polar',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Empresas Polar',
                    'descripcion' => 'Conglomerado empresarial venezolano',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Santa Teresa',
                    'descripcion' => 'Ron Santa Teresa',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Alquería',
                    'descripcion' => 'Productos lácteos Alquería',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Kern',
                    'descripcion' => 'Bebidas Kern',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Nestlé Venezuela',
                    'descripcion' => 'Productos Nestlé en Venezuela',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Casera',
                    'descripcion' => 'Bebidas Casera',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Sabrosa',
                    'descripcion' => 'Productos Sabrosa',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Conchita',
                    'descripcion' => 'Productos Conchita',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'La Crema',
                    'descripcion' => 'Helados La Crema',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Dos Pinos',
                    'descripcion' => 'Productos lácteos Dos Pinos',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Brahma',
                    'descripcion' => 'Cerveza Brahma',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Yoko',
                    'descripcion' => 'Productos Yoko',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Colombina',
                    'descripcion' => 'Productos Colombina',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Ferrero Venezuela',
                    'descripcion' => 'Productos Ferrero en Venezuela',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ]
            ];

            foreach ($marcas as $marca) {
                Marca::updateOrCreate(
                    ['nombre' => $marca['nombre'], 'empresa_id' => $marca['empresa_id']],
                    array_merge($marca, ['slug' => Str::slug($marca['nombre'])])
                );
            }
        }
    }
}