<?php

namespace Database\Seeders;

use App\Models\Categoria;
use App\Models\Marca;
use App\Models\Producto;
use App\Models\ProductoVariant;
use App\Models\Empresa;
use App\Models\Sucursal;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class IberiaSeeder extends Seeder
{
    public function run(): void
    {
        $empresa = Empresa::first();
        $sucursal = Sucursal::where('empresa_id', $empresa->id)->first();
        
        $categoria = Categoria::firstOrCreate(
            ['nombre' => 'Víveres', 'empresa_id' => $empresa->id],
            [
                'slug' => Str::slug('Víveres'),
                'descripcion' => 'Productos de despensa básica',
                'activo' => true,
                'sucursal_id' => $sucursal->id,
            ]
        );

        $marca = Marca::firstOrCreate(
            ['nombre' => 'Iberia', 'empresa_id' => $empresa->id],
            [
                'slug' => Str::slug('Iberia'),
                'descripcion' => 'Productos Iberia',
                'activo' => true,
                'sucursal_id' => $sucursal->id,
            ]
        );

        $productos = [
            ['nombre' => 'Aceite de Oliva Extra Virgen 500ml Iberia', 'descripcion' => 'Aceite de oliva extra virgen de 500ml', 'precio_base' => 4.50, 'variantes' => [['nombre' => 'Volumen: 500ml', 'values' => ['Volumen' => '500ml'], 'sku' => 'ACE-IBE-OLI-500', 'precio_ajuste' => 0, 'cantidad' => 60]]],
            ['nombre' => 'Vinagre Blanco 500ml Iberia', 'descripcion' => 'Vinagre blanco de 500ml', 'precio_base' => 1.25, 'variantes' => [['nombre' => 'Volumen: 500ml', 'values' => ['Volumen' => '500ml'], 'sku' => 'VIN-IBE-BLA-500', 'precio_ajuste' => 0, 'cantidad' => 80]]],
            ['nombre' => 'Vinagre de Manzana 500ml Iberia', 'descripcion' => 'Vinagre de manzana de 500ml', 'precio_base' => 1.45, 'variantes' => [['nombre' => 'Volumen: 500ml', 'values' => ['Volumen' => '500ml'], 'sku' => 'VIN-IBE-MAN-500', 'precio_ajuste' => 0, 'cantidad' => 70]]],
            ['nombre' => 'Orégano Molido 15gr Iberia', 'descripcion' => 'Orégano molido de 15gr', 'precio_base' => 0.85, 'variantes' => [['nombre' => 'Peso: 15gr', 'values' => ['Peso' => '15gr'], 'sku' => 'ORE-IBE-15', 'precio_ajuste' => 0, 'cantidad' => 100]]],
            ['nombre' => 'Comino Molido 15gr Iberia', 'descripcion' => 'Comino molido de 15gr', 'precio_base' => 0.90, 'variantes' => [['nombre' => 'Peso: 15gr', 'values' => ['Peso' => '15gr'], 'sku' => 'COM-IBE-15', 'precio_ajuste' => 0, 'cantidad' => 95]]],
            ['nombre' => 'Pimienta Negra Molida 15gr Iberia', 'descripcion' => 'Pimienta negra molida de 15gr', 'precio_base' => 1.10, 'variantes' => [['nombre' => 'Peso: 15gr', 'values' => ['Peso' => '15gr'], 'sku' => 'PIM-IBE-15', 'precio_ajuste' => 0, 'cantidad' => 85]]],
            ['nombre' => 'Paprika Dulce 15gr Iberia', 'descripcion' => 'Paprika dulce de 15gr', 'precio_base' => 1.05, 'variantes' => [['nombre' => 'Peso: 15gr', 'values' => ['Peso' => '15gr'], 'sku' => 'PAP-IBE-15', 'precio_ajuste' => 0, 'cantidad' => 90]]],
            ['nombre' => 'Ajo en Polvo 15gr Iberia', 'descripcion' => 'Ajo en polvo de 15gr', 'precio_base' => 0.95, 'variantes' => [['nombre' => 'Peso: 15gr', 'values' => ['Peso' => '15gr'], 'sku' => 'AJO-IBE-15', 'precio_ajuste' => 0, 'cantidad' => 100]]],
            ['nombre' => 'Cebolla en Polvo 15gr Iberia', 'descripcion' => 'Cebolla en polvo de 15gr', 'precio_base' => 0.90, 'variantes' => [['nombre' => 'Peso: 15gr', 'values' => ['Peso' => '15gr'], 'sku' => 'CEB-IBE-15', 'precio_ajuste' => 0, 'cantidad' => 95]]],
            ['nombre' => 'Laurel Entero 10gr Iberia', 'descripcion' => 'Hojas de laurel enteras de 10gr', 'precio_base' => 0.80, 'variantes' => [['nombre' => 'Peso: 10gr', 'values' => ['Peso' => '10gr'], 'sku' => 'LAU-IBE-10', 'precio_ajuste' => 0, 'cantidad' => 80]]],
            ['nombre' => 'Tomillo Seco 10gr Iberia', 'descripcion' => 'Tomillo seco de 10gr', 'precio_base' => 0.85, 'variantes' => [['nombre' => 'Peso: 10gr', 'values' => ['Peso' => '10gr'], 'sku' => 'TOM-IBE-10', 'precio_ajuste' => 0, 'cantidad' => 75]]],
            ['nombre' => 'Romero Seco 10gr Iberia', 'descripcion' => 'Romero seco de 10gr', 'precio_base' => 0.90, 'variantes' => [['nombre' => 'Peso: 10gr', 'values' => ['Peso' => '10gr'], 'sku' => 'ROM-IBE-10', 'precio_ajuste' => 0, 'cantidad' => 70]]],
            ['nombre' => 'Albahaca Seca 10gr Iberia', 'descripcion' => 'Albahaca seca de 10gr', 'precio_base' => 0.95, 'variantes' => [['nombre' => 'Peso: 10gr', 'values' => ['Peso' => '10gr'], 'sku' => 'ALB-IBE-10', 'precio_ajuste' => 0, 'cantidad' => 85]]],
            ['nombre' => 'Perejil Seco 10gr Iberia', 'descripcion' => 'Perejil seco de 10gr', 'precio_base' => 0.80, 'variantes' => [['nombre' => 'Peso: 10gr', 'values' => ['Peso' => '10gr'], 'sku' => 'PER-IBE-10', 'precio_ajuste' => 0, 'cantidad' => 90]]],
            ['nombre' => 'Cilantro Seco 10gr Iberia', 'descripcion' => 'Cilantro seco de 10gr', 'precio_base' => 0.85, 'variantes' => [['nombre' => 'Peso: 10gr', 'values' => ['Peso' => '10gr'], 'sku' => 'CIL-IBE-10', 'precio_ajuste' => 0, 'cantidad' => 80]]],
            ['nombre' => 'Canela en Polvo 15gr Iberia', 'descripcion' => 'Canela en polvo de 15gr', 'precio_base' => 1.15, 'variantes' => [['nombre' => 'Peso: 15gr', 'values' => ['Peso' => '15gr'], 'sku' => 'CAN-IBE-15', 'precio_ajuste' => 0, 'cantidad' => 75]]],
            ['nombre' => 'Nuez Moscada Molida 10gr Iberia', 'descripcion' => 'Nuez moscada molida de 10gr', 'precio_base' => 1.35, 'variantes' => [['nombre' => 'Peso: 10gr', 'values' => ['Peso' => '10gr'], 'sku' => 'NUE-IBE-10', 'precio_ajuste' => 0, 'cantidad' => 60]]],
            ['nombre' => 'Clavo de Olor Entero 10gr Iberia', 'descripcion' => 'Clavo de olor entero de 10gr', 'precio_base' => 1.25, 'variantes' => [['nombre' => 'Peso: 10gr', 'values' => ['Peso' => '10gr'], 'sku' => 'CLA-IBE-10', 'precio_ajuste' => 0, 'cantidad' => 65]]],
            ['nombre' => 'Jengibre en Polvo 15gr Iberia', 'descripcion' => 'Jengibre en polvo de 15gr', 'precio_base' => 1.20, 'variantes' => [['nombre' => 'Peso: 15gr', 'values' => ['Peso' => '15gr'], 'sku' => 'JEN-IBE-15', 'precio_ajuste' => 0, 'cantidad' => 70]]],
            ['nombre' => 'Curry en Polvo 15gr Iberia', 'descripcion' => 'Curry en polvo de 15gr', 'precio_base' => 1.30, 'variantes' => [['nombre' => 'Peso: 15gr', 'values' => ['Peso' => '15gr'], 'sku' => 'CUR-IBE-15', 'precio_ajuste' => 0, 'cantidad' => 65]]],
            ['nombre' => 'Cúrcuma en Polvo 15gr Iberia', 'descripcion' => 'Cúrcuma en polvo de 15gr', 'precio_base' => 1.10, 'variantes' => [['nombre' => 'Peso: 15gr', 'values' => ['Peso' => '15gr'], 'sku' => 'CUR-IBE-POL-15', 'precio_ajuste' => 0, 'cantidad' => 75]]],
            ['nombre' => 'Adobo Completo 25gr Iberia', 'descripcion' => 'Adobo completo de 25gr', 'precio_base' => 1.40, 'variantes' => [['nombre' => 'Peso: 25gr', 'values' => ['Peso' => '25gr'], 'sku' => 'ADO-IBE-25', 'precio_ajuste' => 0, 'cantidad' => 80]]],
            ['nombre' => 'Sazón Completo 25gr Iberia', 'descripcion' => 'Sazón completo de 25gr', 'precio_base' => 1.35, 'variantes' => [['nombre' => 'Peso: 25gr', 'values' => ['Peso' => '25gr'], 'sku' => 'SAZ-IBE-25', 'precio_ajuste' => 0, 'cantidad' => 85]]],
        ];

        foreach ($productos as $productoData) {
            $producto = Producto::create([
                'code' => strtoupper(substr(Str::slug($productoData['nombre']), 0, 3)) . '-' . rand(10000, 99999),
                'name' => $productoData['nombre'],
                'price' => $productoData['precio_base'],
                'precio_bs' => $productoData['precio_base'] * 35,
                'description' => $productoData['descripcion'],
                'quantity' => array_sum(array_column($productoData['variantes'], 'cantidad')),
                'quantity_alert' => 10,
                'status' => true,
                'empresa_id' => $empresa->id,
                'categoria_id' => $categoria->id,
                'marca_id' => $marca->id,
            ]);

            foreach ($productoData['variantes'] as $varianteData) {
                ProductoVariant::create([
                    'producto_id' => $producto->id,
                    'name' => $varianteData['nombre'],
                    'values' => $varianteData['values'],
                    'sku' => $varianteData['sku'],
                    'price_adjustment' => $varianteData['precio_ajuste'],
                    'quantity' => $varianteData['cantidad'],
                    'image_path' => null,
                    'image_thumbnail_path' => null,
                    'alt_text' => $varianteData['nombre'] . ' - ' . $productoData['nombre'],
                    'empresa_id' => $empresa->id,
                ]);
            }
        }

        $this->command->info('Iberia: 23 productos creados con 23 variantes');
    }
}