# 🎯 Guía del Seeder de Empleados

## 📋 Descripción
Este seeder crea empleados con sus usuarios relacionados, asignando automáticamente el rol de "Empleado" a cada usuario creado.

## 🏗️ Estructura de Datos

### Campos del Empleado (`empleados`)
- **Código**: Único (EMP0001, EMP0002, etc.)
- **Datos Personales**: nombres, apellidos, documento, tipo_documento, email, telefono
- **Datos Demográficos**: fecha_nacimiento, genero, direccion, estado_civil
- **Información Laboral**: cargo, departamento, salario, fecha_ingreso, fecha_salida
- **Emergencia**: contacto_emergencia, telefono_emergencia
- **Adicionales**: observaciones, status (activo/inactivo)
- **Relaciones**: empresa_id, sucursal_id, user_id

### Campos del Usuario (`users`)
- **Credenciales**: name, username, email, password
- **Contacto**: telefono
- **Verificación**: email_verified_at
- **Empresa**: empresa_id, sucursal_id
- **Estado**: status (activo/inactivo)
- **Rol**: "Empleado" (asignado automáticamente)

## 🚀 Cómo Ejecutar

### Opción 1: Ejecutar todos los seeders
```bash
php artisan db:seed
```

### Opción 2: Ejecutar solo el seeder de empleados
```bash
# Sin reiniciar la base de datos
php artisan seed:empleados

# Reiniciando toda la base de datos (CUIDADO)
php artisan seed:empleados --fresh
```

### Opción 3: Ejecutar solo el seeder de empleados (método tradicional)
```bash
php artisan db:seed --class=EmpleadosTableSeeder
```

## 👥 Empleados de Ejemplo Creados

| Nombre | Email | Cargo | Departamento | Salario |
|--------|-------|--------|---------------|---------|
| Carlos Rodríguez | carlos.rodriguez@empresa.com | Gerente de Ventas | Ventas | $2,500 |
| Ana González | ana.gonzalez@empresa.com | Supervisora de Almacén | Logística | $1,800 |
| Luis Martínez | luis.martinez@empresa.com | Asistente Administrativo | Administración | $1,500 |
| María Fernández | maria.fernandez@empresa.com | Cajera | Caja | $1,200 |
| Jorge Pérez | jorge.perez@empresa.com | Vendedor | Ventas | $1,400 |

## 🔑 Credenciales de Acceso

- **Contraseña por defecto**: `password123`
- **Rol asignado**: `Empleado`
- **URL de login**: `/login`

## 🛠️ Personalización

### Para agregar más empleados:
1. Abre el archivo `EmpleadosTableSeeder.php`
2. Agrega nuevos empleados al array `$empleadosData`
3. Ejecuta el seeder nuevamente

### Para cambiar contraseñas:
```bash
php artisan tinker
>>> $user = App\Models\User::where('email', 'carlos.rodriguez@empresa.com')->first();
>>> $user->password = bcrypt('nueva_contraseña');
>>> $user->save();
```

## ⚠️ Notas Importantes

1. **Empresa y Sucursal**: Si no existen, se crean automáticamente
2. **Códigos de Empleado**: Se generan automáticamente (EMP0001, EMP0002, etc.)
3. **Usernames**: Se generan a partir del nombre completo
4. **Roles**: Se asigna automáticamente el rol "Empleado"
5. **Verificación de Email**: Los usuarios se crean con email verificado

## 🔄 Integración con el Sistema

Los empleados creados pueden:
- ✅ Iniciar sesión en el sistema
- ✅ Acceder al dashboard de empleados
- ✅ Gestionar pedidos asignados
- ✅ Ver estadísticas de rendimiento
- ✅ Actualizar su perfil

## 📊 Verificación

Para verificar que el seeder funcionó correctamente:

```bash
# Ver empleados creados
php artisan tinker
>>> App\Models\Empleado::count();
>>> App\Models\Empleado::with('user')->get();

# Ver usuarios con rol Empleado
php artisan tinker
>>> $empleados = App\Models\User::role('Empleado')->get();
```

## 🆘 Solución de Problemas

### Error: "Route [admin.orders.index] not defined"
Este error ocurre si el dashboard de empleados intenta acceder a rutas que no existen. Asegúrate de que las rutas estén definidas.

### Error: "Empresa no encontrada"
Asegúrate de ejecutar primero los seeders base:
```bash
php artisan db:seed --class=RolesAndPermissionsSeeder
php artisan db:seed --class=EmpresaSeeder
php artisan db:seed --class=SucursalSeeder
```

### Error: "Role 'Empleado' no existe"
Ejecuta primero el seeder de roles:
```bash
php artisan db:seed --class=RolesAndPermissionsSeeder
```
