<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Producto;
use App\Models\Marca;
use App\Models\Categoria;

class CigarrosSeeder extends Seeder
{
    public function run(): void
    {
        $categoria = Categoria::where('nombre', 'Cigarros')->first();

        // Marlboro
        $marlboro = Marca::where('nombre', 'Marlboro')->first();
        $productosMarlboro = [
            ['nombre' => 'Marlboro Red Box', 'precio' => 15.50],
            ['nombre' => 'Marlboro Gold Box', 'precio' => 15.50],
            ['nombre' => 'Marlboro Menthol Box', 'precio' => 15.50],
            ['nombre' => 'Marlboro Ice Blast', 'precio' => 16.00],
        ];

        foreach ($productosMarlboro as $producto) {
            Producto::create([
                'nombre' => $producto['nombre'],
                'precio' => $producto['precio'],
                'marca_id' => $marlboro->id,
                'categoria_id' => $categoria->id,
                'activo' => true,
            ]);
        }

        // Lucky Strike
        $lucky = Marca::where('nombre', 'Lucky Strike')->first();
        $productosLucky = [
            ['nombre' => 'Lucky Strike Original', 'precio' => 14.50],
            ['nombre' => 'Lucky Strike Blue', 'precio' => 14.50],
            ['nombre' => 'Lucky Strike Silver', 'precio' => 14.50],
        ];

        foreach ($productosLucky as $producto) {
            Producto::create([
                'nombre' => $producto['nombre'],
                'precio' => $producto['precio'],
                'marca_id' => $lucky->id,
                'categoria_id' => $categoria->id,
                'activo' => true,
            ]);
        }

        // Camel
        $camel = Marca::where('nombre', 'Camel')->first();
        $productosCamel = [
            ['nombre' => 'Camel Blue', 'precio' => 15.00],
            ['nombre' => 'Camel Yellow', 'precio' => 15.00],
            ['nombre' => 'Camel Filters', 'precio' => 15.00],
        ];

        foreach ($productosCamel as $producto) {
            Producto::create([
                'nombre' => $producto['nombre'],
                'precio' => $producto['precio'],
                'marca_id' => $camel->id,
                'categoria_id' => $categoria->id,
                'activo' => true,
            ]);
        }
    }
}