<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Producto;
use App\Models\Marca;
use App\Models\Categoria;

class AliveSeeder extends Seeder
{
    public function run(): void
    {
        $marca = Marca::where('nombre', 'Alive')->first();
        $categoria = Categoria::where('nombre', 'Bebidas')->first();

        $productos = [
            ['nombre' => 'Alive Naranja 500ml', 'precio' => 2.50],
            ['nombre' => 'Alive Manzana 500ml', 'precio' => 2.50],
            ['nombre' => 'Alive Uva 500ml', 'precio' => 2.50],
            ['nombre' => 'Alive Tropical 500ml', 'precio' => 2.75],
            ['nombre' => 'Alive Limón 500ml', 'precio' => 2.50],
            ['nombre' => 'Alive Durazno 500ml', 'precio' => 2.75],
            ['nombre' => 'Alive Maracuyá 500ml', 'precio' => 2.75],
            ['nombre' => 'Alive Piña 500ml', 'precio' => 2.75],
        ];

        foreach ($productos as $producto) {
            Producto::create([
                'nombre' => $producto['nombre'],
                'precio' => $producto['precio'],
                'marca_id' => $marca->id,
                'categoria_id' => $categoria->id,
                'activo' => true,
            ]);
        }
    }
}