<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('pedidos', function (Blueprint $table) {
            $table->decimal('subtotal_usd', 20, 2)->default(0)->after('total_bs');
            $table->decimal('subtotal_bs', 20, 2)->default(0)->after('subtotal_usd');
            $table->decimal('discount_total_usd', 20, 2)->default(0)->after('subtotal_bs');
            $table->decimal('discount_total_bs', 20, 2)->default(0)->after('discount_total_usd');
            $table->string('coupon_code')->nullable()->after('discount_total_bs');
        });
    }

    public function down()
    {
        Schema::table('pedidos', function (Blueprint $table) {
            $table->dropColumn([
                'subtotal_usd',
                'subtotal_bs',
                'discount_total_usd',
                'discount_total_bs',
                'coupon_code',
            ]);
        });
    }
};
