<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('coupon_redemptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('coupon_id')->constrained('coupons')->onDelete('cascade');
            $table->foreignId('pedido_id')->constrained('pedidos')->onDelete('cascade');
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('empresa_id')->constrained('empresas')->onDelete('cascade');
            $table->decimal('discount_usd', 20, 2)->default(0);
            $table->decimal('discount_bs', 20, 2)->default(0);
            $table->dateTime('redeemed_at');
            $table->timestamps();

            $table->index(['coupon_id', 'user_id']);
            $table->unique(['coupon_id', 'pedido_id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('coupon_redemptions');
    }
};
