<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('promotion_conditions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('promotion_id')->constrained('promotions')->onDelete('cascade');
            $table->enum('type', ['min_amount', 'products_in', 'categories_in', 'first_order', 'customer_segment']);
            $table->string('operator')->nullable();
            $table->decimal('value', 20, 2)->nullable();
            $table->json('data')->nullable();
            $table->timestamps();

            $table->index(['promotion_id', 'type']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('promotion_conditions');
    }
};
