<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('promotions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('empresa_id')->constrained('empresas')->onDelete('cascade');
            $table->string('name');
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->boolean('is_automatic')->default(false);
            $table->boolean('stackable')->default(false);
            $table->integer('priority')->default(0);
            $table->enum('discount_type', ['percent', 'fixed', 'bxgy']);
            $table->decimal('discount_value', 20, 2)->nullable();
            $table->integer('buy_qty')->nullable();
            $table->integer('get_qty')->nullable();
            $table->dateTime('starts_at')->nullable();
            $table->dateTime('ends_at')->nullable();
            $table->integer('max_uses')->nullable();
            $table->integer('max_uses_per_user')->nullable();
            $table->integer('uses_count')->default(0);
            $table->json('metadata')->nullable();
            $table->timestamps();

            $table->index(['empresa_id', 'is_active', 'is_automatic']);
            $table->index(['starts_at', 'ends_at']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('promotions');
    }
};
