<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('caja_movimientos', function (Blueprint $table) {
            $table->unsignedBigInteger('aprobado_por')->nullable()->after('referencia');
            $table->string('ip_address')->nullable()->after('aprobado_por');
            $table->text('user_agent')->nullable()->after('ip_address');
            $table->text('motivo_rechazo')->nullable()->after('user_agent');
            $table->enum('estado_aprobacion', ['pendiente', 'aprobado', 'rechazado'])->default('pendiente')->after('motivo_rechazo');

            $table->foreign('aprobado_por')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('caja_movimientos', function (Blueprint $table) {
            $table->dropForeign(['aprobado_por']);
            $table->dropColumn(['aprobado_por', 'ip_address', 'user_agent', 'motivo_rechazo', 'estado_aprobacion']);
        });
    }
};
