<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('caja_movimientos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('caja_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // Usuario que realizó el movimiento
            $table->enum('tipo', ['ingreso', 'salida']); // Tipo de movimiento
            $table->enum('tipo_salida', ['vuelto', 'compra', 'retiro', 'otro'])->nullable(); // Tipo específico de salida
            $table->decimal('monto', 10, 2); // Monto del movimiento
            $table->string('motivo', 500)->nullable(); // Motivo del movimiento
            $table->enum('metodo_pago', ['efectivo', 'transferencia', 'tarjeta', 'pago_movil', 'punto_de_venta'])->nullable(); // Método de pago (solo para ingresos)
            $table->string('referencia', 100)->nullable(); // Referencia (ej: número de venta, pedido, etc.)
            $table->timestamps();

            $table->index(['caja_id', 'tipo']);
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('caja_movimientos');
    }
};
