<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up()
    {
        Schema::table('cotizaciones', function (Blueprint $table) {
            // Agregar nota_venta_id si no existe
            if (!Schema::hasColumn('cotizaciones', 'nota_venta_id')) {
                $table->foreignId('nota_venta_id')->nullable()->constrained('notas_venta');
            }
        });

        // Modificar el enum para incluir 'convertida'
        DB::statement("ALTER TABLE cotizaciones MODIFY COLUMN estado ENUM('pendiente', 'aprobada', 'rechazada', 'vencida', 'convertida') DEFAULT 'pendiente'");
    }

    public function down()
    {
        // Revertir el enum
        DB::statement("ALTER TABLE cotizaciones MODIFY COLUMN estado ENUM('pendiente', 'aprobada', 'rechazada', 'vencida') DEFAULT 'pendiente'");
        
        Schema::table('cotizaciones', function (Blueprint $table) {
            if (Schema::hasColumn('cotizaciones', 'nota_venta_id')) {
                $table->dropForeign(['nota_venta_id']);
                $table->dropColumn('nota_venta_id');
            }
        });
    }
};