<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('notas_venta', function (Blueprint $table) {
            $table->id();
            $table->string('serie', 10);
            $table->string('numero', 20);
            $table->date('fecha_emision');
            $table->date('fecha_vencimiento')->nullable();
            $table->foreignId('cliente_id')->constrained('clientes');
            $table->text('observaciones')->nullable();
            $table->decimal('subtotal', 10, 2)->default(0);
            $table->decimal('impuestos', 10, 2)->default(0);
            $table->decimal('total', 10, 2)->default(0);
            $table->enum('estado', ['pendiente', 'procesada', 'anulada'])->default('pendiente');
            $table->foreignId('empresa_id')->constrained('empresas');
            $table->foreignId('sucursal_id')->constrained('sucursales');
            $table->foreignId('user_id')->constrained('users');
            $table->timestamps();

            $table->unique(['serie', 'numero', 'empresa_id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('notas_venta');
    }
};