<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('detalle_pedidos', function (Blueprint $table) {
            $table->unsignedBigInteger('variant_id')->nullable()->after('productoId');
            $table->string('product_name')->nullable()->after('variant_id');
            
            $table->foreign('variant_id')->references('id')->on('producto_variants')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('detalle_pedidos', function (Blueprint $table) {
            $table->dropForeign(['variant_id']);
            $table->dropColumn(['variant_id', 'product_name']);
        });
    }
};