<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('empleado_pedido')) {
            Schema::create('empleado_pedido', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('empleadoId');
                $table->unsignedBigInteger('pedidoId');
                $table->timestamps();

                $table->foreign('empleadoId')->references('id')->on('empleados')->onDelete('cascade');
                $table->foreign('pedidoId')->references('id')->on('pedidos')->onDelete('cascade');
                
                $table->unique(['empleadoId', 'pedidoId']);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('empleado_pedido');
    }
};
