<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('referencias_bancarias', function (Blueprint $table) {
            $table->id();
            $table->foreignId('pedido_id')->constrained('pedidos')->onDelete('cascade');
            $table->enum('tipo_pago', ['pago_movil', 'transferencia']);
            $table->foreignId('banco_id')->constrained('bancos');
            $table->string('documento')->nullable();
            $table->string('numero_telefono')->nullable();
            $table->string('numero_cuenta')->nullable();
            $table->enum('tipo_cuenta', ['ahorro', 'corriente'])->nullable();
            $table->string('referencia');
            $table->decimal('monto_efectivo', 10, 2)->nullable();
            $table->decimal('monto_restante', 10, 2)->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('referencias_bancarias');
    }
};