<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('username')->unique()->nullable()->after('name');
            $table->string('telefono')->nullable()->after('email');
        });
        
        // Para los usuarios existentes, generar un username basado en su email
        DB::table('users')->whereNull('username')->get()->each(function ($user) {
            $username = Str::slug(explode('@', $user->email)[0]);
            // Asegurarse de que el username sea único
            $count = 1;
            $originalUsername = $username;
            while (DB::table('users')->where('username', $username)->exists()) {
                $username = $originalUsername . $count;
                $count++;
            }
            DB::table('users')->where('id', $user->id)->update(['username' => $username]);
        });
        
        // Ahora hacer el campo username no nullable
        Schema::table('users', function (Blueprint $table) {
            $table->string('username')->nullable(false)->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['username', 'telefono']);
        });
    }
};