<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('productos', function (Blueprint $table) {
            // Agregar índices para mejorar el rendimiento de búsqueda
            // Se eliminó el índice compuesto en [name, description] por posibles problemas con TEXT
            $table->index('name');
            $table->index('price');
            $table->index('quantity');
            $table->index(['status', 'quantity']);
            
            // Considerar full-text search para búsquedas avanzadas en name y description
            // $table->fullText(['name', 'description']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('productos', function (Blueprint $table) {
            $table->dropIndex(['name']);
            $table->dropIndex(['price']);
            $table->dropIndex(['quantity']);
            $table->dropIndex(['status', 'quantity']);
            
            // $table->dropFullText(['name', 'description']);
        });
    }
};